/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncSearchResultListener;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.controls.SimplePagedResultsControl;
import com.unboundid.ldap.sdk.unboundidds.tools.ManageAccount;
import com.unboundid.ldap.sdk.unboundidds.tools.ManageAccountProcessor;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

final class ManageAccountSearchOperation
implements AsyncSearchResultListener {
    private static final long serialVersionUID = 5568681845030018155L;
    @Nullable
    private volatile AsyncRequestID asyncRequestID;
    @NotNull
    private final AtomicInteger entryCounter;
    @NotNull
    private final AtomicInteger referenceCounter;
    @NotNull
    private final ConcurrentHashMap<DN, DN> dnsProcessed;
    private final int simplePageSize;
    @NotNull
    private final LDAPConnectionPool pool;
    @NotNull
    private final ManageAccount manageAccount;
    @NotNull
    private final ManageAccountProcessor manageAccountProcessor;
    @NotNull
    private final SearchRequest searchRequest;

    ManageAccountSearchOperation(@NotNull ManageAccount manageAccount, @NotNull ManageAccountProcessor manageAccountProcessor, @NotNull LDAPConnectionPool pool, @NotNull String baseDN, @NotNull Filter filter, int simplePageSize) {
        this.manageAccount = manageAccount;
        this.manageAccountProcessor = manageAccountProcessor;
        this.pool = pool;
        this.simplePageSize = simplePageSize;
        this.searchRequest = new SearchRequest((SearchResultListener)this, baseDN, SearchScope.SUB, filter, "1.1");
        this.searchRequest.setResponseTimeoutMillis(3600000L);
        this.dnsProcessed = new ConcurrentHashMap(StaticUtils.computeMapCapacity(10));
        this.entryCounter = new AtomicInteger(0);
        this.referenceCounter = new AtomicInteger(0);
    }

    void doSearch() {
        ASN1OctetString cookie = null;
        while (true) {
            SearchResult searchResult;
            if (this.simplePageSize > 0) {
                this.searchRequest.setControls(new SimplePagedResultsControl(this.simplePageSize, cookie, false));
            }
            if ((searchResult = this.doSearchWithRetry()).getResultCode() != ResultCode.SUCCESS || this.simplePageSize <= 0) break;
            try {
                SimplePagedResultsControl responseControl = SimplePagedResultsControl.get(searchResult);
                if (!responseControl.moreResultsToReturn()) break;
                cookie = responseControl.getCookie();
            }
            catch (Exception e) {
                this.manageAccountProcessor.handleMessage(ToolMessages.ERR_MANAGE_ACCT_SEARCH_OP_ERROR_READING_PAGE_RESPONSE.get(String.valueOf(searchResult), String.valueOf(this.searchRequest.getFilter()), StaticUtils.getExceptionMessage(e)), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private SearchResult doSearchWithRetry() {
        LDAPConnection conn;
        this.dnsProcessed.clear();
        this.entryCounter.set(0);
        this.referenceCounter.set(0);
        try {
            conn = this.pool.getConnection();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            String message = ToolMessages.ERR_MANAGE_ACCT_SEARCH_OP_CANNOT_GET_CONNECTION.get(String.valueOf(this.searchRequest), StaticUtils.getExceptionMessage(le));
            this.manageAccountProcessor.handleMessage(message, true);
            return new SearchResult(this.searchRequest.getLastMessageID(), ResultCode.CONNECT_ERROR, message, null, null, this.entryCounter.get(), this.referenceCounter.get(), null);
        }
        boolean alreadyReleased = false;
        boolean releaseAsDefunct = true;
        try {
            SearchResult searchResult;
            LDAPResult result = null;
            try {
                this.asyncRequestID = conn.asyncSearch(this.searchRequest);
                result = this.asyncRequestID.get();
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                result = le.toLDAPResult();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            finally {
                this.asyncRequestID = null;
            }
            if (result != null && result.getResultCode().isConnectionUsable()) {
                SearchResult e;
                releaseAsDefunct = false;
                if (result.getResultCode() == ResultCode.SUCCESS) {
                    if (this.simplePageSize > 0) {
                        this.manageAccountProcessor.handleMessage(ToolMessages.INFO_MANAGE_ACCT_SEARCH_OP_SUCCESSFUL_PAGE.get(String.valueOf(this.searchRequest.getFilter()), this.entryCounter.get()), false);
                    } else {
                        this.manageAccountProcessor.handleMessage(ToolMessages.INFO_MANAGE_ACCT_SEARCH_OP_SUCCESSFUL_FULL.get(String.valueOf(this.searchRequest.getFilter()), this.entryCounter.get()), false);
                    }
                } else {
                    this.manageAccountProcessor.handleMessage(ToolMessages.ERR_MANAGE_ACCT_SEARCH_OP_FAILED_NO_RETRY.get(String.valueOf(this.searchRequest.getFilter()), result.getResultCode(), result.getDiagnosticMessage()), true);
                }
                if (result instanceof SearchResult) {
                    e = (SearchResult)result;
                    return e;
                }
                e = new SearchResult(result.getMessageID(), result.getResultCode(), result.getDiagnosticMessage(), result.getMatchedDN(), result.getReferralURLs(), this.entryCounter.get(), this.referenceCounter.get(), result.getResponseControls());
                return e;
            }
            this.entryCounter.set(0);
            this.referenceCounter.set(0);
            try {
                alreadyReleased = true;
                conn = this.pool.replaceDefunctConnection(conn);
                alreadyReleased = false;
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                String message = ToolMessages.ERR_MANAGE_ACCT_SEARCH_OP_CANNOT_GET_CONNECTION.get(String.valueOf(this.searchRequest), StaticUtils.getExceptionMessage(le));
                this.manageAccountProcessor.handleMessage(message, true);
                SearchResult searchResult2 = new SearchResult(this.searchRequest.getLastMessageID(), ResultCode.CONNECT_ERROR, message, null, null, this.entryCounter.get(), this.referenceCounter.get(), null);
                if (!alreadyReleased) {
                    if (releaseAsDefunct) {
                        this.pool.releaseDefunctConnection(conn);
                    } else {
                        this.pool.releaseConnection(conn);
                    }
                }
                return searchResult2;
            }
            try {
                this.asyncRequestID = conn.asyncSearch(this.searchRequest);
                result = this.asyncRequestID.get();
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                result = le.toLDAPResult();
            }
            catch (Exception e) {
                Debug.debugException(e);
                result = new SearchResult(this.searchRequest.getLastMessageID(), ResultCode.LOCAL_ERROR, ToolMessages.ERR_MANAGE_ACCT_SEARCH_OP_EXCEPTION.get(String.valueOf(this.searchRequest), StaticUtils.getExceptionMessage(e)), null, null, this.entryCounter.get(), this.referenceCounter.get(), null);
            }
            finally {
                this.asyncRequestID = null;
            }
            if (result.getResultCode() == ResultCode.SUCCESS) {
                if (this.simplePageSize > 0) {
                    this.manageAccountProcessor.handleMessage(ToolMessages.INFO_MANAGE_ACCT_SEARCH_OP_SUCCESSFUL_PAGE.get(String.valueOf(this.searchRequest.getFilter()), this.entryCounter.get()), false);
                } else {
                    this.manageAccountProcessor.handleMessage(ToolMessages.INFO_MANAGE_ACCT_SEARCH_OP_SUCCESSFUL_FULL.get(String.valueOf(this.searchRequest.getFilter()), this.entryCounter.get()), false);
                }
            } else {
                this.manageAccountProcessor.handleMessage(ToolMessages.ERR_MANAGE_ACCT_SEARCH_OP_FAILED_SECOND_ATTEMPT.get(String.valueOf(this.searchRequest.getFilter()), result.getResultCode(), result.getDiagnosticMessage()), true);
            }
            if (result.getResultCode().isConnectionUsable()) {
                releaseAsDefunct = false;
            }
            if (result instanceof SearchResult) {
                searchResult = (SearchResult)result;
                return searchResult;
            }
            searchResult = new SearchResult(result.getMessageID(), result.getResultCode(), result.getDiagnosticMessage(), result.getMatchedDN(), result.getReferralURLs(), this.entryCounter.get(), this.referenceCounter.get(), result.getResponseControls());
            return searchResult;
        }
        finally {
            if (!alreadyReleased) {
                if (releaseAsDefunct) {
                    this.pool.releaseDefunctConnection(conn);
                } else {
                    this.pool.releaseConnection(conn);
                }
            }
        }
    }

    void cancelSearch() {
        if (this.asyncRequestID != null) {
            this.asyncRequestID.cancel(true);
        }
    }

    @Override
    public void searchEntryReturned(@NotNull SearchResultEntry searchEntry) {
        this.entryCounter.incrementAndGet();
        DN parsedDN = null;
        try {
            parsedDN = searchEntry.getParsedDN();
            if (this.dnsProcessed.containsKey(parsedDN)) {
                return;
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        this.manageAccountProcessor.process(searchEntry.getDN());
        if (parsedDN != null) {
            this.dnsProcessed.put(parsedDN, parsedDN);
        }
    }

    @Override
    public void searchReferenceReturned(@NotNull SearchResultReference searchReference) {
        this.referenceCounter.incrementAndGet();
        this.manageAccountProcessor.handleMessage(ToolMessages.WARN_MANAGE_ACCT_SEARCH_OP_REFERRAL.get(String.valueOf(this.searchRequest.getFilter()), String.valueOf(searchReference)), true);
    }

    @Override
    public void searchResultReceived(@NotNull AsyncRequestID requestID, @NotNull SearchResult searchResult) {
    }
}

