/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.extended;

import com.ximpleware.extended.BookMarkHuge;
import com.ximpleware.extended.ContextBuffer;
import com.ximpleware.extended.ElementFragmentNsHuge;
import com.ximpleware.extended.FastIntBuffer;
import com.ximpleware.extended.IByteBuffer;
import com.ximpleware.extended.IIntBuffer;
import com.ximpleware.extended.ILongBuffer;
import com.ximpleware.extended.NavExceptionHuge;
import com.ximpleware.extended.parser.ISO8859_10;
import com.ximpleware.extended.parser.ISO8859_11;
import com.ximpleware.extended.parser.ISO8859_13;
import com.ximpleware.extended.parser.ISO8859_14;
import com.ximpleware.extended.parser.ISO8859_15;
import com.ximpleware.extended.parser.ISO8859_2;
import com.ximpleware.extended.parser.ISO8859_3;
import com.ximpleware.extended.parser.ISO8859_4;
import com.ximpleware.extended.parser.ISO8859_5;
import com.ximpleware.extended.parser.ISO8859_6;
import com.ximpleware.extended.parser.ISO8859_7;
import com.ximpleware.extended.parser.ISO8859_8;
import com.ximpleware.extended.parser.ISO8859_9;
import com.ximpleware.extended.parser.UTF8Char;
import com.ximpleware.extended.parser.WIN1250;
import com.ximpleware.extended.parser.WIN1251;
import com.ximpleware.extended.parser.WIN1252;
import com.ximpleware.extended.parser.WIN1253;
import com.ximpleware.extended.parser.WIN1254;
import com.ximpleware.extended.parser.WIN1255;
import com.ximpleware.extended.parser.WIN1256;
import com.ximpleware.extended.parser.WIN1257;
import com.ximpleware.extended.parser.WIN1258;

public class VTDNavHuge {
    public static final int ROOT = 0;
    public static final int PARENT = 1;
    public static final int FIRST_CHILD = 2;
    public static final int LAST_CHILD = 3;
    public static final int NEXT_SIBLING = 4;
    public static final int PREV_SIBLING = 5;
    public static final int R = 0;
    public static final int P = 1;
    public static final int FC = 2;
    public static final int LC = 3;
    public static final int NS = 4;
    public static final int PS = 5;
    public static final int TOKEN_STARTING_TAG = 0;
    public static final int TOKEN_ENDING_TAG = 1;
    public static final int TOKEN_ATTR_NAME = 2;
    public static final int TOKEN_ATTR_NS = 3;
    public static final int TOKEN_ATTR_VAL = 4;
    public static final int TOKEN_CHARACTER_DATA = 5;
    public static final int TOKEN_COMMENT = 6;
    public static final int TOKEN_PI_NAME = 7;
    public static final int TOKEN_PI_VAL = 8;
    public static final int TOKEN_DEC_ATTR_NAME = 9;
    public static final int TOKEN_DEC_ATTR_VAL = 10;
    public static final int TOKEN_CDATA_VAL = 11;
    public static final int TOKEN_DTD_VAL = 12;
    public static final int TOKEN_DOCUMENT = 13;
    public static final int FORMAT_UTF8 = 2;
    public static final int FORMAT_ASCII = 0;
    public static final int FORMAT_ISO_8859_1 = 1;
    public static final int FORMAT_ISO_8859_2 = 3;
    public static final int FORMAT_ISO_8859_3 = 4;
    public static final int FORMAT_ISO_8859_4 = 5;
    public static final int FORMAT_ISO_8859_5 = 6;
    public static final int FORMAT_ISO_8859_6 = 7;
    public static final int FORMAT_ISO_8859_7 = 8;
    public static final int FORMAT_ISO_8859_8 = 9;
    public static final int FORMAT_ISO_8859_9 = 10;
    public static final int FORMAT_ISO_8859_10 = 11;
    public static final int FORMAT_ISO_8859_11 = 12;
    public static final int FORMAT_ISO_8859_12 = 13;
    public static final int FORMAT_ISO_8859_13 = 14;
    public static final int FORMAT_ISO_8859_14 = 15;
    public static final int FORMAT_ISO_8859_15 = 16;
    public static final int FORMAT_ISO_8859_16 = 17;
    public static final int FORMAT_WIN_1250 = 18;
    public static final int FORMAT_WIN_1251 = 19;
    public static final int FORMAT_WIN_1252 = 20;
    public static final int FORMAT_WIN_1253 = 21;
    public static final int FORMAT_WIN_1254 = 22;
    public static final int FORMAT_WIN_1255 = 23;
    public static final int FORMAT_WIN_1256 = 24;
    public static final int FORMAT_WIN_1257 = 25;
    public static final int FORMAT_WIN_1258 = 26;
    public static final int FORMAT_UTF_16LE = 64;
    public static final int FORMAT_UTF_16BE = 63;
    protected static final long MASK_TOKEN_FULL_LEN = 36028522141057024L;
    private static final long MASK_TOKEN_PRE_LEN = 0x7F000000000000L;
    private static final long MASK_TOKEN_QN_LEN = 0xFFC000000000L;
    private static final long MASK_TOKEN_OFFSET = 0x3FFFFFFFFFL;
    private static final long MASK_TOKEN_TYPE = -1152921504606846976L;
    private static final long MASK_TOKEN_DEPTH = 0xF80000000000000L;
    protected int rootIndex;
    protected int nestingLevel;
    protected int[] context;
    protected boolean atTerminal;
    protected int l2upper;
    protected int l2lower;
    protected int l3upper;
    protected int l3lower;
    protected int l2index;
    protected int l3index;
    protected int l1index;
    protected ILongBuffer vtdBuffer;
    protected ILongBuffer l1Buffer;
    protected ILongBuffer l2Buffer;
    protected IIntBuffer l3Buffer;
    protected IByteBuffer XMLDoc;
    private ContextBuffer contextStack;
    protected ContextBuffer contextStack2;
    protected int LN;
    protected int encoding;
    protected boolean ns;
    protected int[] stackTemp;
    protected long docOffset;
    protected long docLen;
    protected int vtdSize;

    protected VTDNavHuge(int RootIndex, int enc, boolean NS, int depth, IByteBuffer x, ILongBuffer vtd, ILongBuffer l1, ILongBuffer l2, IIntBuffer l3, long so, long length) {
        if (l1 == null || l2 == null || l3 == null || vtd == null || x == null || depth < 0 || RootIndex < 0 || so < 0L || length < 0L) {
            throw new IllegalArgumentException();
        }
        this.l1Buffer = l1;
        this.l2Buffer = l2;
        this.l3Buffer = l3;
        this.vtdBuffer = vtd;
        this.XMLDoc = x;
        this.encoding = enc;
        this.rootIndex = RootIndex;
        this.nestingLevel = depth + 1;
        this.ns = NS;
        this.atTerminal = false;
        this.context = new int[this.nestingLevel];
        this.context[0] = 0;
        for (int i = 1; i < this.nestingLevel; ++i) {
            this.context[i] = -1;
        }
        this.contextStack = new ContextBuffer(10, this.nestingLevel + 9);
        this.contextStack2 = new ContextBuffer(10, this.nestingLevel + 9);
        this.stackTemp = new int[this.nestingLevel + 9];
        this.l3index = -1;
        this.l2index = -1;
        this.l1index = -1;
        this.l3lower = -1;
        this.l2lower = -1;
        this.l3upper = -1;
        this.l2upper = -1;
        this.docOffset = so;
        this.docLen = length;
        this.vtdSize = vtd.size();
    }

    public int getAttrCount() {
        int type;
        if (this.context[0] == -1) {
            return 0;
        }
        int count = 0;
        for (int index = this.getCurrentIndex() + 1; index < this.vtdSize && ((type = this.getTokenType(index)) == 2 || type == 4 || type == 3); ++index) {
            if (type != 2 && (this.ns || type != 3)) continue;
            ++count;
        }
        return count;
    }

    public int getAttrVal(String an) throws NavExceptionHuge {
        int index;
        if (this.context[0] == -1) {
            return -1;
        }
        int n = index = this.context[0] != 0 ? this.context[this.context[0]] + 1 : this.rootIndex + 1;
        if (index >= this.vtdSize) {
            return -1;
        }
        int type = this.getTokenType(index);
        if (!this.ns) {
            while (type == 2 || type == 3) {
                if (this.matchRawTokenString(index, an)) {
                    return index + 1;
                }
                if ((index += 2) < this.vtdSize) {
                    type = this.getTokenType(index);
                    continue;
                }
                break;
            }
        } else {
            while (type == 2 || type == 3) {
                if (type == 2 && this.matchRawTokenString(index, an)) {
                    return index + 1;
                }
                if ((index += 2) < this.vtdSize) {
                    type = this.getTokenType(index);
                    continue;
                }
                break;
            }
        }
        return -1;
    }

    public int getAttrValNS(String URL2, String ln) throws NavExceptionHuge {
        int type;
        int index;
        if (!this.ns) {
            return -1;
        }
        if (URL2 == null) {
            return this.getAttrVal(ln);
        }
        int size = this.vtdBuffer.size();
        int n = index = this.context[0] != 0 ? this.context[this.context[0]] + 1 : this.rootIndex + 1;
        if (index < this.vtdSize) {
            type = this.getTokenType(index);
        } else {
            return -1;
        }
        while (index < size && (type == 2 || type == 3)) {
            int i = this.getTokenLength(index);
            long offset = this.getTokenOffset(index);
            int preLen = i >> 16 & 0xFFFF;
            int fullLen = i & 0xFFFF;
            if (preLen != 0 && this.matchRawTokenString(offset + (long)preLen + 1L, fullLen - preLen - 1, ln) && this.resolveNS(URL2, offset, preLen)) {
                return index + 1;
            }
            if ((index += 2) >= this.vtdSize) break;
            type = this.getTokenType(index);
        }
        return -1;
    }

    private long handle_utf8(long temp, long offset) throws NavExceptionHuge {
        int a;
        int d;
        int c;
        switch (UTF8Char.byteCount((int)temp & 0xFF)) {
            case 2: {
                c = 31;
                d = 6;
                a = 1;
                break;
            }
            case 3: {
                c = 15;
                d = 12;
                a = 2;
                break;
            }
            case 4: {
                c = 7;
                d = 18;
                a = 3;
                break;
            }
            case 5: {
                c = 3;
                d = 24;
                a = 4;
                break;
            }
            case 6: {
                c = 1;
                d = 30;
                a = 5;
                break;
            }
            default: {
                throw new NavExceptionHuge("UTF 8 encoding error: should never happen");
            }
        }
        long val = (temp & (long)c) << d;
        for (int i = a - 1; i >= 0; --i) {
            temp = this.XMLDoc.byteAt(offset + (long)a - (long)i);
            if ((temp & 0xC0L) != 128L) {
                throw new NavExceptionHuge("UTF 8 encoding error: should never happen");
            }
            val |= (temp & 0x3FL) << (i << 2) + (i << 1);
        }
        return val | (long)(a + 1) << 32;
    }

    private long handle_utf16le(long offset) throws NavExceptionHuge {
        int temp = (this.XMLDoc.byteAt((offset << 1) + 1L) & 0xFF) << 8 | this.XMLDoc.byteAt(offset << 1) & 0xFF;
        if (temp < 56320 || temp > 57343) {
            if (temp == 13) {
                if (this.XMLDoc.byteAt((offset << 1) + 2L) == 10 && this.XMLDoc.byteAt((offset << 1) + 3L) == 0) {
                    return 0x20000000AL;
                }
                return 0x10000000AL;
            }
            return (long)temp | 0x100000000L;
        }
        if (temp < 55296 || temp > 56319) {
            throw new NavExceptionHuge("UTF 16 LE encoding error: should never happen");
        }
        int val = temp;
        temp = (this.XMLDoc.byteAt((offset << 1) + 3L) & 0xFF) << 8 | this.XMLDoc.byteAt((offset << 1) + 2L) & 0xFF;
        if (temp < 56320 || temp > 57343) {
            throw new NavExceptionHuge("UTF 16 LE encoding error: should never happen");
        }
        val = (temp - 55296 << 10) + (val - 56320) + 65536;
        return (long)val | 0x200000000L;
    }

    private long handle_utf16be(long offset) throws NavExceptionHuge {
        int temp = (this.XMLDoc.byteAt(offset << 1) & 0xFF) << 8 | this.XMLDoc.byteAt((offset << 1) + 1L) & 0xFF;
        if (temp < 55296 || temp > 57343) {
            if (temp == 13) {
                if (this.XMLDoc.byteAt((offset << 1) + 3L) == 10 && this.XMLDoc.byteAt((offset << 1) + 2L) == 0) {
                    return 0x20000000AL;
                }
                return 0x10000000AL;
            }
            return (long)temp | 0x100000000L;
        }
        if (temp < 55296 || temp > 56319) {
            throw new NavExceptionHuge("UTF 16 BE encoding error: should never happen");
        }
        long val = temp;
        temp = (this.XMLDoc.byteAt((offset << 1) + 2L) & 0xFF) << 8 | this.XMLDoc.byteAt((offset << 1) + 3L) & 0xFF;
        if (temp < 56320 || temp > 57343) {
            throw new NavExceptionHuge("UTF 16 BE encoding error: should never happen");
        }
        val = (long)(temp - 55296 << 10) + (val - 56320L) + 65536L;
        return val | 0x200000000L;
    }

    private long getChar4OtherEncoding(long offset) throws NavExceptionHuge {
        if (this.encoding <= 26) {
            int temp = this.decode(offset);
            if (temp == 13) {
                if (this.XMLDoc.byteAt(offset + 1L) == 10) {
                    return 0x20000000AL;
                }
                return 0x10000000AL;
            }
            return (long)temp | 0x100000000L;
        }
        throw new NavExceptionHuge("Unknown Encoding");
    }

    private long getChar(long offset) throws NavExceptionHuge {
        long temp = 0L;
        switch (this.encoding) {
            case 0: {
                temp = this.XMLDoc.byteAt(offset);
                if (temp == 13L) {
                    if (this.XMLDoc.byteAt(offset + 1L) == 10) {
                        return 0x20000000AL;
                    }
                    return 0x10000000AL;
                }
                return temp | 0x100000000L;
            }
            case 1: {
                temp = this.XMLDoc.byteAt(offset);
                if (temp == 13L) {
                    if (this.XMLDoc.byteAt(offset + 1L) == 10) {
                        return 0x20000000AL;
                    }
                    return 0x10000000AL;
                }
                return temp & 0xFFL | 0x100000000L;
            }
            case 2: {
                temp = this.XMLDoc.byteAt(offset);
                if (temp >= 0L) {
                    if (temp == 13L) {
                        if (this.XMLDoc.byteAt(offset + 1L) == 10) {
                            return 0x20000000AL;
                        }
                        return 0x10000000AL;
                    }
                    return temp | 0x100000000L;
                }
                return this.handle_utf8(temp, offset);
            }
            case 63: {
                return this.handle_utf16be(offset);
            }
            case 64: {
                return this.handle_utf16le(offset);
            }
        }
        return this.getChar4OtherEncoding(offset);
    }

    private long getCharResolved(long offset) throws NavExceptionHuge {
        int ch = 0;
        int val = 0;
        long inc = 2L;
        long l = this.getChar(offset);
        ch = (int)l;
        if (ch != 38) {
            return l;
        }
        ch = this.getCharUnit(++offset);
        ++offset;
        switch (ch) {
            case 35: {
                ch = this.getCharUnit(offset);
                if (ch == 120) {
                    while (true) {
                        ++inc;
                        if ((ch = this.getCharUnit(++offset)) >= 48 && ch <= 57) {
                            val = (val << 4) + (ch - 48);
                            continue;
                        }
                        if (ch >= 97 && ch <= 102) {
                            val = (val << 4) + (ch - 97 + 10);
                            continue;
                        }
                        if (ch < 65 || ch > 70) break;
                        val = (val << 4) + (ch - 65 + 10);
                    }
                    if (ch == 59) {
                        ++inc;
                        break;
                    }
                    throw new NavExceptionHuge("Illegal char in a char reference");
                }
                while (true) {
                    ch = this.getCharUnit(offset);
                    ++offset;
                    ++inc;
                    if (ch < 48 || ch > 57) break;
                    val = val * 10 + (ch - 48);
                }
                if (ch == 59) break;
                throw new NavExceptionHuge("Illegal char in char reference");
            }
            case 97: {
                ch = this.getCharUnit(offset);
                if (ch == 109) {
                    if (this.getCharUnit(offset + 1L) == 112 && this.getCharUnit(offset + 2L) == 59) {
                        inc = 5L;
                        val = 38;
                        break;
                    }
                    throw new NavExceptionHuge("illegal builtin reference");
                }
                if (ch == 112) {
                    if (this.getCharUnit(offset + 1L) == 111 && this.getCharUnit(offset + 2L) == 115 && this.getCharUnit(offset + 3L) == 59) {
                        inc = 6L;
                        val = 39;
                        break;
                    }
                    throw new NavExceptionHuge("illegal builtin reference");
                }
                throw new NavExceptionHuge("illegal builtin reference");
            }
            case 113: {
                if (this.getCharUnit(offset) == 117 && this.getCharUnit(offset + 1L) == 111 && this.getCharUnit(offset + 2L) == 116 && this.getCharUnit(offset + 3L) == 59) {
                    inc = 6L;
                    val = 34;
                    break;
                }
                throw new NavExceptionHuge("illegal builtin reference");
            }
            case 108: {
                if (this.getCharUnit(offset) == 116 && this.getCharUnit(offset + 1L) == 59) {
                    inc = 4L;
                    val = 60;
                    break;
                }
                throw new NavExceptionHuge("illegal builtin reference");
            }
            case 103: {
                if (this.getCharUnit(offset) == 116 && this.getCharUnit(offset + 1L) == 59) {
                    inc = 4L;
                    val = 62;
                    break;
                }
                throw new NavExceptionHuge("illegal builtin reference");
            }
            default: {
                throw new NavExceptionHuge("Invalid entity char");
            }
        }
        return (long)val | inc << 32;
    }

    private int decode(long offset) {
        byte ch = this.XMLDoc.byteAt(offset);
        switch (this.encoding) {
            case 3: {
                return ISO8859_2.decode(ch);
            }
            case 4: {
                return ISO8859_3.decode(ch);
            }
            case 5: {
                return ISO8859_4.decode(ch);
            }
            case 6: {
                return ISO8859_5.decode(ch);
            }
            case 7: {
                return ISO8859_6.decode(ch);
            }
            case 8: {
                return ISO8859_7.decode(ch);
            }
            case 9: {
                return ISO8859_8.decode(ch);
            }
            case 10: {
                return ISO8859_9.decode(ch);
            }
            case 11: {
                return ISO8859_10.decode(ch);
            }
            case 12: {
                return ISO8859_11.decode(ch);
            }
            case 14: {
                return ISO8859_13.decode(ch);
            }
            case 15: {
                return ISO8859_14.decode(ch);
            }
            case 16: {
                return ISO8859_15.decode(ch);
            }
            case 18: {
                return WIN1250.decode(ch);
            }
            case 19: {
                return WIN1251.decode(ch);
            }
            case 20: {
                return WIN1252.decode(ch);
            }
            case 21: {
                return WIN1253.decode(ch);
            }
            case 22: {
                return WIN1254.decode(ch);
            }
            case 23: {
                return WIN1255.decode(ch);
            }
            case 24: {
                return WIN1256.decode(ch);
            }
            case 25: {
                return WIN1257.decode(ch);
            }
        }
        return WIN1258.decode(ch);
    }

    private int getCharUnit(long offset) {
        return this.encoding <= 2 ? this.XMLDoc.byteAt(offset) & 0xFF : (this.encoding <= 26 ? this.decode(offset) : (this.encoding == 63 ? this.XMLDoc.byteAt(offset << 1) << 8 | this.XMLDoc.byteAt((offset << 1) + 1L) : this.XMLDoc.byteAt((offset << 1) + 1L) << 8 | this.XMLDoc.byteAt(offset << 1)));
    }

    public final int getCurrentDepth() {
        return this.context[0];
    }

    public final int getCurrentIndex() {
        if (this.atTerminal) {
            return this.LN;
        }
        switch (this.context[0]) {
            case -1: {
                return 0;
            }
            case 0: {
                return this.rootIndex;
            }
        }
        return this.context[this.context[0]];
    }

    protected final int getCurrentIndex2() {
        switch (this.context[0]) {
            case -1: {
                return 0;
            }
            case 0: {
                return this.rootIndex;
            }
        }
        return this.context[this.context[0]];
    }

    public final int getEncoding() {
        return this.encoding;
    }

    public final int getNestingLevel() {
        return this.nestingLevel;
    }

    protected final long getOffsetAfterHead() {
        int j;
        int i = this.getCurrentIndex();
        if (this.getTokenType(i) != 0) {
            return -1L;
        }
        for (j = i + 1; j < this.vtdSize && (this.getTokenType(j) == 2 || this.getTokenType(j) == 3); j += 2) {
        }
        long offset = i + 1 == j ? this.getTokenOffset(i) + (long)this.getTokenLength(i) : this.getTokenOffset(j - 1) + (long)this.getTokenLength(j - 1) + 1L;
        while (this.getCharUnit(offset) != 62) {
            ++offset;
        }
        if (this.getCharUnit(offset - 1L) == 47) {
            return -1L;
        }
        return offset + 1L;
    }

    public final int getRootIndex() {
        return this.rootIndex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getText() {
        if (this.context[0] == -1) {
            return -1;
        }
        int index = this.context[0] != 0 ? this.context[this.context[0]] + 1 : this.rootIndex + 1;
        int depth = this.getCurrentDepth();
        if (index >= this.vtdSize) {
            return -1;
        }
        int type = this.getTokenType(index);
        while (true) {
            if (type == 5 || type == 11) {
                if (depth != this.getTokenDepth(index)) return -1;
                return index;
            }
            if (type == 3 || type == 2) {
                index += 2;
            } else {
                if (type != 7 && type != 8 && type != 6) return -1;
                if (depth != this.getTokenDepth(index)) return -1;
                ++index;
            }
            if (index >= this.vtdSize) return -1;
            type = this.getTokenType(index);
        }
    }

    public final int getTokenCount() {
        return this.vtdSize;
    }

    public final int getTokenDepth(int index) {
        int i = (int)((this.vtdBuffer.longAt(index) & 0xF80000000000000L) >> 55);
        if (i != 31) {
            return i;
        }
        return -1;
    }

    public int getTokenLength(int index) {
        int type = this.getTokenType(index);
        int len = 0;
        long temp = 0L;
        switch (type) {
            case 0: 
            case 2: 
            case 3: {
                long l = this.vtdBuffer.longAt(index);
                return !this.ns ? (int)((l & 0xFFC000000000L) >> 38) : (int)((l & 0xFFC000000000L) >> 38) | (int)((l & 0x7F000000000000L) >> 32);
            }
            case 5: 
            case 6: 
            case 11: {
                int depth = this.getTokenDepth(index);
                do {
                    len += (int)((this.vtdBuffer.longAt(index) & 0x7FFFC000000000L) >> 38);
                    temp = this.getTokenOffset(index) + (long)((int)((this.vtdBuffer.longAt(index) & 0x7FFFC000000000L) >> 38));
                } while (++index < this.vtdSize && depth == this.getTokenDepth(index) && type == this.getTokenType(index) && temp == this.getTokenOffset(index));
                return len;
            }
        }
        return (int)((this.vtdBuffer.longAt(index) & 0x7FFFC000000000L) >> 38);
    }

    public final long getTokenOffset(int index) {
        return this.vtdBuffer.longAt(index) & 0x3FFFFFFFFFL;
    }

    public final IByteBuffer getXML() {
        return this.XMLDoc;
    }

    public final int getTokenType(int index) {
        return (int)((this.vtdBuffer.longAt(index) & 0xF000000000000000L) >> 60) & 0xF;
    }

    public final boolean hasAttr(String an) throws NavExceptionHuge {
        return this.getAttrVal(an) != -1;
    }

    public final boolean hasAttrNS(String URL2, String ln) throws NavExceptionHuge {
        return this.getAttrValNS(URL2, ln) != -1;
    }

    private final boolean isElement(int index) {
        return ((this.vtdBuffer.longAt(index) & 0xF000000000000000L) >> 60 & 0xFL) == 0L;
    }

    private final boolean isElementOrDocument(int index) {
        long i = (this.vtdBuffer.longAt(index) & 0xF000000000000000L) >> 60 & 0xFL;
        return i == 0L || i == 13L;
    }

    private final boolean isWS(int ch) {
        return ch == 32 || ch == 10 || ch == 9 || ch == 13;
    }

    protected boolean iterate_preceding(String en, int[] a, boolean special) throws NavExceptionHuge {
        for (int index = this.getCurrentIndex() - 1; index > 0; --index) {
            int depth;
            if (!this.isElementOrDocument(index)) continue;
            this.context[0] = depth = this.getTokenDepth(index);
            if (depth > 0) {
                this.context[depth] = index;
                int t = index - 1;
                block1: for (int i = depth - 1; i > 0 && (this.context[i] > index || this.context[i] == -1); --i) {
                    while (t > 0) {
                        int d = this.getTokenDepth(t);
                        if (d == i && this.isElement(t)) {
                            this.context[i] = t;
                            continue block1;
                        }
                        --t;
                    }
                }
            }
            if (index == a[depth] || !special && !this.matchElement(en)) continue;
            this.resolveLC();
            return true;
        }
        return false;
    }

    protected boolean iterate_precedingNS(String URL2, String ln, int[] a) throws NavExceptionHuge {
        for (int index = this.getCurrentIndex() - 1; index > 0; --index) {
            int depth;
            if (!this.isElementOrDocument(index)) continue;
            this.context[0] = depth = this.getTokenDepth(index);
            if (depth > 0) {
                this.context[depth] = index;
                int t = index - 1;
                block1: for (int i = depth - 1; i > 0 && (this.context[i] > index || this.context[i] == -1); --i) {
                    while (t > 0) {
                        int d = this.getTokenDepth(t);
                        if (d == i && this.isElement(t)) {
                            this.context[i] = t;
                            continue block1;
                        }
                        --t;
                    }
                }
            }
            if (index == a[depth] || !this.matchElementNS(URL2, ln)) continue;
            this.resolveLC();
            return true;
        }
        return false;
    }

    protected boolean iterate_following(String en, boolean special) throws NavExceptionHuge {
        for (int index = this.getCurrentIndex() + 1; index < this.vtdSize; ++index) {
            int depth;
            if (!this.isElementOrDocument(index)) continue;
            this.context[0] = depth = this.getTokenDepth(index);
            if (depth > 0) {
                this.context[depth] = index;
            }
            if (!special && !this.matchElement(en)) continue;
            this.resolveLC();
            return true;
        }
        return false;
    }

    protected boolean iterate_followingNS(String URL2, String ln) throws NavExceptionHuge {
        for (int index = this.getCurrentIndex() + 1; index < this.vtdSize; ++index) {
            int depth;
            if (!this.isElementOrDocument(index)) continue;
            this.context[0] = depth = this.getTokenDepth(index);
            if (depth > 0) {
                this.context[depth] = index;
            }
            if (!this.matchElementNS(URL2, ln)) continue;
            this.resolveLC();
            return true;
        }
        return false;
    }

    protected boolean iterate(int dp, String en, boolean special) throws NavExceptionHuge {
        int index = this.getCurrentIndex() + 1;
        while (index < this.vtdSize) {
            int tokenType = this.getTokenType(index);
            if (tokenType == 2 || tokenType == 3) {
                index += 2;
                continue;
            }
            if (this.isElementOrDocument(index)) {
                int depth = this.getTokenDepth(index);
                if (depth > dp) {
                    this.context[0] = depth;
                    if (depth > 0) {
                        this.context[depth] = index;
                    }
                    if (special || this.matchElement(en)) {
                        if (dp < 4) {
                            this.resolveLC();
                        }
                        return true;
                    }
                } else {
                    return false;
                }
            }
            ++index;
        }
        return false;
    }

    protected final boolean iterateNS(int dp, String URL2, String ln) throws NavExceptionHuge {
        if (!this.ns) {
            return false;
        }
        int index = this.getCurrentIndex() + 1;
        while (index < this.vtdSize) {
            int tokenType = this.getTokenType(index);
            if (tokenType == 2 || tokenType == 3) {
                index += 2;
                continue;
            }
            if (this.isElementOrDocument(index)) {
                int depth = this.getTokenDepth(index);
                if (depth > dp) {
                    this.context[0] = depth;
                    if (depth > 0) {
                        this.context[depth] = index;
                    }
                    if (this.matchElementNS(URL2, ln)) {
                        if (dp < 4) {
                            this.resolveLC();
                        }
                        return true;
                    }
                } else {
                    return false;
                }
            }
            ++index;
        }
        return false;
    }

    public final boolean matchElement(String en) throws NavExceptionHuge {
        if (en.equals("*") && this.context[0] != -1) {
            return true;
        }
        if (this.context[0] == -1) {
            return false;
        }
        return this.matchRawTokenString(this.context[0] == 0 ? this.rootIndex : this.context[this.context[0]], en);
    }

    public boolean matchElementNS(String URL2, String ln) throws NavExceptionHuge {
        if (this.context[0] == -1) {
            return false;
        }
        int i = this.getTokenLength(this.context[0] != 0 ? this.context[this.context[0]] : this.rootIndex);
        long offset = this.getTokenOffset(this.context[0] != 0 ? this.context[this.context[0]] : this.rootIndex);
        int preLen = i >> 16 & 0xFFFF;
        int fullLen = i & 0xFFFF;
        return (ln.equals("*") || (preLen != 0 ? this.matchRawTokenString(offset + (long)preLen + 1L, fullLen - preLen - 1, ln) : this.matchRawTokenString(offset, fullLen, ln))) && (URL2 != null && URL2.equals("*") || this.resolveNS(URL2, offset, preLen));
    }

    private final boolean matchRawTokenString(long offset, int len, String s) throws NavExceptionHuge {
        return this.compareRawTokenString(offset, len, s) == 0;
    }

    protected int compareTokenString(long offset, int len, String s) throws NavExceptionHuge {
        int i;
        long l1;
        long endOffset = offset + (long)len;
        int l = s.length();
        for (i = 0; i < l && offset < endOffset; offset += (long)((int)(l1 >> 32)), ++i) {
            l1 = this.getCharResolved(offset);
            char i1 = s.charAt(i);
            if (i1 < (int)l1) {
                return 1;
            }
            if (i1 <= (int)l1) continue;
            return -1;
        }
        if (i == l && offset < endOffset) {
            return 1;
        }
        if (i < l && offset == endOffset) {
            return -1;
        }
        return 0;
    }

    public final boolean contains(int index, String s) throws NavExceptionHuge {
        int type = this.getTokenType(index);
        int len = type == 0 || type == 2 || type == 3 ? this.getTokenLength(index) & 0xFFFF : this.getTokenLength(index);
        long offset = this.getTokenOffset(index);
        long endOffset = offset + (long)len;
        boolean b = type == 4 || type == 5;
        long gOffset = offset;
        int l = s.length();
        if (l > len) {
            return false;
        }
        while (offset < endOffset) {
            int i;
            gOffset = offset;
            if (endOffset - gOffset < (long)l) {
                return false;
            }
            for (i = 0; i < l && gOffset < endOffset; ++i) {
                long l1 = b ? this.getCharResolved(gOffset) : this.getChar(gOffset);
                char i1 = s.charAt(i);
                gOffset += (long)((int)(l1 >> 32));
                if (i == 0) {
                    offset = gOffset;
                }
                if (i1 != (int)l1) break;
            }
            if (i != l) continue;
            return true;
        }
        return false;
    }

    protected int compareRawTokenString(long offset, int len, String s) throws NavExceptionHuge {
        int i;
        long l1;
        long endOffset = offset + (long)len;
        int l = s.length();
        for (i = 0; i < l && offset < endOffset; offset += (long)((int)(l1 >> 32)), ++i) {
            l1 = this.getChar(offset);
            char i1 = s.charAt(i);
            if (i1 < (int)l1) {
                return 1;
            }
            if (i1 <= (int)l1) continue;
            return -1;
        }
        if (i == l && offset < endOffset) {
            return 1;
        }
        if (i < l && offset == endOffset) {
            return -1;
        }
        return 0;
    }

    public final int compareRawTokenString(int index, String s) throws NavExceptionHuge {
        int type = this.getTokenType(index);
        int len = type == 0 || type == 2 || type == 3 ? this.getTokenLength(index) & 0xFFFF : this.getTokenLength(index);
        return this.compareRawTokenString(this.getTokenOffset(index), len, s);
    }

    public final boolean matchRawTokenString(int index, String s) throws NavExceptionHuge {
        int type = this.getTokenType(index);
        int len = type == 0 || type == 2 || type == 3 ? this.getTokenLength(index) & 0xFFFF : this.getTokenLength(index);
        return this.compareRawTokenString(this.getTokenOffset(index), len, s) == 0;
    }

    public int compareTokenString(int index, String s) throws NavExceptionHuge {
        int type = this.getTokenType(index);
        int len = type == 0 || type == 2 || type == 3 ? this.getTokenLength(index) & 0xFFFF : this.getTokenLength(index);
        return this.compareTokenString(this.getTokenOffset(index), len, s);
    }

    public final boolean matchTokenString(int index, String s) throws NavExceptionHuge {
        int type = this.getTokenType(index);
        int len = type == 0 || type == 2 || type == 3 ? this.getTokenLength(index) & 0xFFFF : this.getTokenLength(index);
        return this.compareTokenString(this.getTokenOffset(index), len, s) == 0;
    }

    public double parseDouble(int index) throws NavExceptionHuge {
        int dig;
        boolean neg;
        long offset = this.getTokenOffset(index);
        long l = 0L;
        long end = offset + (long)this.getTokenLength(index);
        int t = this.getTokenType(index);
        boolean b = t == 5 || t == 4;
        boolean expneg = false;
        l = b ? this.getCharResolved(offset) : this.getChar(offset);
        int ch = (int)l;
        offset += (long)((int)(l >> 32));
        while (offset < end && this.isWS(ch)) {
            l = b ? this.getCharResolved(offset) : this.getChar(offset);
            ch = (int)l;
            offset += (long)((int)(l >> 32));
        }
        if (offset > end) {
            return Double.NaN;
        }
        boolean bl = neg = ch == 45;
        if (ch == 45 || ch == 43) {
            l = b ? this.getCharResolved(offset) : this.getChar(offset);
            ch = (int)l;
            offset += (long)((int)(l >> 32));
        }
        double left = 0.0;
        while (offset <= end && (dig = Character.digit((char)ch, 10)) >= 0) {
            left = left * 10.0 + (double)dig;
            l = b ? this.getCharResolved(offset) : this.getChar(offset);
            ch = (int)l;
            offset += (long)((int)(l >> 32));
        }
        double right = 0.0;
        double scale = 1.0;
        if (ch == 46) {
            int dig2;
            l = b ? this.getCharResolved(offset) : this.getChar(offset);
            ch = (int)l;
            offset += (long)((int)(l >> 32));
            while (offset <= end && (dig2 = Character.digit((char)ch, 10)) >= 0) {
                right = right * 10.0 + (double)dig2;
                scale *= 10.0;
                l = b ? this.getCharResolved(offset) : this.getChar(offset);
                ch = (int)l;
                offset += (long)((int)(l >> 32));
            }
        }
        long exp = 0L;
        if (ch == 69 || ch == 101) {
            int dig3;
            l = b ? this.getCharResolved(offset) : this.getChar(offset);
            ch = (int)l;
            offset += (long)((int)(l >> 32));
            boolean bl2 = expneg = ch == 45;
            if (ch == 43 || ch == 45) {
                l = b ? this.getCharResolved(offset) : this.getChar(offset);
                ch = (int)l;
                offset += (long)((int)(l >> 32));
            }
            long cur = offset;
            while (offset <= end && (dig3 = Character.digit((char)ch, 10)) >= 0) {
                exp = exp * 10L + (long)dig3;
                l = b ? this.getCharResolved(offset) : this.getChar(offset);
                ch = (int)l;
                offset += (long)((int)(l >> 32));
            }
            if (cur == offset) {
                return Double.NaN;
            }
        }
        while (offset <= end) {
            if (!this.isWS(ch)) {
                return Double.NaN;
            }
            l = b ? this.getCharResolved(offset) : this.getChar(offset);
            ch = (int)l;
            offset += (long)((int)(l >> 32));
        }
        double v = left;
        if (right != 0.0) {
            v += right / scale;
        }
        if (exp != 0L) {
            v = expneg ? v / Math.pow(10.0, exp) : v * Math.pow(10.0, exp);
        }
        return neg ? -v : v;
    }

    public float parseFloat(int index) throws NavExceptionHuge {
        int dig;
        boolean neg;
        long offset = this.getTokenOffset(index);
        long end = offset + (long)this.getTokenLength(index);
        int t = this.getTokenType(index);
        boolean b = t == 5 || t == 4;
        long l = b ? this.getCharResolved(offset) : this.getChar(offset);
        int ch = (int)l;
        offset += (long)((int)(l >> 32));
        while (offset <= end && this.isWS(ch)) {
            l = b ? this.getCharResolved(offset) : this.getChar(offset);
            ch = (int)l;
            offset += (long)((int)(l >> 32));
        }
        if (offset > end) {
            throw new NavExceptionHuge("Empty string");
        }
        boolean bl = neg = ch == 45;
        if (ch == 45 || ch == 43) {
            l = b ? this.getCharResolved(offset) : this.getChar(offset);
            ch = (int)l;
            offset += (long)((int)(l >> 32));
        }
        long left = 0L;
        while (offset <= end && (dig = Character.digit((char)ch, 10)) >= 0) {
            left = left * 10L + (long)dig;
            l = b ? this.getCharResolved(offset) : this.getChar(offset);
            ch = (int)l;
            offset += (long)((int)(l >> 32));
        }
        long right = 0L;
        long scale = 1L;
        if (ch == 46) {
            int dig2;
            l = b ? this.getCharResolved(offset) : this.getChar(offset);
            ch = (int)l;
            offset += (long)((int)(l >> 32));
            while (offset <= end && (dig2 = Character.digit((char)ch, 10)) >= 0) {
                right = right * 10L + (long)dig2;
                scale *= 10L;
                l = b ? this.getCharResolved(offset) : this.getChar(offset);
                ch = (int)l;
                offset += (long)((int)(l >> 32));
            }
        }
        long exp = 0L;
        if (ch == 69 || ch == 101) {
            int dig3;
            boolean expneg;
            l = b ? this.getCharResolved(offset) : this.getChar(offset);
            ch = (int)l;
            offset += (long)((int)(l >> 32));
            boolean bl2 = expneg = ch == 45;
            if (ch == 43 || ch == 45) {
                l = b ? this.getCharResolved(offset) : this.getChar(offset);
                ch = (int)l;
                offset += (long)((int)(l >> 32));
            }
            long cur = offset;
            while (offset <= end && (dig3 = Character.digit((char)ch, 10)) >= 0) {
                exp = exp * 10L + (long)dig3;
                l = b ? this.getCharResolved(offset) : this.getChar(offset);
                ch = (int)l;
                offset += (long)((int)(l >> 32));
            }
            if (cur == offset) {
                return Float.NaN;
            }
            if (expneg) {
                exp = -exp;
            }
        }
        while (offset <= end) {
            if (!this.isWS(ch)) {
                throw new NavExceptionHuge(this.toString(index));
            }
            l = b ? this.getCharResolved(offset) : this.getChar(offset);
            ch = (int)l;
            offset += (long)((int)(l >> 32));
        }
        double v = left;
        if (right != 0L) {
            v += (double)right / (double)scale;
        }
        if (exp != 0L) {
            v *= Math.pow(10.0, exp);
        }
        float f = (float)v;
        if (v >= 3.4028234663852886E38) {
            f = Float.MAX_VALUE;
        } else if (v <= (double)1.4E-45f) {
            f = Float.MIN_VALUE;
        }
        if (neg) {
            f = -f;
        }
        return f;
    }

    public int parseInt(int index) throws NavExceptionHuge {
        return this.parseInt(index, 10);
    }

    protected int parseInt(int index, int radix) throws NavExceptionHuge {
        int digit;
        boolean neg;
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("radix " + radix + " out of valid range");
        }
        int t = this.getTokenType(index);
        boolean b = t == 5 || t == 4;
        long offset = this.getTokenOffset(index);
        long endOffset = offset + (long)this.getTokenLength(index);
        long l = b ? this.getCharResolved(offset) : this.getChar(offset);
        int c = (int)l;
        offset += (long)((int)(l >> 32));
        while ((c == 32 || c == 10 || c == 9 || c == 13) && offset <= endOffset) {
            l = b ? this.getCharResolved(offset) : this.getChar(offset);
            c = (int)l;
            offset += (long)((int)(l >> 32));
        }
        if (offset > endOffset) {
            throw new NumberFormatException(" empty string");
        }
        boolean bl = neg = c == 45;
        if (neg || c == 43) {
            l = b ? this.getCharResolved(offset) : this.getChar(offset);
            c = (int)l;
            offset += (long)((int)(l >> 32));
        }
        long result = 0L;
        while (offset <= endOffset && (digit = Character.digit((char)c, radix)) >= 0) {
            result = result * (long)radix + (long)digit;
            l = b ? this.getCharResolved(offset) : this.getChar(offset);
            c = (int)l;
            offset += (long)((int)(l >> 32));
        }
        if (result > Integer.MAX_VALUE) {
            throw new NumberFormatException("Overflow: " + this.toString(index));
        }
        while (offset <= endOffset && this.isWS(c)) {
            l = b ? this.getCharResolved(offset) : this.getChar(offset);
            c = (int)l;
            offset += (long)((int)(l >> 32));
        }
        if (offset == endOffset + 1L) {
            return (int)(neg ? -result : result);
        }
        throw new NumberFormatException(this.toString(index));
    }

    public long parseLong(int index) throws NavExceptionHuge {
        return this.parseLong(index, 10);
    }

    protected long parseLong(int index, int radix) throws NavExceptionHuge {
        int digit;
        boolean neg;
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("radix " + radix + " out of valid range");
        }
        int t = this.getTokenType(index);
        boolean b = t == 5 || t == 4;
        long offset = this.getTokenOffset(index);
        long endOffset = offset + (long)this.getTokenLength(index);
        long l = b ? this.getCharResolved(offset) : this.getChar(offset);
        int c = (int)l;
        offset += (long)((int)(l >> 32));
        while ((c == 32 || c == 10 || c == 9 || c == 13) && offset <= endOffset) {
            l = b ? this.getCharResolved(offset) : this.getChar(offset);
            c = (int)l;
            offset += (long)((int)(l >> 32));
        }
        if (offset > endOffset) {
            throw new NumberFormatException(" empty string");
        }
        boolean bl = neg = c == 45;
        if (neg || c == 43) {
            l = b ? this.getCharResolved(offset) : this.getChar(offset);
            c = (int)l;
            offset += (long)((int)(l >> 32));
        }
        long result = 0L;
        while (offset <= endOffset && (digit = Character.digit((char)c, radix)) >= 0) {
            result = result * (long)radix + (long)digit;
            l = b ? this.getCharResolved(offset) : this.getChar(offset);
            c = (int)l;
            offset += (long)((int)(l >> 32));
        }
        if (result > Long.MAX_VALUE) {
            throw new NumberFormatException("Overflow: " + this.toString(index));
        }
        while (offset <= endOffset && this.isWS(c)) {
            l = b ? this.getCharResolved(offset) : this.getChar(offset);
            c = (int)l;
            offset += (long)((int)(l >> 32));
        }
        if (offset == endOffset + 1L) {
            return neg ? -result : result;
        }
        throw new NumberFormatException(this.toString(index));
    }

    public final boolean pop() {
        boolean b = this.contextStack.load(this.stackTemp);
        if (!b) {
            return false;
        }
        for (int i = 0; i < this.nestingLevel; ++i) {
            this.context[i] = this.stackTemp[i];
        }
        this.l1index = this.stackTemp[this.nestingLevel];
        this.l2index = this.stackTemp[this.nestingLevel + 1];
        this.l3index = this.stackTemp[this.nestingLevel + 2];
        this.l2lower = this.stackTemp[this.nestingLevel + 3];
        this.l2upper = this.stackTemp[this.nestingLevel + 4];
        this.l3lower = this.stackTemp[this.nestingLevel + 5];
        this.l3upper = this.stackTemp[this.nestingLevel + 6];
        this.atTerminal = this.stackTemp[this.nestingLevel + 7] == 1;
        this.LN = this.stackTemp[this.nestingLevel + 8];
        return true;
    }

    protected final boolean pop2() {
        boolean b = this.contextStack2.load(this.stackTemp);
        if (!b) {
            return false;
        }
        for (int i = 0; i < this.nestingLevel; ++i) {
            this.context[i] = this.stackTemp[i];
        }
        this.l1index = this.stackTemp[this.nestingLevel];
        this.l2index = this.stackTemp[this.nestingLevel + 1];
        this.l3index = this.stackTemp[this.nestingLevel + 2];
        this.l2lower = this.stackTemp[this.nestingLevel + 3];
        this.l2upper = this.stackTemp[this.nestingLevel + 4];
        this.l3lower = this.stackTemp[this.nestingLevel + 5];
        this.l3upper = this.stackTemp[this.nestingLevel + 6];
        this.atTerminal = this.stackTemp[this.nestingLevel + 7] == 1;
        this.LN = this.stackTemp[this.nestingLevel + 8];
        return true;
    }

    public final void push() {
        for (int i = 0; i < this.nestingLevel; ++i) {
            this.stackTemp[i] = this.context[i];
        }
        this.stackTemp[this.nestingLevel] = this.l1index;
        this.stackTemp[this.nestingLevel + 1] = this.l2index;
        this.stackTemp[this.nestingLevel + 2] = this.l3index;
        this.stackTemp[this.nestingLevel + 3] = this.l2lower;
        this.stackTemp[this.nestingLevel + 4] = this.l2upper;
        this.stackTemp[this.nestingLevel + 5] = this.l3lower;
        this.stackTemp[this.nestingLevel + 6] = this.l3upper;
        this.stackTemp[this.nestingLevel + 7] = this.atTerminal ? 1 : 0;
        this.stackTemp[this.nestingLevel + 8] = this.LN;
        this.contextStack.store(this.stackTemp);
    }

    protected final void push2() {
        for (int i = 0; i < this.nestingLevel; ++i) {
            this.stackTemp[i] = this.context[i];
        }
        this.stackTemp[this.nestingLevel] = this.l1index;
        this.stackTemp[this.nestingLevel + 1] = this.l2index;
        this.stackTemp[this.nestingLevel + 2] = this.l3index;
        this.stackTemp[this.nestingLevel + 3] = this.l2lower;
        this.stackTemp[this.nestingLevel + 4] = this.l2upper;
        this.stackTemp[this.nestingLevel + 5] = this.l3lower;
        this.stackTemp[this.nestingLevel + 6] = this.l3upper;
        this.stackTemp[this.nestingLevel + 7] = this.atTerminal ? 1 : 0;
        this.stackTemp[this.nestingLevel + 8] = this.LN;
        this.contextStack2.store(this.stackTemp);
    }

    protected final void clearStack2() {
        this.contextStack2.clear();
    }

    private void resolveLC_l1() {
        block12: {
            if (this.l1index >= 0 && this.l1index < this.l1Buffer.size() && this.context[1] == this.l1Buffer.upper32At(this.l1index)) break block12;
            if (this.l1index >= this.l1Buffer.size() || this.l1index < 0) {
                this.l1index = 0;
            }
            if (this.l1index + 1 < this.l1Buffer.size() && this.context[1] != this.l1Buffer.upper32At(this.l1index + 1)) {
                int init_guess = (int)((float)this.l1Buffer.size() * ((float)this.context[1] / (float)this.vtdBuffer.size()));
                if (this.l1Buffer.upper32At(init_guess) > this.context[1]) {
                    while (this.l1Buffer.upper32At(init_guess) != this.context[1]) {
                        --init_guess;
                    }
                } else if (this.l1Buffer.upper32At(init_guess) < this.context[1]) {
                    while (this.l1Buffer.upper32At(init_guess) != this.context[1]) {
                        ++init_guess;
                    }
                }
                this.l1index = init_guess;
            } else if (this.context[1] >= this.l1Buffer.upper32At(this.l1index)) {
                while (this.context[1] != this.l1Buffer.upper32At(this.l1index) && this.l1index < this.l1Buffer.size()) {
                    ++this.l1index;
                }
            } else {
                while (this.context[1] != this.l1Buffer.upper32At(this.l1index) && this.l1index >= 0) {
                    --this.l1index;
                }
            }
        }
    }

    private void resolveLC_l2() {
        block16: {
            int temp = this.l1Buffer.lower32At(this.l1index);
            if (this.l2lower != temp) {
                this.l2index = this.l2lower = temp;
                this.l2upper = this.l2Buffer.size() - 1;
                for (int i = this.l1index + 1; i < this.l1Buffer.size(); ++i) {
                    temp = this.l1Buffer.lower32At(i);
                    if (temp == -1) continue;
                    this.l2upper = temp - 1;
                    break;
                }
            }
            if (this.l2index >= 0 && this.l2index < this.l2Buffer.size() && this.context[2] == this.l2Buffer.upper32At(this.l2index)) break block16;
            if (this.l2index >= this.l2Buffer.size() || this.l2index < 0) {
                this.l2index = this.l2lower;
            }
            if (this.l2index + 1 < this.l2Buffer.size() && this.context[2] == this.l2Buffer.upper32At(this.l2index + 1)) {
                ++this.l2index;
            } else if (this.l2upper - this.l2lower >= 16) {
                int init_guess = this.l2lower + (int)((float)(this.l2upper - this.l2lower) * ((float)this.context[2] - (float)this.l2Buffer.upper32At(this.l2lower)) / (float)(this.l2Buffer.upper32At(this.l2upper) - this.l2Buffer.upper32At(this.l2lower)));
                if (this.l2Buffer.upper32At(init_guess) > this.context[2]) {
                    while (this.context[2] != this.l2Buffer.upper32At(init_guess)) {
                        --init_guess;
                    }
                } else if (this.l2Buffer.upper32At(init_guess) < this.context[2]) {
                    while (this.context[2] != this.l2Buffer.upper32At(init_guess)) {
                        ++init_guess;
                    }
                }
                this.l2index = init_guess;
            } else if (this.context[2] < this.l2Buffer.upper32At(this.l2index)) {
                while (this.context[2] != this.l2Buffer.upper32At(this.l2index)) {
                    --this.l2index;
                }
            } else {
                while (this.context[2] != this.l2Buffer.upper32At(this.l2index)) {
                    ++this.l2index;
                }
            }
        }
    }

    private void resolveLC_l3() {
        block16: {
            int temp = this.l2Buffer.lower32At(this.l2index);
            if (this.l3lower != temp) {
                this.l3index = this.l3lower = temp;
                this.l3upper = this.l3Buffer.size() - 1;
                for (int i = this.l2index + 1; i < this.l2Buffer.size(); ++i) {
                    temp = this.l2Buffer.lower32At(i);
                    if (temp == -1) continue;
                    this.l3upper = temp - 1;
                    break;
                }
            }
            if (this.l3index >= 0 && this.l3index < this.l3Buffer.size() && this.context[3] == this.l3Buffer.intAt(this.l3index)) break block16;
            if (this.l3index >= this.l3Buffer.size() || this.l3index < 0) {
                this.l3index = this.l3lower;
            }
            if (this.l3index + 1 < this.l3Buffer.size() && this.context[3] == this.l3Buffer.intAt(this.l3index + 1)) {
                ++this.l3index;
            } else if (this.l3upper - this.l3lower >= 16) {
                int init_guess = this.l3lower + (int)((float)(this.l3upper - this.l3lower) * ((float)(this.context[3] - this.l3Buffer.intAt(this.l3lower)) / (float)(this.l3Buffer.intAt(this.l3upper) - this.l3Buffer.intAt(this.l3lower))));
                if (this.l3Buffer.intAt(init_guess) > this.context[3]) {
                    while (this.context[3] != this.l3Buffer.intAt(init_guess)) {
                        --init_guess;
                    }
                } else if (this.l3Buffer.intAt(init_guess) < this.context[3]) {
                    while (this.context[3] != this.l3Buffer.intAt(init_guess)) {
                        ++init_guess;
                    }
                }
                this.l3index = init_guess;
            } else if (this.context[3] < this.l3Buffer.intAt(this.l3index)) {
                while (this.context[3] != this.l3Buffer.intAt(this.l3index)) {
                    --this.l3index;
                }
            } else {
                while (this.context[3] != this.l3Buffer.intAt(this.l3index)) {
                    ++this.l3index;
                }
            }
        }
    }

    private void resolveLC() {
        if (this.context[0] <= 0) {
            return;
        }
        this.resolveLC_l1();
        if (this.context[0] == 1) {
            return;
        }
        this.resolveLC_l2();
        if (this.context[0] == 2) {
            return;
        }
        this.resolveLC_l3();
    }

    protected final int lookupNS() throws NavExceptionHuge {
        if (this.context[0] == -1) {
            throw new NavExceptionHuge("Can't lookup NS for document node");
        }
        int i = this.getTokenLength(this.context[0] != 0 ? this.context[this.context[0]] : this.rootIndex);
        long offset = this.getTokenOffset(this.context[0] != 0 ? this.context[this.context[0]] : this.rootIndex);
        int preLen = i >> 16 & 0xFFFF;
        return this.lookupNS(offset, preLen);
    }

    protected int lookupNS(long offset, int len) {
        int s;
        int k;
        boolean hasNS = false;
        int size = this.vtdBuffer.size();
        block0: for (int i = this.context[0]; i >= 0 && (k = (s = i != 0 ? this.context[i] : this.rootIndex) + 1) < size; --i) {
            int type = this.getTokenType(k);
            while (type == 2 || type == 3) {
                if (type == 3) {
                    hasNS = true;
                    int temp = this.getTokenLength(k);
                    int preLen = temp >> 16 & 0xFFFF;
                    int fullLen = temp & 0xFFFF;
                    long os = this.getTokenOffset(k);
                    if (temp == 5 && len == 0) {
                        long l = this.vtdBuffer.longAt(s);
                        hasNS = false;
                        return k + 1;
                    }
                    if (fullLen - preLen - 1 == len) {
                        boolean a = true;
                        for (int j = 0; j < len; ++j) {
                            if (this.getCharUnit(os + (long)preLen + 1L + (long)j) == this.getCharUnit(offset + (long)j)) continue;
                            a = false;
                            break;
                        }
                        if (a) {
                            return k + 1;
                        }
                    }
                }
                if ((k += 2) >= size) continue block0;
                type = this.getTokenType(k);
            }
        }
        return 0;
    }

    private boolean resolveNS(String URL2, long offset, int len) throws NavExceptionHuge {
        int result = this.lookupNS(offset, len);
        switch (result) {
            case 0: {
                return URL2 == null;
            }
        }
        if (URL2 == null) {
            return false;
        }
        return this.matchTokenString(result, URL2);
    }

    public boolean toElement(int direction) throws NavExceptionHuge {
        switch (direction) {
            case 0: {
                if (this.context[0] != 0) {
                    this.context[0] = 0;
                }
                this.atTerminal = false;
                this.l3index = -1;
                this.l2index = -1;
                this.l1index = -1;
                return true;
            }
            case 1: {
                if (this.atTerminal) {
                    this.atTerminal = false;
                    return true;
                }
                if (this.context[0] > 0) {
                    this.context[this.context[0]] = -1;
                    this.context[0] = this.context[0] - 1;
                    return true;
                }
                if (this.context[0] == 0) {
                    this.context[0] = -1;
                    return true;
                }
                return false;
            }
            case 2: 
            case 3: {
                if (this.atTerminal) {
                    return false;
                }
                switch (this.context[0]) {
                    case -1: {
                        this.context[0] = 0;
                        return true;
                    }
                    case 0: {
                        if (this.l1Buffer.size() > 0) {
                            this.context[0] = 1;
                            this.l1index = direction == 2 ? 0 : this.l1Buffer.size() - 1;
                            this.context[1] = this.l1Buffer.upper32At(this.l1index);
                            return true;
                        }
                        return false;
                    }
                    case 1: {
                        this.l2lower = this.l1Buffer.lower32At(this.l1index);
                        if (this.l2lower == -1) {
                            return false;
                        }
                        this.context[0] = 2;
                        this.l2upper = this.l2Buffer.size() - 1;
                        int size = this.l1Buffer.size();
                        for (int i = this.l1index + 1; i < size; ++i) {
                            int temp = this.l1Buffer.lower32At(i);
                            if (temp == -1) continue;
                            this.l2upper = temp - 1;
                            break;
                        }
                        this.l2index = direction == 2 ? this.l2lower : this.l2upper;
                        this.context[2] = this.l2Buffer.upper32At(this.l2index);
                        return true;
                    }
                    case 2: {
                        this.l3lower = this.l2Buffer.lower32At(this.l2index);
                        if (this.l3lower == -1) {
                            return false;
                        }
                        this.context[0] = 3;
                        this.l3upper = this.l3Buffer.size() - 1;
                        int size = this.l2Buffer.size();
                        for (int i = this.l2index + 1; i < size; ++i) {
                            int temp = this.l2Buffer.lower32At(i);
                            if (temp == -1) continue;
                            this.l3upper = temp - 1;
                            break;
                        }
                        this.l3index = direction == 2 ? this.l3lower : this.l3upper;
                        this.context[3] = this.l3Buffer.intAt(this.l3index);
                        return true;
                    }
                }
                if (direction == 2) {
                    int size = this.vtdBuffer.size();
                    for (int index = this.context[this.context[0]] + 1; index < size; ++index) {
                        long temp = this.vtdBuffer.longAt(index);
                        int token_type = (int)((0xF000000000000000L & temp) >> 60) & 0xF;
                        if (token_type != 0) continue;
                        int depth = (int)((0xF80000000000000L & temp) >> 55);
                        if (depth <= this.context[0]) {
                            return false;
                        }
                        if (depth != this.context[0] + 1) continue;
                        this.context[0] = this.context[0] + 1;
                        this.context[this.context[0]] = index;
                        return true;
                    }
                    return false;
                }
                int last_index = -1;
                int size = this.vtdBuffer.size();
                for (int index = this.context[this.context[0]] + 1; index < size; ++index) {
                    long temp = this.vtdBuffer.longAt(index);
                    int depth = (int)((0xF80000000000000L & temp) >> 55);
                    int token_type = (int)((0xF000000000000000L & temp) >> 60) & 0xF;
                    if (token_type != 0) continue;
                    if (depth <= this.context[0]) break;
                    if (depth != this.context[0] + 1) continue;
                    last_index = index;
                }
                if (last_index == -1) {
                    return false;
                }
                this.context[0] = this.context[0] + 1;
                this.context[this.context[0]] = last_index;
                return true;
            }
            case 4: 
            case 5: {
                if (this.atTerminal) {
                    return false;
                }
                switch (this.context[0]) {
                    case -1: 
                    case 0: {
                        return false;
                    }
                    case 1: {
                        if (direction == 4) {
                            if (this.l1index + 1 >= this.l1Buffer.size()) {
                                return false;
                            }
                            ++this.l1index;
                        } else {
                            if (this.l1index - 1 < 0) {
                                return false;
                            }
                            --this.l1index;
                        }
                        this.context[1] = this.l1Buffer.upper32At(this.l1index);
                        return true;
                    }
                    case 2: {
                        if (direction == 4) {
                            if (this.l2index + 1 > this.l2upper) {
                                return false;
                            }
                            ++this.l2index;
                        } else {
                            if (this.l2index - 1 < this.l2lower) {
                                return false;
                            }
                            --this.l2index;
                        }
                        this.context[2] = this.l2Buffer.upper32At(this.l2index);
                        return true;
                    }
                    case 3: {
                        if (direction == 4) {
                            if (this.l3index + 1 > this.l3upper) {
                                return false;
                            }
                            ++this.l3index;
                        } else {
                            if (this.l3index - 1 < this.l3lower) {
                                return false;
                            }
                            --this.l3index;
                        }
                        this.context[3] = this.l3Buffer.intAt(this.l3index);
                        return true;
                    }
                }
                if (direction == 4) {
                    int size = this.vtdBuffer.size();
                    for (int index = this.context[this.context[0]] + 1; index < size; ++index) {
                        long temp = this.vtdBuffer.longAt(index);
                        int token_type = (int)((0xF000000000000000L & temp) >> 60) & 0xF;
                        if (token_type != 0) continue;
                        int depth = (int)((0xF80000000000000L & temp) >> 55);
                        if (depth < this.context[0]) {
                            return false;
                        }
                        if (depth != this.context[0]) continue;
                        this.context[this.context[0]] = index;
                        return true;
                    }
                    return false;
                }
                for (int index = this.context[this.context[0]] - 1; index > this.context[this.context[0] - 1]; --index) {
                    int depth;
                    long temp = this.vtdBuffer.longAt(index);
                    int token_type = (int)((0xF000000000000000L & temp) >> 60) & 0xF;
                    if (token_type != 0 || (depth = (int)((0xF80000000000000L & temp) >> 55)) != this.context[0]) continue;
                    this.context[this.context[0]] = index;
                    return true;
                }
                return false;
            }
        }
        throw new NavExceptionHuge("illegal navigation options");
    }

    public boolean toElement(int direction, String en) throws NavExceptionHuge {
        int val = 0;
        if (en == null) {
            throw new IllegalArgumentException(" Element name can't be null ");
        }
        if (en.equals("*")) {
            return this.toElement(direction);
        }
        switch (direction) {
            case 0: {
                return this.toElement(0);
            }
            case 1: {
                return this.toElement(1);
            }
            case 2: {
                if (this.atTerminal) {
                    return false;
                }
                if (!this.toElement(2)) {
                    return false;
                }
                if (!this.matchElement(en)) {
                    if (this.toElement(4, en)) {
                        return true;
                    }
                    this.context[0] = this.context[0] - 1;
                    return false;
                }
                return true;
            }
            case 3: {
                if (this.atTerminal) {
                    return false;
                }
                if (!this.toElement(3)) {
                    return false;
                }
                if (!this.matchElement(en)) {
                    if (this.toElement(5, en)) {
                        return true;
                    }
                    this.context[0] = this.context[0] - 1;
                    return false;
                }
                return true;
            }
            case 4: {
                if (this.atTerminal) {
                    return false;
                }
                int d = this.context[0];
                switch (d) {
                    case -1: 
                    case 0: {
                        return false;
                    }
                    case 1: {
                        val = this.l1index;
                        break;
                    }
                    case 2: {
                        val = this.l2index;
                        break;
                    }
                    case 3: {
                        val = this.l3index;
                        break;
                    }
                }
                int temp = this.context[d];
                while (this.toElement(4)) {
                    if (!this.matchElement(en)) continue;
                    return true;
                }
                switch (d) {
                    case 1: {
                        this.l1index = val;
                        break;
                    }
                    case 2: {
                        this.l2index = val;
                        break;
                    }
                    case 3: {
                        this.l3index = val;
                        break;
                    }
                }
                this.context[d] = temp;
                return false;
            }
            case 5: {
                if (this.atTerminal) {
                    return false;
                }
                int d = this.context[0];
                switch (d) {
                    case -1: 
                    case 0: {
                        return false;
                    }
                    case 1: {
                        val = this.l1index;
                        break;
                    }
                    case 2: {
                        val = this.l2index;
                        break;
                    }
                    case 3: {
                        val = this.l3index;
                        break;
                    }
                }
                int temp = this.context[d];
                while (this.toElement(5)) {
                    if (!this.matchElement(en)) continue;
                    return true;
                }
                switch (d) {
                    case 1: {
                        this.l1index = val;
                        break;
                    }
                    case 2: {
                        this.l2index = val;
                        break;
                    }
                    case 3: {
                        this.l3index = val;
                        break;
                    }
                }
                this.context[d] = temp;
                return false;
            }
        }
        throw new NavExceptionHuge("illegal navigation options");
    }

    public boolean toElementNS(int direction, String URL2, String ln) throws NavExceptionHuge {
        int val = 0;
        if (!this.ns) {
            return false;
        }
        switch (direction) {
            case 0: {
                return this.toElement(0);
            }
            case 1: {
                return this.toElement(1);
            }
            case 2: {
                if (this.atTerminal) {
                    return false;
                }
                if (!this.toElement(2)) {
                    return false;
                }
                if (!this.matchElementNS(URL2, ln)) {
                    if (this.toElementNS(4, URL2, ln)) {
                        return true;
                    }
                    this.context[0] = this.context[0] - 1;
                    return false;
                }
                return true;
            }
            case 3: {
                if (this.atTerminal) {
                    return false;
                }
                if (!this.toElement(3)) {
                    return false;
                }
                if (!this.matchElementNS(URL2, ln)) {
                    if (this.toElementNS(5, URL2, ln)) {
                        return true;
                    }
                    this.context[0] = this.context[0] - 1;
                    return false;
                }
                return true;
            }
            case 4: {
                if (this.atTerminal) {
                    return false;
                }
                int d = this.context[0];
                int temp = this.context[d];
                switch (d) {
                    case -1: 
                    case 0: {
                        return false;
                    }
                    case 1: {
                        val = this.l1index;
                        break;
                    }
                    case 2: {
                        val = this.l2index;
                        break;
                    }
                    case 3: {
                        val = this.l3index;
                        break;
                    }
                }
                while (this.toElement(4)) {
                    if (!this.matchElementNS(URL2, ln)) continue;
                    return true;
                }
                switch (d) {
                    case 1: {
                        this.l1index = val;
                        break;
                    }
                    case 2: {
                        this.l2index = val;
                        break;
                    }
                    case 3: {
                        this.l3index = val;
                        break;
                    }
                }
                this.context[d] = temp;
                return false;
            }
            case 5: {
                if (this.atTerminal) {
                    return false;
                }
                int d = this.context[0];
                int temp = this.context[d];
                switch (d) {
                    case -1: 
                    case 0: {
                        return false;
                    }
                    case 1: {
                        val = this.l1index;
                        break;
                    }
                    case 2: {
                        val = this.l2index;
                        break;
                    }
                    case 3: {
                        val = this.l3index;
                        break;
                    }
                }
                while (this.toElement(5)) {
                    if (!this.matchElementNS(URL2, ln)) continue;
                    return true;
                }
                switch (d) {
                    case 1: {
                        this.l1index = val;
                        break;
                    }
                    case 2: {
                        this.l2index = val;
                        break;
                    }
                    case 3: {
                        this.l3index = val;
                        break;
                    }
                }
                this.context[d] = temp;
                return false;
            }
        }
        throw new NavExceptionHuge("illegal navigation options");
    }

    public String toNormalizedString(int index) throws NavExceptionHuge {
        long l;
        long temp;
        int ch;
        int type = this.getTokenType(index);
        if (type != 5 && type != 4) {
            return this.toRawString(index);
        }
        int len = type == 0 || type == 2 || type == 3 ? this.getTokenLength(index) & 0xFFFF : this.getTokenLength(index);
        if (len == 0) {
            return "";
        }
        long offset = this.getTokenOffset(index);
        long endOffset = (long)len + offset - 1L;
        StringBuffer sb = new StringBuffer(len);
        do {
            temp = offset;
            l = this.getChar(offset);
            ch = (int)l;
            offset += (long)((int)(l >> 32));
        } while (this.isWS(ch));
        offset = temp;
        boolean d = false;
        while (offset <= endOffset) {
            l = this.getCharResolved(offset);
            ch = (int)l;
            if (this.isWS(ch) && this.getCharUnit((offset += (long)((int)(l >> 32))) - 1L) != 59) {
                d = true;
                continue;
            }
            if (!d) {
                sb.append((char)ch);
                continue;
            }
            sb.append(' ');
            sb.append((char)ch);
            d = false;
        }
        return sb.toString();
    }

    public String toRawString(int index) throws NavExceptionHuge {
        int type = this.getTokenType(index);
        int len = type == 0 || type == 2 || type == 3 ? this.getTokenLength(index) & 0xFFFF : this.getTokenLength(index);
        long offset = this.getTokenOffset(index);
        return this.toRawString(offset, len);
    }

    protected String toRawString(long os, int len) throws NavExceptionHuge {
        long l;
        StringBuffer sb = new StringBuffer(len);
        long endOffset = os + (long)len;
        for (long offset = os; offset < endOffset; offset += (long)((int)(l >> 32))) {
            l = this.getChar(offset);
            sb.append((char)l);
        }
        return sb.toString();
    }

    public final String toRawStringLowerCase(int index) throws NavExceptionHuge {
        int type = this.getTokenType(index);
        int len = type == 0 || type == 2 || type == 3 ? this.getTokenLength(index) & 0xFFFF : this.getTokenLength(index);
        long offset = this.getTokenOffset(index);
        return this.toRawStringLowerCase(offset, len);
    }

    public final String toRawStringUpperCase(int index) throws NavExceptionHuge {
        int type = this.getTokenType(index);
        int len = type == 0 || type == 2 || type == 3 ? this.getTokenLength(index) & 0xFFFF : this.getTokenLength(index);
        long offset = this.getTokenOffset(index);
        return this.toRawStringUpperCase(offset, len);
    }

    protected final String toRawStringLowerCase(long os, int len) throws NavExceptionHuge {
        long l;
        StringBuffer sb = new StringBuffer(len);
        long endOffset = os + (long)len;
        for (long offset = os; offset < endOffset; offset += (long)((int)(l >> 32))) {
            l = this.getChar(offset);
            if ((int)l > 64 && (int)l < 91) {
                sb.append((char)(l + 32L));
                continue;
            }
            sb.append((char)l);
        }
        return sb.toString();
    }

    protected final String toRawStringUpperCase(long os, int len) throws NavExceptionHuge {
        long l;
        StringBuffer sb = new StringBuffer(len);
        long endOffset = os + (long)len;
        for (long offset = os; offset < endOffset; offset += (long)((int)(l >> 32))) {
            l = this.getChar(offset);
            if ((int)l > 96 && (int)l < 123) {
                sb.append((char)(l - 32L));
                continue;
            }
            sb.append((char)l);
        }
        return sb.toString();
    }

    public String toString(int index) throws NavExceptionHuge {
        int type = this.getTokenType(index);
        if (type != 5 && type != 4) {
            return this.toRawString(index);
        }
        int len = type == 0 || type == 2 || type == 3 ? this.getTokenLength(index) & 0xFFFF : this.getTokenLength(index);
        long offset = this.getTokenOffset(index);
        return this.toString(offset, len);
    }

    protected String toString(long os, int len) throws NavExceptionHuge {
        long l;
        StringBuffer sb = new StringBuffer(len);
        long endOffset = os + (long)len;
        for (long offset = os; offset < endOffset; offset += (long)((int)(l >> 32))) {
            l = this.getCharResolved(offset);
            sb.append((char)l);
        }
        return sb.toString();
    }

    public final boolean matchTokens(int i1, VTDNavHuge vn2, int i2) throws NavExceptionHuge {
        return this.compareTokens(i1, vn2, i2) == 0;
    }

    protected final void setAtTerminal(boolean b) {
        this.atTerminal = b;
    }

    protected final boolean getAtTerminal() {
        return this.atTerminal;
    }

    public void sampleState(FastIntBuffer fib) {
        if (this.context[0] >= 1) {
            fib.append(this.l1index);
        }
        if (this.context[0] >= 2) {
            fib.append(this.l2index);
            fib.append(this.l2lower);
            fib.append(this.l2upper);
        }
        if (this.context[0] >= 3) {
            fib.append(this.l3index);
            fib.append(this.l3lower);
            fib.append(this.l3upper);
        }
    }

    public final int getStringLength(int index) throws NavExceptionHuge {
        int type = this.getTokenType(index);
        if (type != 5 && type != 4) {
            return this.getRawStringLength(index);
        }
        int len = 0;
        int len1 = 0;
        len = this.getTokenLength(index);
        long offset = this.getTokenOffset(index);
        long endOffset = offset + (long)len;
        while (offset < endOffset) {
            long l = this.getCharResolved(offset);
            offset += (long)((int)(l >> 32));
            ++len1;
        }
        return len1;
    }

    public final int getRawStringLength(int index) throws NavExceptionHuge {
        int type = this.getTokenType(index);
        int len = 0;
        int len1 = 0;
        len = type == 0 || type == 2 || type == 3 ? this.getTokenLength(index) & 0xFFFF : this.getTokenLength(index);
        long offset = this.getTokenOffset(index);
        long endOffset = offset + (long)len;
        while (offset < endOffset) {
            long l = this.getChar(offset);
            offset += (long)((int)(l >> 32));
            ++len1;
        }
        return len1;
    }

    public int compareTokens(int i1, VTDNavHuge vn2, int i2) throws NavExceptionHuge {
        long l;
        long offset2;
        if (i1 == i2 && this == vn2) {
            return 0;
        }
        int t1 = this.getTokenType(i1);
        int t2 = vn2.getTokenType(i2);
        long offset1 = this.getTokenOffset(i1);
        int len1 = t1 == 0 || t1 == 2 || t1 == 3 ? this.getTokenLength(i1) & 0xFFFF : this.getTokenLength(i1);
        int len2 = t2 == 0 || t2 == 2 || t2 == 3 ? vn2.getTokenLength(i2) & 0xFFFF : vn2.getTokenLength(i2);
        long endOffset1 = (long)len1 + offset1;
        long endOffset2 = (long)len2 + offset2;
        for (offset2 = vn2.getTokenOffset(i2); offset1 < endOffset1 && offset2 < endOffset2; offset1 += (long)((int)(l >> 32)), offset2 += (long)((int)(l >> 32))) {
            l = t1 == 5 || t1 == 4 ? this.getCharResolved(offset1) : this.getChar(offset1);
            int ch1 = (int)l;
            l = t2 == 5 || t2 == 4 ? vn2.getCharResolved(offset2) : vn2.getChar(offset2);
            int ch2 = (int)l;
            if (ch1 <= ch2) continue;
            return 1;
        }
        if (offset1 == endOffset1 && offset2 < endOffset2) {
            return -1;
        }
        if (offset1 < endOffset1 && offset2 == endOffset2) {
            return 1;
        }
        return 0;
    }

    public final boolean startsWith(int index, String s) throws NavExceptionHuge {
        long l1;
        int type = this.getTokenType(index);
        int len = type == 0 || type == 2 || type == 3 ? this.getTokenLength(index) & 0xFFFF : this.getTokenLength(index);
        long offset = this.getTokenOffset(index);
        long endOffset = offset + (long)len;
        boolean b = type == 5 || type == 4;
        int l = s.length();
        if (l > len) {
            return false;
        }
        for (int i = 0; i < l && offset < endOffset; offset += (long)((int)(l1 >> 32)), ++i) {
            l1 = b ? this.getCharResolved(offset) : this.getChar(offset);
            char i1 = s.charAt(i);
            if (i1 == (int)l1) continue;
            return false;
        }
        return true;
    }

    public final boolean endsWith(int index, String s) throws NavExceptionHuge {
        long l1;
        int i;
        int type = this.getTokenType(index);
        int len = type == 0 || type == 2 || type == 3 ? this.getTokenLength(index) & 0xFFFF : this.getTokenLength(index);
        long offset = this.getTokenOffset(index);
        boolean b = type == 5 || type == 4;
        int l = s.length();
        int i2 = this.getStringLength(index);
        if (l > len || l > i2) {
            return false;
        }
        i2 -= l;
        for (i = 0; i < i2; ++i) {
            l1 = b ? this.getCharResolved(offset) : this.getChar(offset);
            offset += (long)((int)(l1 >> 32));
        }
        for (i = 0; i < l; ++i) {
            l1 = b ? this.getCharResolved(offset) : this.getChar(offset);
            char i1 = s.charAt(i);
            if (i1 != (int)l1) {
                return false;
            }
            offset += (long)((int)(l1 >> 32));
        }
        return true;
    }

    public String toStringLowerCase(int index) throws NavExceptionHuge {
        int type = this.getTokenType(index);
        if (type != 5 && type != 4) {
            return this.toRawStringLowerCase(index);
        }
        int len = this.getTokenLength(index);
        long offset = this.getTokenOffset(index);
        return this.toStringLowerCase(offset, len);
    }

    protected final String toStringLowerCase(long os, int len) throws NavExceptionHuge {
        long l;
        StringBuffer sb = new StringBuffer(len);
        long endOffset = os + (long)len;
        for (long offset = os; offset < endOffset; offset += (long)((int)(l >> 32))) {
            l = this.getCharResolved(offset);
            if ((int)l > 64 && (int)l < 91) {
                sb.append((char)(l + 32L));
                continue;
            }
            sb.append((char)l);
        }
        return sb.toString();
    }

    public String toStringUpperCase(int index) throws NavExceptionHuge {
        int type = this.getTokenType(index);
        if (type != 5 && type != 4) {
            return this.toRawStringUpperCase(index);
        }
        int len = this.getTokenLength(index);
        long offset = this.getTokenOffset(index);
        return this.toStringUpperCase(offset, len);
    }

    protected final String toStringUpperCase(long os, int len) throws NavExceptionHuge {
        long l;
        StringBuffer sb = new StringBuffer(len);
        long endOffset = os + (long)len;
        for (long offset = os; offset < endOffset; offset += (long)((int)(l >> 32))) {
            l = this.getCharResolved(offset);
            if ((int)l > 96 && (int)l < 123) {
                sb.append((char)(l - 32L));
                continue;
            }
            sb.append((char)l);
        }
        return sb.toString();
    }

    public long[] getElementFragment() throws NavExceptionHuge {
        int size;
        long[] result = new long[2];
        int depth = this.getCurrentDepth();
        if (depth == -1) {
            int i = this.vtdBuffer.lower32At(0);
            if (i == 0) {
                result[0] = this.docOffset;
                result[1] = this.docLen;
            } else {
                result[0] = 32L;
                result[1] = this.docLen - 32L;
            }
            return result;
        }
        long so = this.getTokenOffset(this.getCurrentIndex2()) - 1L;
        long length = 0L;
        if (this.toElement(4)) {
            int temp = this.getCurrentIndex();
            while (this.getTokenDepth(temp) < depth) {
                --temp;
            }
            long so2 = this.getTokenOffset(temp) - 1L;
            while (this.getCharUnit(so2) != 62) {
                --so2;
            }
            length = so2 - so + 1L;
            this.toElement(5);
            if (this.encoding <= 26) {
                result[0] = so;
                result[1] = length;
            } else {
                result[0] = so << 1;
                result[1] = length << 1;
            }
            return result;
        }
        if (depth == 0) {
            int temp = this.vtdBuffer.size() - 1;
            boolean b = false;
            long so2 = 0L;
            while (this.getTokenDepth(temp) == -1) {
                --temp;
                b = true;
            }
            so2 = !b ? (this.encoding <= 26 ? this.docOffset + this.docLen - 1L : (this.docOffset + this.docLen >> 1) - 1L) : this.getTokenOffset(temp + 1);
            while (this.getCharUnit(so2) != 62) {
                --so2;
            }
            length = so2 - so + 1L;
            if (this.encoding <= 26) {
                result[0] = so;
                result[1] = length;
            } else {
                result[0] = so << 1;
                result[1] = length << 1;
            }
            return result;
        }
        int temp = this.getCurrentIndex() + 1;
        if (temp < (size = this.vtdBuffer.size())) {
            while (temp < size && this.getTokenDepth(temp) >= depth) {
                ++temp;
            }
            if (temp != size) {
                int d = depth - this.getTokenDepth(temp) + (this.getTokenType(temp) == 0 ? 1 : 0);
                long so2 = this.getTokenOffset(temp) - 1L;
                int i = 0;
                while (i < d) {
                    if (this.getCharUnit(so2) == 62) {
                        ++i;
                    }
                    --so2;
                }
                length = so2 - so + 2L;
                if (this.encoding <= 26) {
                    result[0] = so;
                    result[1] = length;
                } else {
                    result[0] = so << 1;
                    result[1] = length << 1;
                }
                return result;
            }
        }
        long so2 = this.encoding <= 26 ? this.docOffset + this.docLen - 1L : (this.docOffset + this.docLen >> 1) - 1L;
        int d = depth + 1;
        int i = 0;
        while (i < d) {
            if (this.getCharUnit(so2) == 62) {
                ++i;
            }
            --so2;
        }
        length = so2 - so + 2L;
        if (this.encoding <= 26) {
            result[0] = so;
            result[1] = length;
        } else {
            result[0] = so << 1;
            result[1] = length << 1;
        }
        return result;
    }

    public long[] getContentFragment() throws NavExceptionHuge {
        int size;
        long[] result = new long[2];
        int depth = this.getCurrentDepth();
        if (depth == -1) {
            int i = this.vtdBuffer.lower32At(0);
            if (i == 0) {
                result[0] = this.docOffset;
                result[1] = this.docLen;
            } else {
                result[0] = 32L;
                result[1] = this.docLen - 32L;
            }
            return result;
        }
        long so = this.getOffsetAfterHead();
        if (so == -1L) {
            return null;
        }
        long length = 0L;
        if (this.toElement(4)) {
            int temp = this.getCurrentIndex();
            while (this.getTokenDepth(temp) < depth) {
                --temp;
            }
            long so2 = this.getTokenOffset(temp) - 1L;
            while (this.getCharUnit(so2) != 62) {
                --so2;
            }
            while (this.getCharUnit(so2) != 47) {
                --so2;
            }
            while (this.getCharUnit(so2) != 60) {
                --so2;
            }
            length = so2 - so;
            this.toElement(5);
            if (this.encoding <= 26) {
                result[0] = so;
                result[1] = length;
            } else {
                result[0] = so << 1;
                result[1] = length << 1;
            }
            return result;
        }
        if (depth == 0) {
            int temp = this.vtdBuffer.size() - 1;
            boolean b = false;
            long so2 = 0L;
            while (this.getTokenDepth(temp) == -1) {
                --temp;
                b = true;
            }
            so2 = !b ? (this.encoding <= 26 ? this.docOffset + this.docLen - 1L : (this.docOffset + this.docLen >> 1) - 1L) : this.getTokenOffset(temp + 1);
            while (this.getCharUnit(so2) != 62) {
                --so2;
            }
            while (this.getCharUnit(so2) != 47) {
                --so2;
            }
            while (this.getCharUnit(so2) != 60) {
                --so2;
            }
            length = so2 - so;
            if (this.encoding <= 26) {
                result[0] = so;
                result[1] = length;
            } else {
                result[0] = so << 1;
                result[1] = length << 1;
            }
            return result;
        }
        int temp = this.getCurrentIndex() + 1;
        if (temp < (size = this.vtdBuffer.size())) {
            while (temp < size && this.getTokenDepth(temp) >= depth) {
                ++temp;
            }
            if (temp != size) {
                int d = depth - this.getTokenDepth(temp) + (this.getTokenType(temp) == 0 ? 1 : 0);
                long so2 = this.getTokenOffset(temp) - 1L;
                int i = 0;
                while (i < d) {
                    if (this.getCharUnit(so2) == 62) {
                        ++i;
                    }
                    --so2;
                }
                while (this.getCharUnit(so2) != 47) {
                    --so2;
                }
                while (this.getCharUnit(so2) != 60) {
                    --so2;
                }
                length = so2 - so;
                if (this.encoding <= 26) {
                    result[0] = so;
                    result[1] = length;
                } else {
                    result[0] = so << 1;
                    result[1] = length << 1;
                }
                return result;
            }
        }
        long so2 = this.encoding <= 26 ? this.docOffset + this.docLen - 1L : (this.docOffset + this.docLen >> 1) - 1L;
        int d = depth + 1;
        int i = 0;
        while (i < d) {
            if (this.getCharUnit(so2) == 62) {
                ++i;
            }
            --so2;
        }
        while (this.getCharUnit(so2) != 47) {
            --so2;
        }
        while (this.getCharUnit(so2) != 60) {
            --so2;
        }
        length = so2 - so;
        if (this.encoding <= 26) {
            result[0] = so;
            result[1] = length;
        } else {
            result[0] = so << 1;
            result[1] = length << 1;
        }
        return result;
    }

    public ElementFragmentNsHuge getElementFragmentNs() throws NavExceptionHuge {
        if (!this.ns) {
            throw new NavExceptionHuge("getElementFragmentNS can only be called when parsing is ns enabled");
        }
        FastIntBuffer fib = new FastIntBuffer(3);
        int[] ia = this.context;
        int d = ia[0];
        int c = this.getCurrentIndex2();
        int len = c == 0 || c == this.rootIndex ? 0 : this.getTokenLength(c) & 0xFFFF;
        int i = 0;
        int count = 0;
        if (d > 0) {
            int type;
            int k = this.getCurrentIndex2() + 1;
            if (k < this.vtdSize) {
                while (k < this.vtdSize) {
                    type = this.getTokenType(k);
                    if ((type == 2 || type == 3) && type == 3) {
                        fib.append(k);
                    }
                    k += 2;
                }
            }
            count = fib.size();
            --d;
            while (d >= 0) {
                k = d > 0 ? ia[d] + 1 : this.rootIndex + 1;
                if (k < this.vtdSize) {
                    while (k < this.vtdSize) {
                        type = this.getTokenType(k);
                        if (type == 2 || type == 3) {
                            boolean unique = true;
                            if (type == 3) {
                                for (int z = 0; z < fib.size(); ++z) {
                                    if (!this.matchTokens(fib.intAt(z), this, k)) continue;
                                    unique = false;
                                    break;
                                }
                                if (unique) {
                                    fib.append(k);
                                }
                            }
                        }
                        k += 2;
                    }
                }
                --d;
            }
            int newSz = fib.size() - count;
            for (i = 0; i < newSz; ++i) {
                fib.modifyEntry(i, fib.intAt(i + count));
            }
            fib.resize(newSz);
        }
        long[] l = this.getElementFragment();
        return new ElementFragmentNsHuge(this, l, fib, len);
    }

    public final VTDNavHuge duplicateNav() {
        return new VTDNavHuge(this.rootIndex, this.encoding, this.ns, this.nestingLevel - 1, this.XMLDoc, this.vtdBuffer, this.l1Buffer, this.l2Buffer, this.l3Buffer, this.docOffset, this.docLen);
    }

    public final VTDNavHuge cloneNav() {
        VTDNavHuge vn = new VTDNavHuge(this.rootIndex, this.encoding, this.ns, this.nestingLevel - 1, this.XMLDoc, this.vtdBuffer, this.l1Buffer, this.l2Buffer, this.l3Buffer, this.docOffset, this.docLen);
        vn.atTerminal = this.atTerminal;
        vn.LN = this.LN;
        if (this.context[0] != -1) {
            System.arraycopy(this.context, 0, vn.context, 0, this.context[0]);
        } else {
            vn.context[0] = -1;
        }
        vn.l1index = this.l1index;
        if (this.getCurrentDepth() > 1) {
            vn.l2index = this.l2index;
            vn.l2upper = this.l2upper;
            vn.l2lower = this.l2lower;
        }
        if (this.getCurrentDepth() > 2) {
            vn.l3lower = this.l3lower;
            vn.l3index = this.l3index;
            vn.l3upper = this.l3upper;
        }
        return vn;
    }

    public long[] getSiblingElementFragments(int i) throws NavExceptionHuge {
        if (i <= 0) {
            throw new IllegalArgumentException(" # of sibling can be less or equal to 0");
        }
        if (this.atTerminal) {
            return null;
        }
        long so = this.getTokenOffset(this.getCurrentIndex()) - 1L;
        if (this.encoding >= 63) {
            so <<= 1;
        }
        BookMarkHuge bmh = new BookMarkHuge(this);
        bmh.recordCursorPosition();
        while (i > 1 && this.toElement(4)) {
            --i;
        }
        long[] l = this.getElementFragment();
        long len = l[0] + l[1] - so;
        if (i != 1 || !this.toElement(4)) {
            bmh.setCursorPosition();
        }
        l[0] = so;
        l[1] = len;
        return l;
    }
}

