/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.config.AbstractMongoConfigBuilder;
import de.flapdoodle.embed.mongo.config.IMongoDumpConfig;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.config.SupportConfig;
import de.flapdoodle.embed.mongo.config.Timeout;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.process.builder.TypedProperty;
import java.io.IOException;

public class MongoDumpConfigBuilder
extends AbstractMongoConfigBuilder<IMongoDumpConfig> {
    protected static final TypedProperty<Boolean> VERBOSE = TypedProperty.with((String)"verbose", Boolean.class);
    protected static final TypedProperty<String> DB_NAME = TypedProperty.with((String)"db", String.class);
    protected static final TypedProperty<String> COLLECTION = TypedProperty.with((String)"collection", String.class);
    protected static final TypedProperty<String> QUERY = TypedProperty.with((String)"query", String.class);
    protected static final TypedProperty<String> QUERY_FILE = TypedProperty.with((String)"queryFile", String.class);
    protected static final TypedProperty<String> READ_PREFERENCE = TypedProperty.with((String)"readPreference", String.class);
    protected static final TypedProperty<Boolean> FORCE_TABLE_SCAN = TypedProperty.with((String)"forceTableScan", Boolean.class);
    protected static final TypedProperty<String> ARCHIVE = TypedProperty.with((String)"archive", String.class);
    protected static final TypedProperty<Boolean> DUMP_DB_USERS_ROLES = TypedProperty.with((String)"dumpDbUsersAndRoles", Boolean.class);
    protected static final TypedProperty<Boolean> GZIP = TypedProperty.with((String)"gzip", Boolean.class);
    protected static final TypedProperty<Boolean> REPAIR = TypedProperty.with((String)"repair", Boolean.class);
    protected static final TypedProperty<String> OUT = TypedProperty.with((String)"dir", String.class);
    protected static final TypedProperty<Boolean> OPLOG = TypedProperty.with((String)"oplog", Boolean.class);
    protected static final TypedProperty<String> EXCLUDE_COLLECTION = TypedProperty.with((String)"excludeCollection", String.class);
    protected static final TypedProperty<String> EXCLUDE_COLLECTION_WITH_PREFIX = TypedProperty.with((String)"excludeCollectionWithPrefix", String.class);
    protected static final TypedProperty<Integer> NUM_PARALLEL_COLLECTIONS = TypedProperty.with((String)"numParallelCollections", Integer.class);

    public MongoDumpConfigBuilder() throws IOException {
        this.property(PID_FILE).setDefault((Object)"mongodump.pid");
        this.property(VERBOSE).setDefault((Object)false);
        this.property(GZIP).setDefault((Object)Boolean.FALSE);
        this.property(OPLOG).setDefault((Object)Boolean.FALSE);
        this.property(REPAIR).setDefault((Object)Boolean.FALSE);
        this.property(DUMP_DB_USERS_ROLES).setDefault((Object)Boolean.FALSE);
        this.property(FORCE_TABLE_SCAN).setDefault((Object)Boolean.FALSE);
        this.property(NUM_PARALLEL_COLLECTIONS).setDefault((Object)4);
    }

    public MongoDumpConfigBuilder version(IFeatureAwareVersion version) {
        this.version().set((Object)version);
        return this;
    }

    public MongoDumpConfigBuilder timeout(Timeout timeout) {
        this.timeout().set((Object)timeout);
        return this;
    }

    public MongoDumpConfigBuilder net(Net net) {
        this.net().set((Object)net);
        return this;
    }

    public MongoDumpConfigBuilder verbose(Boolean verbose) {
        this.set(VERBOSE, verbose);
        return this;
    }

    public MongoDumpConfigBuilder db(String dbName) {
        this.set(DB_NAME, dbName);
        return this;
    }

    public MongoDumpConfigBuilder collection(String collection) {
        this.set(COLLECTION, collection);
        return this;
    }

    public MongoDumpConfigBuilder query(String query) {
        this.set(QUERY, query);
        return this;
    }

    public MongoDumpConfigBuilder queryFile(String queryFile) {
        this.set(QUERY_FILE, queryFile);
        return this;
    }

    public MongoDumpConfigBuilder readPreference(String readPreference) {
        this.set(READ_PREFERENCE, readPreference);
        return this;
    }

    public MongoDumpConfigBuilder forceTableScan(Boolean forceTableScan) {
        this.set(FORCE_TABLE_SCAN, forceTableScan);
        return this;
    }

    public MongoDumpConfigBuilder archive(String archive) {
        this.set(ARCHIVE, archive);
        return this;
    }

    public MongoDumpConfigBuilder dumpDbUsersAndRoles(Boolean dumpDbUsersAndRoles) {
        this.set(DUMP_DB_USERS_ROLES, dumpDbUsersAndRoles);
        return this;
    }

    public MongoDumpConfigBuilder out(String out) {
        this.set(OUT, out);
        return this;
    }

    public MongoDumpConfigBuilder repair(Boolean repair) {
        this.set(REPAIR, repair);
        return this;
    }

    public MongoDumpConfigBuilder gzip(Boolean gzip) {
        this.set(GZIP, gzip);
        return this;
    }

    public MongoDumpConfigBuilder oplog(boolean oplog) {
        this.set(OPLOG, oplog);
        return this;
    }

    public MongoDumpConfigBuilder excludeCollection(String excludeCollection) {
        this.set(EXCLUDE_COLLECTION, excludeCollection);
        return this;
    }

    public MongoDumpConfigBuilder excludeCollectionWithPrefix(String excludeCollectionWithPrefix) {
        this.set(EXCLUDE_COLLECTION_WITH_PREFIX, excludeCollectionWithPrefix);
        return this;
    }

    public MongoDumpConfigBuilder numParallelCollections(Integer numParallelCollections) {
        this.set(NUM_PARALLEL_COLLECTIONS, numParallelCollections);
        return this;
    }

    public MongoDumpConfigBuilder stopTimeoutInMillis(long timeout) {
        this.stopTimeout().set((Object)timeout);
        return this;
    }

    public IMongoDumpConfig build() {
        Net net = (Net)this.net().get();
        Timeout timeout = (Timeout)this.timeout().get();
        Long stopTimeoutInMillis = (Long)this.get(STOP_TIMEOUT_MILLIS);
        return new ImmutableMongoDumpConfig((IFeatureAwareVersion)this.get(VERSION, null), net, timeout, (Boolean)this.get(VERBOSE, false), (String)this.get(PID_FILE), (String)this.get(DB_NAME, null), (String)this.get(COLLECTION, null), (String)this.get(QUERY, null), (String)this.get(QUERY_FILE, null), (String)this.get(READ_PREFERENCE, null), (Boolean)this.get(FORCE_TABLE_SCAN, false), (String)this.get(ARCHIVE, null), (Boolean)this.get(DUMP_DB_USERS_ROLES, false), (String)this.get(OUT, null), (Boolean)this.get(GZIP, false), (Boolean)this.get(REPAIR, false), (Boolean)this.get(OPLOG, null), (String)this.get(EXCLUDE_COLLECTION, null), (String)this.get(EXCLUDE_COLLECTION_WITH_PREFIX, null), (Integer)this.get(NUM_PARALLEL_COLLECTIONS, 4), stopTimeoutInMillis);
    }

    static class ImmutableMongoDumpConfig
    extends AbstractMongoConfigBuilder.ImmutableMongoConfig
    implements IMongoDumpConfig {
        private final boolean _verbose;
        private final String _databaseName;
        private final String _collectionName;
        private final String _query;
        private final String _queryFile;
        private final String _readPreference;
        private final boolean _forceTableScan;
        private final String _archive;
        private final boolean _dumpDbUsersRoles;
        private final String _out;
        private final boolean _gzip;
        private final boolean _repair;
        private final boolean _oplog;
        private final String _excludeCollection;
        private final String _excludeCollectionWithPrefix;
        private final Integer _numParallelCollections;

        public ImmutableMongoDumpConfig(IFeatureAwareVersion version, Net net, Timeout timeout, boolean verbose, String pidFile, String database, String collection, String query, String queryFile, String readPreference, boolean forceTableScan, String archive, boolean dumpDbUsersAndRoles, String out, boolean gzip, boolean repair, boolean oplog, String excludeCollection, String excludeCollectionWithPrefix, Integer numParallelCollections, long stopTimeoutInMillis) {
            super(new SupportConfig(Command.MongoRestore, stopTimeoutInMillis), version, net, null, null, timeout, null, pidFile);
            this._verbose = verbose;
            this._databaseName = database;
            this._collectionName = collection;
            this._query = query;
            this._queryFile = queryFile;
            this._readPreference = readPreference;
            this._forceTableScan = forceTableScan;
            this._archive = archive;
            this._dumpDbUsersRoles = dumpDbUsersAndRoles;
            this._out = out;
            this._gzip = gzip;
            this._repair = repair;
            this._oplog = oplog;
            this._excludeCollection = excludeCollection;
            this._excludeCollectionWithPrefix = excludeCollectionWithPrefix;
            this._numParallelCollections = numParallelCollections;
        }

        @Override
        public boolean isVerbose() {
            return this._verbose;
        }

        @Override
        public String getDatabaseName() {
            return this._databaseName;
        }

        @Override
        public String getCollectionName() {
            return this._collectionName;
        }

        @Override
        public String getQuery() {
            return this._query;
        }

        @Override
        public String getQueryFile() {
            return this._queryFile;
        }

        @Override
        public String getReadPreference() {
            return this._readPreference;
        }

        @Override
        public boolean isForceTableScan() {
            return this._forceTableScan;
        }

        @Override
        public String getArchive() {
            return this._archive;
        }

        @Override
        public boolean isDumpDbUsersAndRoles() {
            return this._dumpDbUsersRoles;
        }

        @Override
        public String getOut() {
            return this._out;
        }

        @Override
        public Integer getNumberOfParallelCollections() {
            return this._numParallelCollections;
        }

        @Override
        public boolean isGzip() {
            return this._gzip;
        }

        @Override
        public boolean isRepair() {
            return this._repair;
        }

        @Override
        public boolean isOplog() {
            return this._oplog;
        }

        @Override
        public String getExcludeCollection() {
            return this._excludeCollection;
        }

        @Override
        public String getExcludeCollectionWithPrefix() {
            return this._excludeCollectionWithPrefix;
        }
    }
}

