/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.maven.profiler;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import fr.jcgay.maven.profiler.ArtifactProfiled;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Statistics {
    private static final Logger LOGGER = LoggerFactory.getLogger(Statistics.class);
    private final Map<MavenProject, Stopwatch> projects = new LinkedHashMap<MavenProject, Stopwatch>();
    private final Map<MavenProject, Map<MojoExecution, Stopwatch>> executions = new LinkedHashMap<MavenProject, Map<MojoExecution, Stopwatch>>();
    private final Map<Artifact, Stopwatch> downloadTimers = new LinkedHashMap<Artifact, Stopwatch>();
    private MavenProject topProject;
    private Set<String> goals = Collections.emptySet();
    private Properties properties = new Properties();

    public Statistics setTopProject(MavenProject topProject) {
        this.topProject = topProject;
        return this;
    }

    public MavenProject topProject() {
        return this.topProject;
    }

    public Statistics setGoals(Set<String> goals) {
        this.goals = goals;
        return this;
    }

    public Iterable<String> goals() {
        return this.goals;
    }

    public Statistics setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public Properties properties() {
        return this.properties;
    }

    public Map<MavenProject, Stopwatch> projects() {
        return Collections.unmodifiableMap(this.projects);
    }

    public Table<MavenProject, MojoExecution, Stopwatch> executions() {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        for (Map.Entry<MavenProject, Map<MojoExecution, Stopwatch>> byProject : this.executions.entrySet()) {
            for (Map.Entry<MojoExecution, Stopwatch> executionTimer : byProject.getValue().entrySet()) {
                builder.put((Object)byProject.getKey(), (Object)executionTimer.getKey(), (Object)executionTimer.getValue());
            }
        }
        return builder.build();
    }

    public Map<Artifact, Stopwatch> downloads() {
        return Collections.unmodifiableMap(this.downloadTimers);
    }

    public synchronized Statistics startProject(MavenProject project) {
        LOGGER.debug("Starting timer for project: " + project);
        this.projects.put(project, new Stopwatch().start());
        return this;
    }

    public synchronized Statistics startDownload(Artifact artifact) {
        LOGGER.debug("Starting timer for artifact [{}]", (Object)artifact);
        this.downloadTimers.put(ArtifactProfiled.of(artifact), new Stopwatch().start());
        return this;
    }

    public synchronized Statistics startExecution(MavenProject project, MojoExecution execution) {
        LOGGER.debug("Starting timer for mojo [{}] in project [{}].", (Object)execution, (Object)project);
        Map<MojoExecution, Stopwatch> projectExecutions = this.executions.get(project);
        if (projectExecutions == null) {
            projectExecutions = new LinkedHashMap<MojoExecution, Stopwatch>();
            this.executions.put(project, projectExecutions);
        }
        projectExecutions.put(execution, new Stopwatch().start());
        return this;
    }

    public Statistics stopDownload(Artifact artifact) {
        LOGGER.debug("Stopping timer for artifact [{}]", (Object)artifact);
        this.downloads().get(ArtifactProfiled.of(artifact)).stop();
        return this;
    }

    public Statistics stopExecution(MavenProject project, MojoExecution execution) {
        LOGGER.debug("Stopping timer for mojo [{}] in project [{}].", (Object)execution, (Object)project);
        Map<MojoExecution, Stopwatch> projectExecutions = this.executions.get(project);
        if (projectExecutions == null) {
            throw new IllegalStateException("Cannot stop a timer execution because project has not been registered");
        }
        Stopwatch stopwatch = projectExecutions.get(execution);
        if (stopwatch == null) {
            throw new IllegalStateException("Cannot stop a timer execution because execution has not been registered");
        }
        stopwatch.stop();
        return this;
    }

    public Statistics stopProject(MavenProject project) {
        LOGGER.debug("Stopping timer for project: " + project);
        this.projects.get(project).stop();
        return this;
    }
}

