/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.errors;

import io.dropwizard.jersey.errors.ErrorMessage;
import java.util.concurrent.ThreadLocalRandom;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LoggingExceptionMapper<E extends Throwable>
implements ExceptionMapper<E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingExceptionMapper.class);

    public Response toResponse(E exception) {
        if (exception instanceof WebApplicationException) {
            return ((WebApplicationException)exception).getResponse();
        }
        long id = ThreadLocalRandom.current().nextLong();
        this.logException(id, exception);
        return Response.serverError().entity((Object)new ErrorMessage(this.formatErrorMessage(id, exception))).build();
    }

    protected String formatErrorMessage(long id, E exception) {
        return String.format("There was an error processing your request. It has been logged (ID %016x).", id);
    }

    protected void logException(long id, E exception) {
        LOGGER.error(this.formatLogMessage(id, (Throwable)exception), exception);
    }

    protected String formatLogMessage(long id, Throwable exception) {
        return String.format("Error handling a request: %016x", id);
    }
}

