/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.filter;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllowedMethodsFilter
implements Filter {
    public static final String ALLOWED_METHODS_PARAM = "allowedMethods";
    public static final Set<String> DEFAULT_ALLOWED_METHODS = ImmutableSet.of((Object)"GET", (Object)"POST", (Object)"PUT", (Object)"DELETE", (Object)"HEAD", (Object)"OPTIONS", (Object[])new String[]{"PATCH"});
    private static final Logger LOG = LoggerFactory.getLogger(AllowedMethodsFilter.class);
    private Set<String> allowedMethods = Sets.newHashSet();

    public void init(FilterConfig config) {
        String allowedMethodsConfig = config.getInitParameter(ALLOWED_METHODS_PARAM);
        if (allowedMethodsConfig == null) {
            this.allowedMethods.addAll(DEFAULT_ALLOWED_METHODS);
        } else {
            this.allowedMethods.addAll(Arrays.asList(allowedMethodsConfig.split(",")));
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.handle((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    private void handle(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.allowedMethods.contains(request.getMethod())) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            LOG.debug("Request with disallowed method {} blocked", (Object)request.getMethod());
            response.sendError(405);
        }
    }

    public void destroy() {
        this.allowedMethods.clear();
    }
}

