/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.artemis.core.runtime;

import io.quarkus.artemis.core.runtime.ArtemisBuildTimeConfig;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@ConfigRoot(name="artemis", phase=ConfigPhase.BUILD_AND_RUN_TIME_FIXED)
public class ArtemisBuildTimeConfigs {
    @ConfigItem(name="<<parent>>")
    public ArtemisBuildTimeConfig defaultConfig = new ArtemisBuildTimeConfig();
    @ConfigItem(name="<<parent>>")
    public Map<String, ArtemisBuildTimeConfig> namedConfigs = new HashMap<String, ArtemisBuildTimeConfig>();
    @ConfigItem(name="health.enabled")
    public Optional<Boolean> healthEnabled = Optional.empty();

    public ArtemisBuildTimeConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    private Map<String, ArtemisBuildTimeConfig> getNamedConfigs() {
        return this.namedConfigs;
    }

    public Map<String, ArtemisBuildTimeConfig> getAllConfigs() {
        HashMap<String, ArtemisBuildTimeConfig> allConfigs = new HashMap<String, ArtemisBuildTimeConfig>(this.getNamedConfigs());
        if (this.getDefaultConfig() != null && !this.getDefaultConfig().isEmpty()) {
            allConfigs.put("<default>", this.getDefaultConfig());
        }
        return allConfigs;
    }

    public boolean isHealthEnabled() {
        return this.healthEnabled.orElse(true);
    }

    public boolean isEmpty() {
        return this.defaultConfig.isEmpty() && this.namedConfigs.isEmpty() && this.healthEnabled.isEmpty();
    }
}

