/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.artemis.core.runtime;

import io.quarkus.artemis.core.runtime.ArtemisRuntimeConfig;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@ConfigGroup
@ConfigRoot(name="artemis", phase=ConfigPhase.RUN_TIME)
public class ArtemisRuntimeConfigs {
    @ConfigItem(name="<<parent>>")
    public ArtemisRuntimeConfig defaultConfig;
    @ConfigItem(name="<<parent>>")
    public Map<String, ArtemisRuntimeConfig> namedConfigs = new HashMap<String, ArtemisRuntimeConfig>();
    @ConfigItem(name="health.external.enabled")
    public Optional<Boolean> healthExternalEnabled = Optional.empty();

    public ArtemisRuntimeConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    private Map<String, ArtemisRuntimeConfig> getNamedConfigs() {
        return this.namedConfigs;
    }

    public boolean getHealthExternalEnabled() {
        return this.healthExternalEnabled.orElse(true);
    }

    public Map<String, ArtemisRuntimeConfig> getAllConfigs() {
        HashMap<String, ArtemisRuntimeConfig> allConfigs = new HashMap<String, ArtemisRuntimeConfig>(this.getNamedConfigs());
        if (this.getDefaultConfig() != null && !this.getDefaultConfig().isEmpty()) {
            allConfigs.put("<default>", this.getDefaultConfig());
        }
        return allConfigs;
    }

    public boolean isEmpty() {
        return this.defaultConfig.isEmpty() && this.namedConfigs.isEmpty() && this.healthExternalEnabled.isEmpty();
    }
}

