/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.transport;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.quarkus.vertx.core.runtime.VertxBufferImpl;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;

public class VertxServletOutputStream
extends ServletOutputStream {
    private final HttpServerRequest request;
    protected HttpServerResponse response;
    private ByteBuf pooledBuffer;
    private long written;
    private boolean committed;
    protected boolean waitingForDrain;
    protected boolean drainHandlerRegistered;
    private boolean closed;
    private boolean finished;
    protected boolean first = true;
    protected Throwable throwable;
    private ByteArrayOutputStream overflow;

    public VertxServletOutputStream(HttpServerRequest request, HttpServerResponse response) {
        this.response = response;
        this.request = request;
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len < 1) {
            return;
        }
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        int rem = len;
        int idx = off;
        ByteBuf buffer = this.pooledBuffer;
        try {
            if (buffer == null) {
                this.pooledBuffer = buffer = PooledByteBufAllocator.DEFAULT.directBuffer();
            }
            while (rem > 0) {
                int toWrite = Math.min(rem, buffer.writableBytes());
                buffer.writeBytes(b, idx, toWrite);
                rem -= toWrite;
                idx += toWrite;
                if (buffer.isWritable()) continue;
                ByteBuf tmpBuf = buffer;
                this.pooledBuffer = buffer = PooledByteBufAllocator.DEFAULT.directBuffer();
                this.writeBlocking(tmpBuf, false);
            }
        }
        catch (IOException | RuntimeException e) {
            if (buffer != null && buffer.refCnt() > 0) {
                buffer.release();
            }
            throw new IOException(e);
        }
        this.updateWritten(len);
    }

    public void writeBlocking(ByteBuf buffer, boolean finished) throws IOException {
        this.prepareWrite(buffer, finished);
        this.write(buffer, finished);
    }

    private void prepareWrite(ByteBuf buffer, boolean finished) throws IOException {
        if (!this.committed) {
            this.committed = true;
            if (finished) {
                if (buffer == null) {
                    this.response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)"0");
                } else {
                    this.response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)("" + buffer.readableBytes()));
                }
            } else if (!this.request.response().headers().contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
                this.request.response().setChunked(true);
            }
        }
        if (finished) {
            this.finished = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ByteBuf data, boolean last) throws IOException {
        if (last && data == null) {
            this.request.response().end();
            return;
        }
        HttpConnection httpConnection = this.request.connection();
        synchronized (httpConnection) {
            try {
                boolean bufferRequired;
                boolean bl = bufferRequired = this.awaitWriteable() || this.overflow != null && this.overflow.size() > 0;
                if (bufferRequired) {
                    this.registerDrainHandler();
                    if (this.overflow == null) {
                        this.overflow = new ByteArrayOutputStream();
                    }
                    if (data != null) {
                        this.overflow.write(data.array(), data.arrayOffset() + data.readerIndex(), data.arrayOffset() + data.writerIndex());
                    }
                    if (last) {
                        this.closed = true;
                    }
                } else if (last) {
                    this.request.response().end(this.createBuffer(data));
                } else {
                    this.request.response().write((Object)this.createBuffer(data));
                }
            }
            catch (IOException | RuntimeException e) {
                if (data != null && data.refCnt() > 0) {
                    data.release();
                }
                throw new IOException("Failed to write", e);
            }
        }
    }

    private boolean awaitWriteable() throws IOException {
        if (Context.isOnEventLoopThread()) {
            return this.request.response().writeQueueFull();
        }
        if (this.first) {
            this.first = false;
            return false;
        }
        assert (Thread.holdsLock(this.request.connection()));
        while (this.request.response().writeQueueFull()) {
            if (this.throwable != null) {
                throw new IOException(this.throwable);
            }
            if (this.request.response().closed()) {
                throw new IOException("Connection has been closed");
            }
            this.registerDrainHandler();
            try {
                this.waitingForDrain = true;
                this.request.connection().wait();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.getMessage());
            }
            finally {
                this.waitingForDrain = false;
            }
        }
        return false;
    }

    private void registerDrainHandler() {
        if (!this.drainHandlerRegistered) {
            this.drainHandlerRegistered = true;
            Handler handler = event -> {
                HttpConnection connection;
                HttpConnection httpConnection = connection = this.request.connection();
                synchronized (httpConnection) {
                    if (this.waitingForDrain) {
                        connection.notifyAll();
                    }
                    if (this.overflow != null && this.overflow.size() > 0) {
                        if (this.closed) {
                            this.request.response().end(Buffer.buffer((byte[])this.overflow.toByteArray()));
                        } else {
                            this.request.response().write((Object)Buffer.buffer((byte[])this.overflow.toByteArray()));
                        }
                        this.overflow.reset();
                    }
                }
            };
            this.request.response().drainHandler(handler);
            this.request.response().closeHandler(handler);
        }
    }

    Buffer createBuffer(ByteBuf data) {
        return new VertxBufferImpl(data);
    }

    void updateWritten(long len) throws IOException {
        this.written += len;
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (this.pooledBuffer != null) {
            try {
                this.writeBlocking(this.pooledBuffer, false);
                this.pooledBuffer = null;
            }
            catch (IOException | RuntimeException e) {
                this.pooledBuffer.release();
                this.pooledBuffer = null;
                throw new IOException(e);
            }
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.writeBlocking(this.pooledBuffer, true);
        }
        catch (IOException | RuntimeException e) {
            throw new IOException(e);
        }
        finally {
            this.closed = true;
            this.pooledBuffer = null;
        }
    }

    public boolean isReady() {
        throw new UnsupportedOperationException();
    }

    public void setWriteListener(WriteListener writeListener) {
        throw new UnsupportedOperationException();
    }
}

