/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.xmlsec.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageSecurityProviderBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeReinitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.util.ServiceUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Stream;
import javax.crypto.spec.GCMParameterSpec;
import javax.xml.crypto.dsig.spec.XPathType;
import javax.xml.validation.SchemaFactory;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.apache.xml.security.algorithms.SignatureAlgorithmSpi;
import org.apache.xml.security.c14n.CanonicalizerSpi;
import org.apache.xml.security.stax.ext.ResourceResolverLookup;
import org.apache.xml.security.stax.ext.Transformer;
import org.apache.xml.security.stax.ext.XMLSec;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.apache.xml.security.stax.securityToken.SecurityTokenFactory;
import org.apache.xml.security.transforms.TransformSpi;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class XmlsecProcessor {
    private static final String FEATURE = "xmlsec";

    XmlsecProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    IndexDependencyBuildItem indexDependencies() {
        return new IndexDependencyBuildItem("org.apache.santuario", FEATURE);
    }

    @BuildStep
    void registerForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CombinedIndexBuildItem combinedIndex) {
        IndexView index = combinedIndex.getIndex();
        Stream.of(SignatureAlgorithmSpi.class.getName(), CanonicalizerSpi.class.getName(), TransformSpi.class.getName(), SecurityTokenFactory.class.getName()).flatMap(className -> index.getAllKnownSubclasses(DotName.createSimple((String)className)).stream()).map(classInfo -> classInfo.name().toString()).map(className -> new ReflectiveClassBuildItem(false, false, new String[]{className})).forEach(arg_0 -> reflectiveClass.produce(arg_0));
        Stream.of(ResourceResolverLookup.class.getName(), Transformer.class.getName()).flatMap(className -> index.getAllKnownImplementors(DotName.createSimple((String)className)).stream()).map(classInfo -> classInfo.name().toString()).map(className -> new ReflectiveClassBuildItem(false, false, new String[]{className})).forEach(arg_0 -> reflectiveClass.produce(arg_0));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{GCMParameterSpec.class.getName(), XPathType[].class.getName()}));
    }

    @BuildStep
    void runtimeReinitializedClasses(BuildProducer<RuntimeReinitializedClassBuildItem> runtimeReinitializedClasses) {
        runtimeReinitializedClasses.produce((BuildItem)new RuntimeReinitializedClassBuildItem(XMLSec.class.getName()));
        runtimeReinitializedClasses.produce((BuildItem)new RuntimeReinitializedClassBuildItem(XMLSecurityConstants.class.getName()));
    }

    @BuildStep
    void runtimeInitializedClass(BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClass) {
        runtimeInitializedClass.produce((BuildItem)new RuntimeInitializedClassBuildItem("org.apache.xml.security.stax.impl.InboundSecurityContextImpl"));
    }

    @BuildStep
    void nativeImageResources(BuildProducer<NativeImageResourceBuildItem> nativeImageResources) {
        Stream.of("bindings/bindings.cat", "bindings/c14n.xjb", "bindings/dsig.xjb", "bindings/dsig11.xjb", "bindings/rsa-pss.xjb", "bindings/security-config.xjb", "bindings/xenc.xjb", "bindings/xenc11.xjb", "bindings/xop.xjb", "bindings/schemas/datatypes.dtd", "bindings/schemas/exc-c14n.xsd", "bindings/schemas/rsa-pss.xsd", "bindings/schemas/xenc-schema.xsd", "bindings/schemas/xenc-schema-11.xsd", "bindings/schemas/xml.xsd", "bindings/schemas/xmldsig11-schema.xsd", "bindings/schemas/xmldsig-core-schema.xsd", "bindings/schemas/XMLSchema.dtd", "bindings/schemas/xop-include.xsd", "schemas/security-config.xsd", "security-config.xml").map(xva$0 -> new NativeImageResourceBuildItem(new String[]{xva$0})).forEach(arg_0 -> nativeImageResources.produce(arg_0));
    }

    @BuildStep
    NativeImageSecurityProviderBuildItem saslSecurityProvider() {
        return new NativeImageSecurityProviderBuildItem(XMLDSigRI.class.getName());
    }

    @BuildStep
    void resourceBundle(BuildProducer<NativeImageResourceBundleBuildItem> resourceBundle) {
        resourceBundle.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.apache.xml.security.resource.xmlsecurity"));
    }

    @BuildStep
    void serviceProviders(BuildProducer<ServiceProviderBuildItem> serviceProviders) {
        Stream.of(SchemaFactory.class).map(Class::getName).forEach(serviceName -> {
            try {
                Set names = ServiceUtil.classNamesNamedIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)("META-INF/services/" + serviceName));
                serviceProviders.produce((BuildItem)new ServiceProviderBuildItem(serviceName, new ArrayList(names)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

