/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;
import java.util.List;

public class ResponseHeaderAttribute
implements ExchangeAttribute {
    private final String responseHeader;

    @Deprecated
    public ResponseHeaderAttribute(HttpString responseHeader) {
        this.responseHeader = responseHeader.toString();
    }

    public ResponseHeaderAttribute(String responseHeader) {
        this.responseHeader = responseHeader;
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        List<String> header = exchange.getResponseHeaders(this.responseHeader);
        if (header.isEmpty()) {
            return null;
        }
        if (header.size() == 1) {
            return header.get(0);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < header.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(header.get(i));
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        if (newValue == null) {
            exchange.removeResponseHeader(this.responseHeader);
        } else {
            exchange.setResponseHeader(this.responseHeader, newValue);
        }
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Response header";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.startsWith("%{o,") && token.endsWith("}")) {
                String headerName = token.substring(4, token.length() - 1);
                return new ResponseHeaderAttribute(headerName);
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

