/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.server.handlers.form.FormEncodedDataDefinition;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.server.handlers.form.MultiPartParserDefinition;
import io.undertow.servlet.UndertowServletLogger;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.LifecycleInterceptor;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.core.Lifecycle;
import io.undertow.servlet.core.LifecyleInterceptorInvocation;
import io.undertow.servlet.spec.ServletConfigImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;

public class ManagedServlet
implements Lifecycle {
    private final ServletInfo servletInfo;
    private final ServletContextImpl servletContext;
    private volatile boolean started = false;
    private final InstanceStrategy instanceStrategy;
    private volatile boolean permanentlyUnavailable = false;
    private long maxRequestSize;
    private MultipartConfigElement multipartConfig;
    private static final AtomicLongFieldUpdater<ManagedServlet> unavailableUntilUpdater = AtomicLongFieldUpdater.newUpdater(ManagedServlet.class, "unavailableUntil");
    private volatile long unavailableUntil = 0L;
    private FormParserFactory formParserFactory;

    public ManagedServlet(ServletInfo servletInfo, ServletContextImpl servletContext) {
        this.servletInfo = servletInfo;
        this.servletContext = servletContext;
        this.instanceStrategy = SingleThreadModel.class.isAssignableFrom(servletInfo.getServletClass()) ? new SingleThreadModelPoolStrategy(servletInfo.getInstanceFactory(), servletInfo, servletContext) : new DefaultInstanceStrategy(servletInfo.getInstanceFactory(), servletInfo, servletContext);
        this.setupMultipart(servletContext);
    }

    public void setupMultipart(ServletContextImpl servletContext) {
        FormEncodedDataDefinition formDataParser = new FormEncodedDataDefinition().setDefaultEncoding(servletContext.getDeployment().getDefaultRequestCharset().name());
        MultipartConfigElement multipartConfig = this.servletInfo.getMultipartConfig();
        if (multipartConfig == null) {
            multipartConfig = servletContext.getDeployment().getDeploymentInfo().getDefaultMultipartConfig();
        }
        this.multipartConfig = multipartConfig;
        if (multipartConfig != null) {
            String location;
            Path locFile;
            MultipartConfigElement config = multipartConfig;
            this.maxRequestSize = config.getMaxRequestSize() != -1L ? config.getMaxRequestSize() : -1L;
            Path tempDir = config.getLocation() == null || config.getLocation().isEmpty() ? servletContext.getDeployment().getDeploymentInfo().getTempPath() : ((locFile = Paths.get(location = config.getLocation(), new String[0])).isAbsolute() ? locFile : servletContext.getDeployment().getDeploymentInfo().getTempPath().resolve(location));
            MultiPartParserDefinition multiPartParserDefinition = new MultiPartParserDefinition(tempDir);
            if (config.getMaxFileSize() > 0L) {
                multiPartParserDefinition.setMaxIndividualFileSize(config.getMaxFileSize());
            }
            if (config.getFileSizeThreshold() > 0) {
                multiPartParserDefinition.setFileSizeThreshold((long)config.getFileSizeThreshold());
            }
            multiPartParserDefinition.setDefaultEncoding(servletContext.getDeployment().getDefaultRequestCharset().name());
            this.formParserFactory = FormParserFactory.builder((boolean)false).addParser((FormParserFactory.ParserDefinition)formDataParser).addParser((FormParserFactory.ParserDefinition)multiPartParserDefinition).build();
        } else {
            this.formParserFactory = FormParserFactory.builder((boolean)false).addParser((FormParserFactory.ParserDefinition)formDataParser).build();
            this.maxRequestSize = -1L;
        }
    }

    public FormParserFactory getFormParserFactory() {
        return this.formParserFactory;
    }

    @Override
    public synchronized void start() throws ServletException {
    }

    public void createServlet() throws ServletException {
        block4: {
            if (this.permanentlyUnavailable) {
                return;
            }
            try {
                if (!this.started && this.servletInfo.getLoadOnStartup() != null && this.servletInfo.getLoadOnStartup() >= 0) {
                    this.instanceStrategy.start();
                    this.started = true;
                }
            }
            catch (UnavailableException e) {
                if (!e.isPermanent()) break block4;
                this.permanentlyUnavailable = true;
                this.stop();
            }
        }
    }

    @Override
    public synchronized void stop() {
        if (this.started) {
            this.instanceStrategy.stop();
        }
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    public boolean isPermanentlyUnavailable() {
        return this.permanentlyUnavailable;
    }

    public boolean isTemporarilyUnavailable() {
        long until = this.unavailableUntil;
        if (until != 0L) {
            if (System.currentTimeMillis() < until) {
                return true;
            }
            unavailableUntilUpdater.compareAndSet(this, until, 0L);
        }
        return false;
    }

    public void setPermanentlyUnavailable(boolean permanentlyUnavailable) {
        this.permanentlyUnavailable = permanentlyUnavailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstanceHandle<? extends Servlet> getServlet() throws ServletException {
        if (this.servletContext.getDeployment().getDeploymentState() != DeploymentManager.State.STARTED) {
            throw UndertowServletMessages.MESSAGES.deploymentStopped(this.servletContext.getDeployment().getDeploymentInfo().getDeploymentName());
        }
        if (!this.started) {
            ManagedServlet managedServlet = this;
            synchronized (managedServlet) {
                if (!this.started) {
                    this.instanceStrategy.start();
                    this.started = true;
                }
            }
        }
        return this.instanceStrategy.getServlet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceInit() throws ServletException {
        if (!this.started) {
            if (this.servletContext.getDeployment().getDeploymentState() != DeploymentManager.State.STARTED) {
                throw UndertowServletMessages.MESSAGES.deploymentStopped(this.servletContext.getDeployment().getDeploymentInfo().getDeploymentName());
            }
            ManagedServlet managedServlet = this;
            synchronized (managedServlet) {
                if (!this.started) {
                    try {
                        this.instanceStrategy.start();
                    }
                    catch (UnavailableException e) {
                        this.handleUnavailableException(e);
                    }
                    this.started = true;
                }
            }
        }
    }

    public void handleUnavailableException(UnavailableException e) {
        if (e.isPermanent()) {
            UndertowServletLogger.REQUEST_LOGGER.stoppingServletDueToPermanentUnavailability(this.getServletInfo().getName(), e);
            this.stop();
            this.setPermanentlyUnavailable(true);
        } else {
            long until = System.currentTimeMillis() + (long)(e.getUnavailableSeconds() * 1000);
            unavailableUntilUpdater.set(this, until);
            UndertowServletLogger.REQUEST_LOGGER.stoppingServletUntilDueToTemporaryUnavailability(this.getServletInfo().getName(), new Date(until), e);
        }
    }

    public ServletInfo getServletInfo() {
        return this.servletInfo;
    }

    public long getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public MultipartConfigElement getMultipartConfig() {
        return this.multipartConfig;
    }

    public String toString() {
        return "ManagedServlet{servletInfo=" + this.servletInfo + '}';
    }

    private static class SingleThreadModelPoolStrategy
    implements InstanceStrategy {
        private final InstanceFactory<? extends Servlet> factory;
        private final ServletInfo servletInfo;
        private final ServletContextImpl servletContext;

        private SingleThreadModelPoolStrategy(InstanceFactory<? extends Servlet> factory, ServletInfo servletInfo, ServletContextImpl servletContext) {
            this.factory = factory;
            this.servletInfo = servletInfo;
            this.servletContext = servletContext;
        }

        @Override
        public void start() throws ServletException {
            if (this.servletInfo.getLoadOnStartup() != null) {
                this.getServlet().release();
            }
        }

        @Override
        public void stop() {
        }

        @Override
        public InstanceHandle<? extends Servlet> getServlet() throws ServletException {
            InstanceHandle<? extends Servlet> instanceHandle;
            try {
                instanceHandle = this.factory.createInstance();
            }
            catch (Exception e) {
                throw UndertowServletMessages.MESSAGES.couldNotInstantiateComponent(this.servletInfo.getName(), e);
            }
            final Servlet instance = instanceHandle.getInstance();
            new LifecyleInterceptorInvocation(this.servletContext.getDeployment().getDeploymentInfo().getLifecycleInterceptors(), this.servletInfo, instance, new ServletConfigImpl(this.servletInfo, this.servletContext)).proceed();
            return new InstanceHandle<Servlet>(){

                @Override
                public Servlet getInstance() {
                    return instance;
                }

                @Override
                public void release() {
                    try {
                        instance.destroy();
                    }
                    catch (Throwable t) {
                        UndertowServletLogger.REQUEST_LOGGER.failedToDestroy(instance, t);
                    }
                    instanceHandle.release();
                }
            };
        }
    }

    static interface InstanceStrategy {
        public void start() throws ServletException;

        public void stop();

        public InstanceHandle<? extends Servlet> getServlet() throws ServletException;
    }

    private static class DefaultInstanceStrategy
    implements InstanceStrategy {
        private final InstanceFactory<? extends Servlet> factory;
        private final ServletInfo servletInfo;
        private final ServletContextImpl servletContext;
        private volatile InstanceHandle<? extends Servlet> handle;
        private volatile Servlet instance;
        private final InstanceHandle<Servlet> instanceHandle = new InstanceHandle<Servlet>(){

            @Override
            public Servlet getInstance() {
                return instance;
            }

            @Override
            public void release() {
            }
        };

        DefaultInstanceStrategy(InstanceFactory<? extends Servlet> factory, ServletInfo servletInfo, ServletContextImpl servletContext) {
            this.factory = factory;
            this.servletInfo = servletInfo;
            this.servletContext = servletContext;
        }

        @Override
        public synchronized void start() throws ServletException {
            try {
                this.handle = this.factory.createInstance();
            }
            catch (Exception e) {
                throw UndertowServletMessages.MESSAGES.couldNotInstantiateComponent(this.servletInfo.getName(), e);
            }
            this.instance = this.handle.getInstance();
            new LifecyleInterceptorInvocation(this.servletContext.getDeployment().getDeploymentInfo().getLifecycleInterceptors(), this.servletInfo, this.instance, new ServletConfigImpl(this.servletInfo, this.servletContext)).proceed();
        }

        @Override
        public synchronized void stop() {
            if (this.handle != null) {
                this.invokeDestroy();
                this.handle.release();
            }
        }

        private void invokeDestroy() {
            List<LifecycleInterceptor> interceptors = this.servletContext.getDeployment().getDeploymentInfo().getLifecycleInterceptors();
            try {
                new LifecyleInterceptorInvocation(interceptors, this.servletInfo, this.instance).proceed();
            }
            catch (Exception e) {
                UndertowServletLogger.ROOT_LOGGER.failedToDestroy(this.servletInfo, e);
            }
        }

        @Override
        public InstanceHandle<? extends Servlet> getServlet() {
            return this.instanceHandle;
        }
    }
}

