/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets;

import io.undertow.websockets.util.ObjectFactory;
import io.undertow.websockets.util.ObjectHandle;
import jakarta.websocket.Extension;
import jakarta.websocket.HandshakeResponse;
import jakarta.websocket.server.HandshakeRequest;
import jakarta.websocket.server.ServerEndpointConfig;
import java.util.ArrayList;
import java.util.List;

public class DefaultContainerConfigurator
extends ServerEndpointConfig.Configurator {
    public static final DefaultContainerConfigurator INSTANCE = new DefaultContainerConfigurator();
    private static final ThreadLocal<ObjectFactory<?>> currentInstanceFactory = new ThreadLocal();
    private static final ThreadLocal<ObjectHandle<?>> currentInstanceHandle = new ThreadLocal();

    public String getNegotiatedSubprotocol(List<String> supported, List<String> requested) {
        for (String proto : requested) {
            if (!supported.contains(proto)) continue;
            return proto;
        }
        return "";
    }

    public List<Extension> getNegotiatedExtensions(List<Extension> installed, List<Extension> requested) {
        ArrayList<Extension> ret = new ArrayList<Extension>();
        block0: for (Extension req : requested) {
            for (Extension extension : installed) {
                if (!extension.getName().equals(req.getName())) continue;
                ret.add(req);
                continue block0;
            }
        }
        return ret;
    }

    public boolean checkOrigin(String originHeaderValue) {
        return true;
    }

    public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
    }

    public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
        ObjectFactory<?> factory = currentInstanceFactory.get();
        if (factory != null) {
            ObjectHandle<?> instance = factory.createInstance();
            currentInstanceHandle.set(instance);
            return (T)instance.getInstance();
        }
        try {
            return endpointClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static void setCurrentInstanceFactory(ObjectFactory<?> factory) {
        currentInstanceFactory.set(factory);
    }

    static ObjectHandle<?> clearCurrentInstanceFactory() {
        currentInstanceFactory.remove();
        ObjectHandle<?> handle = currentInstanceHandle.get();
        currentInstanceHandle.remove();
        return handle;
    }
}

