/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.datasource.common.runtime.DatabaseKind;
import io.quarkus.hibernate.orm.deployment.HibernateOrmConfig;
import io.quarkus.hibernate.orm.deployment.spi.DatabaseKindDialectBuildItem;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.util.List;

public final class Dialects {
    private Dialects() {
    }

    public static String guessDialect(String persistenceUnitName, String resolvedDbKind, List<DatabaseKindDialectBuildItem> dbKindDialectBuildItems) {
        for (DatabaseKindDialectBuildItem item : dbKindDialectBuildItems) {
            if (!DatabaseKind.is((String)resolvedDbKind, (String)item.getDbKind())) continue;
            return item.getDialect();
        }
        String error = "The Hibernate ORM extension could not guess the dialect from the database kind '" + resolvedDbKind + "'. Add an explicit '" + HibernateOrmConfig.puPropertyKey(persistenceUnitName, "dialect") + "' property.";
        throw new ConfigurationException(error);
    }
}

