/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.uni.UniOperatorProcessor;
import io.smallrye.mutiny.subscription.Cancellable;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.tuples.Functions;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public class UniOnTerminationCall<I>
extends UniOperator<I, I> {
    private final Functions.Function3<? super I, Throwable, Boolean, Uni<?>> mapper;

    public UniOnTerminationCall(Uni<I> upstream, Functions.Function3<? super I, Throwable, Boolean, Uni<?>> mapper) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.mapper = ParameterValidation.nonNull(mapper, "mapper");
    }

    @Override
    public void subscribe(UniSubscriber<? super I> subscriber) {
        this.upstream().subscribe().withSubscriber(new UniOnTerminationCallProcessor(subscriber));
    }

    private class UniOnTerminationCallProcessor
    extends UniOperatorProcessor<I, I> {
        private volatile Cancellable cancellable;
        private final AtomicBoolean invoked;

        public UniOnTerminationCallProcessor(UniSubscriber<? super I> downstream) {
            super(downstream);
            this.invoked = new AtomicBoolean();
        }

        @Override
        public void cancel() {
            if (!this.isCancelled()) {
                if (this.cancellable != null) {
                    this.cancellable.cancel();
                    super.cancel();
                } else {
                    this.execute(null, null, true).subscribe().with(ignored -> super.cancel(), failure -> {
                        Infrastructure.handleDroppedException(failure);
                        super.cancel();
                    });
                }
            }
        }

        @Override
        public void onItem(I item) {
            if (!this.isCancelled()) {
                this.cancellable = this.execute(item, null, false).subscribe().with(ignored -> this.downstream.onItem(item), this.downstream::onFailure);
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            if (!this.isCancelled()) {
                this.cancellable = this.execute(null, failure, false).subscribe().with(ignored -> this.downstream.onFailure(failure), ignored -> this.downstream.onFailure(new CompositeException(failure, (Throwable)ignored)));
            } else {
                Infrastructure.handleDroppedException(failure);
            }
        }

        private Uni<?> execute(I item, Throwable failure, Boolean cancelled) {
            if (this.invoked.compareAndSet(false, true)) {
                try {
                    return Objects.requireNonNull((Uni)UniOnTerminationCall.this.mapper.apply(item, failure, cancelled), "Uni should not be null");
                }
                catch (Throwable err) {
                    return Uni.createFrom().failure(err);
                }
            }
            return Uni.createFrom().nullItem();
        }
    }
}

