package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.CircuitBreakerName;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.annotation.Annotation;

/**
 * Automatically generated from the {@link CircuitBreakerNameConfig} config interface, do not modify.
 */
public final class CircuitBreakerNameConfigImpl implements CircuitBreakerNameConfig {
    private final Class<?> beanClass;

    private final MethodDescriptor method;

    /**
     * Backing annotation instance.
     */
    private final CircuitBreakerName instance;

    /**
     * {@code true} if annotation was placed on a method; {@code false} if annotation was placed on a class.
     */
    private final boolean onMethod;

    private CircuitBreakerNameConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.circuitBreakerName;
        this.onMethod = method.annotationsPresentDirectly.contains(CircuitBreakerName.class);
    }

    public static CircuitBreakerNameConfigImpl create(FaultToleranceMethod method) {
        if (method.circuitBreakerName == null) {
            return null;
        }
        return new CircuitBreakerNameConfigImpl(method);
    }

    @Override
    public Class<?> beanClass() {
        return beanClass;
    }

    @Override
    public MethodDescriptor method() {
        return method;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return CircuitBreakerName.class;
    }

    @Override
    public boolean isOnMethod() {
        return onMethod;
    }

    @Override
    public String value() {
        return instance.value();
    }

    @Override
    public void materialize() {
        value();
    }
}
