/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.util.Yaml;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlaskConnexionCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlaskConnexionCodegen.class);
    public static final String CONTROLLER_PACKAGE = "controllerPackage";
    public static final String DEFAULT_CONTROLLER = "defaultController";
    protected String apiVersion = "1.0.0";
    protected int serverPort = 8080;
    protected String projectName = "swagger-server";
    protected String controllerPackage;
    protected String defaultController;

    public FlaskConnexionCodegen() {
        this.languageSpecificPrimitives.clear();
        this.languageSpecificPrimitives.add("int");
        this.languageSpecificPrimitives.add("float");
        this.languageSpecificPrimitives.add("list");
        this.languageSpecificPrimitives.add("bool");
        this.languageSpecificPrimitives.add("str");
        this.languageSpecificPrimitives.add("datetime");
        this.languageSpecificPrimitives.add("date");
        this.typeMapping.clear();
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("number", "float");
        this.typeMapping.put("long", "int");
        this.typeMapping.put("double", "float");
        this.typeMapping.put("array", "list");
        this.typeMapping.put("map", "dict");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("string", "str");
        this.typeMapping.put("date", "date");
        this.typeMapping.put("DateTime", "datetime");
        this.typeMapping.put("object", "object");
        this.typeMapping.put("file", "file");
        this.outputFolder = "generated-code/connexion";
        this.modelTemplateFiles.clear();
        this.apiTemplateFiles.clear();
        this.templateDir = "flaskConnexion";
        this.embeddedTemplateDir = "flaskConnexion";
        this.setReservedWordsLowerCase(Arrays.asList("and", "del", "from", "not", "while", "as", "elif", "global", "or", "with", "assert", "else", "if", "pass", "yield", "break", "except", "import", "print", "class", "exec", "in", "raise", "continue", "finally", "is", "return", "def", "for", "lambda", "try"));
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.additionalProperties.put("serverPort", this.serverPort);
        this.supportingFiles.add(new SupportingFile("swagger.mustache", "swagger", "swagger.yaml"));
        this.supportingFiles.add(new SupportingFile("app.mustache", "", "app.py"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.cliOptions.add(new CliOption(CONTROLLER_PACKAGE, "controller package").defaultValue("controllers"));
        this.cliOptions.add(new CliOption(DEFAULT_CONTROLLER, "default controller").defaultValue("default_controller"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.apiTemplateFiles.clear();
        if (this.additionalProperties.containsKey(CONTROLLER_PACKAGE)) {
            this.controllerPackage = this.additionalProperties.get(CONTROLLER_PACKAGE).toString();
        } else {
            this.controllerPackage = "controllers";
            this.additionalProperties.put(CONTROLLER_PACKAGE, this.controllerPackage);
        }
        if (this.additionalProperties.containsKey(DEFAULT_CONTROLLER)) {
            this.defaultController = this.additionalProperties.get(DEFAULT_CONTROLLER).toString();
        } else {
            this.defaultController = "default_controller";
            this.additionalProperties.put(DEFAULT_CONTROLLER, this.defaultController);
        }
        if (!new File(this.controllerPackage + File.separator + this.defaultController + ".py").exists()) {
            this.supportingFiles.add(new SupportingFile("controller.mustache", this.controllerPackage, this.defaultController + ".py"));
        }
    }

    @Override
    public String apiPackage() {
        return this.controllerPackage;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "python-flask";
    }

    @Override
    public String getHelp() {
        return "Generates a Python server library using the Connexion project. By default, it will also generate service classes -- which you can disable with the `-Dnoservice` environment variable.";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultController";
        }
        return this.initialCaps(name);
    }

    @Override
    public String toApiFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public void preprocessSwagger(Swagger swagger) {
        if (swagger != null && swagger.getPaths() != null) {
            for (String pathname : swagger.getPaths().keySet()) {
                Path path = swagger.getPath(pathname);
                if (path.getOperations() == null) continue;
                for (Map.Entry entry : path.getOperationMap().entrySet()) {
                    String httpMethod = ((HttpMethod)entry.getKey()).name().toLowerCase();
                    Operation operation = (Operation)entry.getValue();
                    String operationId = this.getOrGenerateOperationId(operation, pathname, httpMethod);
                    if (!operationId.contains(".")) {
                        operationId = FlaskConnexionCodegen.underscore(this.sanitizeName(operationId));
                        operationId = this.controllerPackage + "." + this.defaultController + "." + operationId;
                    }
                    operation.setOperationId(operationId);
                    if (operation.getTags() != null) {
                        ArrayList tags = new ArrayList();
                        for (String tag : operation.getTags()) {
                            HashMap<String, String> value = new HashMap<String, String>();
                            value.put("tag", tag);
                            value.put("hasMore", "true");
                            tags.add(value);
                        }
                        if (tags.size() > 0) {
                            ((Map)tags.get(tags.size() - 1)).remove("hasMore");
                        }
                        if (operation.getTags().size() > 0) {
                            String tag = (String)operation.getTags().get(0);
                            operation.setTags(Arrays.asList(tag));
                        }
                        operation.setVendorExtension("x-tags", tags);
                        continue;
                    }
                    String tag = "default_controller";
                    operation.setTags(Arrays.asList(tag));
                }
            }
        }
    }

    private static List<Map<String, Object>> getOperations(Map<String, Object> objs) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Map apiInfo = (Map)objs.get("apiInfo");
        List apis = (List)apiInfo.get("apis");
        for (Map api : apis) {
            result.add((Map)api.get("operations"));
        }
        return result;
    }

    private static List<Map<String, Object>> sortOperationsByPath(List<CodegenOperation> ops) {
        ArrayListMultimap opsByPath = ArrayListMultimap.create();
        for (CodegenOperation op : ops) {
            opsByPath.put((Object)op.path, (Object)op);
        }
        ArrayList<Map<String, Object>> opsByPathList = new ArrayList<Map<String, Object>>();
        for (Map.Entry entry : opsByPath.asMap().entrySet()) {
            HashMap<String, Object> opsByPathEntry = new HashMap<String, Object>();
            opsByPathList.add(opsByPathEntry);
            opsByPathEntry.put("path", entry.getKey());
            opsByPathEntry.put("operation", entry.getValue());
            ArrayList operationsForThisPath = Lists.newArrayList((Iterable)((Iterable)entry.getValue()));
            ((CodegenOperation)operationsForThisPath.get((int)(operationsForThisPath.size() - 1))).hasMore = null;
            if (opsByPathList.size() >= opsByPath.asMap().size()) continue;
            opsByPathEntry.put("hasMore", "true");
        }
        return opsByPathList;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        Swagger swagger = (Swagger)objs.get("swagger");
        if (swagger != null) {
            try {
                objs.put("swagger-yaml", Yaml.mapper().writeValueAsString((Object)swagger));
            }
            catch (JsonProcessingException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        for (Map<String, Object> operations : FlaskConnexionCodegen.getOperations(objs)) {
            List ops = (List)operations.get("operation");
            List<Map<String, Object>> opsByPathList = FlaskConnexionCodegen.sortOperationsByPath(ops);
            operations.put("operationsByPath", opsByPathList);
        }
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    public String toOperationId(String operationId) {
        operationId = super.toOperationId(operationId);
        operationId = operationId.replaceAll(".*\\.", "");
        return FlaskConnexionCodegen.underscore(operationId);
    }
}

