/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Qt5CPPGenerator
extends DefaultCodegen
implements CodegenConfig {
    protected final String PREFIX = "SWG";
    protected Set<String> foundationClasses = new HashSet<String>();
    protected String sourceFolder = "client";
    protected String apiVersion = "1.0.0";
    protected Map<String, String> namespaces = new HashMap<String, String>();
    protected Set<String> systemIncludes = new HashSet<String>();

    public Qt5CPPGenerator() {
        this.outputFolder = "generated-code/qt5cpp";
        this.modelTemplateFiles.put("model-header.mustache", ".h");
        this.modelTemplateFiles.put("model-body.mustache", ".cpp");
        this.apiTemplateFiles.put("api-header.mustache", ".h");
        this.apiTemplateFiles.put("api-body.mustache", ".cpp");
        this.templateDir = "qt5cpp";
        this.embeddedTemplateDir = "qt5cpp";
        this.setReservedWordsLowerCase(Arrays.asList("sample1", "sample2"));
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.additionalProperties().put("prefix", "SWG");
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("bool", "qint32", "qint64", "float", "double"));
        this.supportingFiles.add(new SupportingFile("helpers-header.mustache", this.sourceFolder, "SWGHelpers.h"));
        this.supportingFiles.add(new SupportingFile("helpers-body.mustache", this.sourceFolder, "SWGHelpers.cpp"));
        this.supportingFiles.add(new SupportingFile("HttpRequest.h", this.sourceFolder, "SWGHttpRequest.h"));
        this.supportingFiles.add(new SupportingFile("HttpRequest.cpp", this.sourceFolder, "SWGHttpRequest.cpp"));
        this.supportingFiles.add(new SupportingFile("modelFactory.mustache", this.sourceFolder, "SWGModelFactory.h"));
        this.supportingFiles.add(new SupportingFile("object.mustache", this.sourceFolder, "SWGObject.h"));
        this.typeMapping = new HashMap<String, String>();
        this.typeMapping.put("Date", "QDate");
        this.typeMapping.put("DateTime", "QDateTime");
        this.typeMapping.put("string", "QString");
        this.typeMapping.put("integer", "qint32");
        this.typeMapping.put("long", "qint64");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("array", "QList");
        this.typeMapping.put("map", "QMap");
        this.typeMapping.put("file", "SWGHttpRequestInputFileElement");
        this.typeMapping.put("object", "SWGObject");
        this.typeMapping.put("binary", "QString");
        this.importMapping = new HashMap();
        this.importMapping.put("SWGHttpRequestInputFileElement", "#include \"SWGHttpRequest.h\"");
        this.namespaces = new HashMap<String, String>();
        this.foundationClasses.add("QString");
        this.systemIncludes.add("QString");
        this.systemIncludes.add("QList");
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "qt5cpp";
    }

    @Override
    public String getHelp() {
        return "Generates a qt5 C++ client library.";
    }

    @Override
    public String toModelImport(String name) {
        if (this.namespaces.containsKey(name)) {
            return "using " + this.namespaces.get(name) + ";";
        }
        if (this.systemIncludes.contains(name)) {
            return "#include <" + name + ">";
        }
        return "#include \"" + name + ".h\"";
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String toModelFilename(String name) {
        return "SWG" + this.initialCaps(name);
    }

    @Override
    public String toApiFilename(String name) {
        return "SWG" + this.initialCaps(name) + "Api";
    }

    @Override
    public String getTypeDeclaration(Property p) {
        String swaggerType = this.getSwaggerType(p);
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "<" + this.getTypeDeclaration(inner) + ">*";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "<QString, " + this.getTypeDeclaration(inner) + ">*";
        }
        if (this.foundationClasses.contains(swaggerType)) {
            return swaggerType + "*";
        }
        if (this.languageSpecificPrimitives.contains(swaggerType)) {
            return this.toModelName(swaggerType);
        }
        return swaggerType + "*";
    }

    @Override
    public String toDefaultValue(Property p) {
        if (p instanceof StringProperty) {
            return "new QString(\"\")";
        }
        if (p instanceof BooleanProperty) {
            return "false";
        }
        if (p instanceof DateProperty) {
            return "NULL";
        }
        if (p instanceof DateTimeProperty) {
            return "NULL";
        }
        if (p instanceof DoubleProperty) {
            return "0.0";
        }
        if (p instanceof FloatProperty) {
            return "0.0f";
        }
        if (p instanceof IntegerProperty) {
            return "0";
        }
        if (p instanceof LongProperty) {
            return "0L";
        }
        if (p instanceof DecimalProperty) {
            return "0.0";
        }
        if (p instanceof MapProperty) {
            MapProperty ap = (MapProperty)p;
            String inner = this.getSwaggerType(ap.getAdditionalProperties());
            return "new QMap<QString, " + inner + ">()";
        }
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            String inner = this.getSwaggerType(ap.getItems());
            if (!this.languageSpecificPrimitives.contains(inner)) {
                inner = inner + "*";
            }
            return "new QList<" + inner + ">()";
        }
        if (p instanceof RefProperty) {
            RefProperty rp = (RefProperty)p;
            return "new " + this.toModelName(rp.getSimpleRef()) + "()";
        }
        return "NULL";
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
            if (this.foundationClasses.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String toModelName(String type) {
        if (this.typeMapping.keySet().contains(type) || this.typeMapping.values().contains(type) || this.importMapping.values().contains(type) || this.defaultIncludes.contains(type) || this.languageSpecificPrimitives.contains(type)) {
            return type;
        }
        return "SWG" + Character.toUpperCase(type.charAt(0)) + type.substring(1);
    }

    @Override
    public String toApiName(String type) {
        return "SWG" + Character.toUpperCase(type.charAt(0)) + type.substring(1) + "Api";
    }
}

