/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.gdalframework;

import it.geosolutions.imageio.gdalframework.GDALCreateOption;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GDALCreateOptionsHandler {
    private final Map<String, GDALCreateOption> createOptionsMap = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCreateOptions() {
        Vector<String> options = new Vector<String>();
        Map<String, GDALCreateOption> map = this.createOptionsMap;
        synchronized (map) {
            Collection<GDALCreateOption> values = this.createOptionsMap.values();
            for (GDALCreateOption selectedOption : values) {
                if (!selectedOption.isSet()) continue;
                StringBuilder opt = new StringBuilder(selectedOption.getOptionName());
                if (selectedOption.getRepresentedValueType() != 55) {
                    opt.append("=").append(selectedOption.getValue());
                }
                options.add(opt.toString());
            }
        }
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCreateOption(String optionName, String optionValue) {
        Map<String, GDALCreateOption> map = this.createOptionsMap;
        synchronized (map) {
            if (!this.createOptionsMap.containsKey(optionName)) {
                throw new IllegalArgumentException("Create option with name" + optionName + " does not exist");
            }
            this.createOptionsMap.get(optionName).setValue(optionValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCreateOption(String optionName) {
        Map<String, GDALCreateOption> map = this.createOptionsMap;
        synchronized (map) {
            if (!this.createOptionsMap.containsKey(optionName)) {
                throw new IllegalArgumentException("Create option with name" + optionName + " does not exist");
            }
            this.createOptionsMap.get(optionName).setValue("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCreateOption(GDALCreateOption option) {
        if (option != null) {
            Map<String, GDALCreateOption> map = this.createOptionsMap;
            synchronized (map) {
                this.createOptionsMap.put(option.getOptionName(), option);
            }
        } else {
            throw new NullPointerException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCreateOptions(Collection<GDALCreateOption> options) {
        if (options != null && options.size() > 0) {
            Map<String, GDALCreateOption> map = this.createOptionsMap;
            synchronized (map) {
                for (GDALCreateOption o : options) {
                    if (o == null || !(o instanceof GDALCreateOption)) continue;
                    GDALCreateOption option = o;
                    this.createOptionsMap.put(option.getOptionName(), option);
                }
            }
        } else {
            throw new IllegalArgumentException("The provided collection is null or empty");
        }
    }

    public void setCreateOption(String optionName, int optionValue) {
        this.setCreateOption(optionName, Integer.toString(optionValue));
    }

    public void setCreateOption(String optionName, float optionValue) {
        this.setCreateOption(optionName, Float.toString(optionValue));
    }
}

