/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipFile;
import net.bull.javamelody.Collector;
import net.bull.javamelody.CollectorServer;
import net.bull.javamelody.I18N;
import net.bull.javamelody.LOG;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.Range;
import net.bull.javamelody.TransportFormat;

class JnlpPage {
    static final String JNLP_PREFIX = "jnlp.";
    private final Collector collector;
    private final CollectorServer collectorServer;
    private final String codebase;
    private final String cookies;
    private final Range range;
    private final Writer writer;

    JnlpPage(Collector collector, CollectorServer collectorServer, String codebase, String cookies, Range range, Writer writer) {
        this.collector = collector;
        this.collectorServer = collectorServer;
        this.codebase = codebase;
        this.cookies = cookies;
        this.range = range;
        this.writer = writer;
    }

    void toJnlp() throws IOException {
        File jarFile = JnlpPage.getJarFile();
        this.println("<jnlp spec='1.0+' codebase='" + this.codebase + "'>");
        this.println("   <information>");
        this.println("      <title>JavaMelody</title>");
        this.println("      <vendor>JavaMelody</vendor>");
        this.println("      <description>Monitoring</description>");
        if (!jarFile.exists()) {
            this.println("      <icon href='" + this.codebase + "?resource=systemmonitor.png'/>");
        }
        this.println("      <offline-allowed />");
        this.println("   </information>");
        this.println("   <security> <all-permissions/> </security>");
        this.println("   <update check='always' policy='always'/>");
        this.println("   <resources>");
        this.println("      <j2se version='1.7+' max-heap-size='300m'/>");
        if (jarFile.exists()) {
            this.println("      <jar href='" + this.codebase + "?part=" + "desktopJar" + "' size='" + jarFile.length() + "'/>");
        } else {
            String jarFileUrl = JnlpPage.getJarFileUrl();
            this.println("      <jar href='" + jarFileUrl + "' />");
        }
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put("javamelody.application", this.collector.getApplication());
        properties.put("javamelody.collectorServer", this.collectorServer != null);
        String url = this.collectorServer == null ? this.codebase + "?format=serialized" : this.codebase + "?format=serialized&application=" + this.collector.getApplication();
        properties.put("javamelody.url", url);
        properties.put("javamelody.range", this.range.getValue());
        properties.put("javamelody.locale", I18N.getCurrentLocale());
        for (Parameter parameter : Parameter.values()) {
            if (Parameters.getParameter(parameter) == null || parameter == Parameter.ADMIN_EMAILS) continue;
            properties.put("javamelody." + parameter.getCode(), Parameters.getParameter(parameter));
        }
        if (this.cookies != null) {
            properties.put("cookies", this.cookies);
        }
        for (Map.Entry entry : properties.entrySet()) {
            this.println("      <property name='jnlp." + (String)entry.getKey() + "' value='" + entry.getValue() + "'/>");
        }
        this.println("   </resources>");
        this.println("   <application-desc main-class='net.bull.javamelody.Main' />");
        this.println("</jnlp>");
    }

    private void println(String string) throws IOException {
        this.writer.write(string);
        this.writer.write(10);
    }

    private static String getJarFileUrl() {
        String jarFileUrl = Parameters.getParameter(Parameter.JAVAMELODY_SWING_URL) != null ? Parameters.getParameter(Parameter.JAVAMELODY_SWING_URL) : (Parameters.JAVAMELODY_VERSION != null ? (Parameters.JAVAMELODY_VERSION.compareTo("1.49.0") <= 0 ? "http://javamelody.googlecode.com/files/javamelody-swing-" + Parameters.JAVAMELODY_VERSION + ".jar" : "http://javamelody.googlecode.com/files/javamelody-swing-1.49.0.jar") : "http://javamelody.googlecode.com/files/javamelody-swing.jar");
        return jarFileUrl;
    }

    static File getJarFile() {
        String jarFileUrl = JnlpPage.getJarFileUrl();
        if (jarFileUrl.lastIndexOf(47) != -1) {
            String jarFileName = jarFileUrl.substring(jarFileUrl.lastIndexOf(47) + 1);
            return new File(Parameters.getStorageDirectory(""), jarFileName);
        }
        return new File(jarFileUrl);
    }

    static void cacheDesktopJarIfNeededAsync() {
        if (!JnlpPage.getJarFile().exists()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(62000L);
                        JnlpPage.cacheDesktopJar();
                    }
                    catch (InterruptedException e) {
                        LOG.debug(e.toString());
                    }
                }
            };
            Thread thread = new Thread(runnable, "JavaMelody Desktop Jar caching");
            thread.setDaemon(true);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File cacheDesktopJar() {
        String jarFileUrl = JnlpPage.getJarFileUrl();
        File jarFile = JnlpPage.getJarFile();
        LOG.debug("trying to download desktop jar to put in cache, from " + jarFileUrl);
        try {
            File directory = jarFile.getParentFile();
            if (!directory.mkdirs() && !directory.exists()) {
                throw new IOException("JavaMelody directory can't be created: " + directory.getPath());
            }
            long start = System.currentTimeMillis();
            URLConnection connection = new URL(jarFileUrl).openConnection();
            connection.setUseCaches(false);
            connection.setConnectTimeout(300000);
            connection.setReadTimeout(300000);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            InputStream input = connection.getInputStream();
            try {
                TransportFormat.pump(input, output);
            }
            finally {
                input.close();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(jarFile);
            try {
                fileOutputStream.write(output.toByteArray());
            }
            finally {
                fileOutputStream.close();
            }
            try {
                new ZipFile(jarFile).close();
            }
            catch (Exception e) {
                if (!jarFile.delete()) {
                    jarFile.deleteOnExit();
                }
                IOException exception = new IOException("desktop jar downloaded is not in zip format - proxy error page?");
                exception.initCause(e);
                throw exception;
            }
            long duration = System.currentTimeMillis() - start;
            LOG.debug("desktop jar downloaded and put in cache, from " + jarFileUrl + " to " + jarFile + ", in " + duration + " ms, for " + jarFile.length() / 1024L + " KB");
            return jarFile;
        }
        catch (IOException e) {
            LOG.debug("Can't download desktop jar to put in cache, from " + jarFileUrl + " - perhaps http proxy is not configured?" + " So, desktop jar will be downloaded from Internet in JWS. " + e.toString());
            return null;
        }
    }
}

