/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.Anchor;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfPCell;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.bull.javamelody.CacheInformations;
import net.bull.javamelody.HtmlCacheInformationsReport;
import net.bull.javamelody.I18N;
import net.bull.javamelody.PdfAbstractTableReport;
import net.bull.javamelody.PdfFonts;

class PdfCacheInformationsReport
extends PdfAbstractTableReport {
    private final List<CacheInformations> cacheInformationsList;
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();
    private final Font cellFont = PdfFonts.TABLE_CELL.getFont();
    private final boolean hitsRatioEnabled;
    private final boolean configurationEnabled;

    PdfCacheInformationsReport(List<CacheInformations> cacheInformationsList, Document document) {
        super(document);
        assert (cacheInformationsList != null);
        this.cacheInformationsList = cacheInformationsList;
        this.hitsRatioEnabled = HtmlCacheInformationsReport.isHitsRatioEnabled(cacheInformationsList);
        this.configurationEnabled = HtmlCacheInformationsReport.isConfigurationEnabled(cacheInformationsList);
    }

    @Override
    void toPdf() throws DocumentException {
        this.writeHeader();
        for (CacheInformations cacheInformations : this.cacheInformationsList) {
            this.nextRow();
            this.writeCacheInformations(cacheInformations);
        }
        this.addTableToDocument();
        if (!this.hitsRatioEnabled) {
            Paragraph statisticsEnabledParagraph = new Paragraph(PdfCacheInformationsReport.getString("caches_statistics_enable"), this.cellFont);
            statisticsEnabledParagraph.setAlignment(2);
            this.addToDocument((Element)statisticsEnabledParagraph);
        }
        this.addConfigurationReference();
    }

    private void addConfigurationReference() throws DocumentException {
        Anchor ehcacheAnchor = new Anchor("Configuration reference", PdfFonts.BLUE.getFont());
        ehcacheAnchor.setName("Ehcache configuration reference");
        ehcacheAnchor.setReference("http://ehcache.sourceforge.net/apidocs/net/sf/ehcache/config/CacheConfiguration.html#field_summary");
        ehcacheAnchor.setFont(PdfFonts.BLUE.getFont());
        Paragraph ehcacheParagraph = new Paragraph();
        ehcacheParagraph.add((Object)ehcacheAnchor);
        ehcacheParagraph.setAlignment(2);
        this.addToDocument((Element)ehcacheParagraph);
    }

    private void writeHeader() throws DocumentException {
        List<String> headers = this.createHeaders();
        int[] relativeWidths = new int[headers.size()];
        Arrays.fill(relativeWidths, 0, headers.size(), 1);
        if (this.configurationEnabled) {
            relativeWidths[headers.size() - 1] = 4;
        }
        this.initTable(headers, relativeWidths);
    }

    private List<String> createHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(PdfCacheInformationsReport.getString("Cache"));
        if (this.configurationEnabled) {
            headers.add(PdfCacheInformationsReport.getString("Pourcentage_memoire_utilise"));
        }
        headers.add(PdfCacheInformationsReport.getString("Nb_objets_en_memoire"));
        headers.add(PdfCacheInformationsReport.getString("Nb_objets_sur_disque"));
        if (this.hitsRatioEnabled) {
            headers.add(PdfCacheInformationsReport.getString("Efficacite_cache_memoire"));
            headers.add(PdfCacheInformationsReport.getString("Efficacite_cache"));
        }
        if (this.configurationEnabled) {
            headers.add(PdfCacheInformationsReport.getString("Configuration"));
        }
        return headers;
    }

    private void writeCacheInformations(CacheInformations cacheInformations) {
        PdfPCell defaultCell = this.getDefaultCell();
        defaultCell.setHorizontalAlignment(0);
        this.addCell(cacheInformations.getName());
        defaultCell.setHorizontalAlignment(2);
        if (this.configurationEnabled) {
            this.addCell(this.integerFormat.format(cacheInformations.getInMemoryPercentUsed()));
        }
        this.addCell(this.integerFormat.format(cacheInformations.getInMemoryObjectCount()));
        this.addCell(this.integerFormat.format(cacheInformations.getOnDiskObjectCount()));
        if (this.hitsRatioEnabled) {
            this.addCell(this.integerFormat.format(cacheInformations.getInMemoryHitsRatio()));
            this.addCell(this.integerFormat.format(cacheInformations.getHitsRatio()));
        }
        if (this.configurationEnabled) {
            defaultCell.setHorizontalAlignment(0);
            this.addCell(cacheInformations.getConfiguration());
        }
    }
}

