/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.Anchor;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfPCell;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.bull.javamelody.HtmlProcessInformationsReport;
import net.bull.javamelody.I18N;
import net.bull.javamelody.PdfAbstractTableReport;
import net.bull.javamelody.PdfFonts;
import net.bull.javamelody.ProcessInformations;

class PdfProcessInformationsReport
extends PdfAbstractTableReport {
    private final List<ProcessInformations> processInformationsList;
    private final boolean windows;
    private final DecimalFormat percentFormat = I18N.createPercentFormat();
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();

    PdfProcessInformationsReport(List<ProcessInformations> processInformationsList, Document document) {
        super(document);
        assert (processInformationsList != null);
        this.processInformationsList = processInformationsList;
        this.windows = HtmlProcessInformationsReport.isWindowsProcessList(processInformationsList);
    }

    @Override
    void toPdf() throws DocumentException {
        this.writeHeader();
        this.writeProcessInformations();
        if (!this.windows) {
            this.addPsCommandReference();
        }
    }

    private void addPsCommandReference() throws DocumentException {
        Anchor psAnchor = new Anchor("ps command reference", PdfFonts.BLUE.getFont());
        psAnchor.setName("ps command reference");
        psAnchor.setReference("http://en.wikipedia.org/wiki/Ps_(Unix)");
        psAnchor.setFont(PdfFonts.BLUE.getFont());
        Paragraph psParagraph = new Paragraph();
        psParagraph.add((Object)psAnchor);
        psParagraph.setAlignment(2);
        this.addToDocument((Element)psParagraph);
    }

    private void writeProcessInformations() throws DocumentException {
        for (ProcessInformations processInformations : this.processInformationsList) {
            this.nextRow();
            this.writeProcessInformations(processInformations);
        }
        this.addTableToDocument();
    }

    private void writeHeader() throws DocumentException {
        List<String> headers = this.createHeaders();
        int[] relativeWidths = new int[headers.size()];
        Arrays.fill(relativeWidths, 0, headers.size(), 1);
        if (this.windows) {
            relativeWidths[0] = 2;
        }
        relativeWidths[headers.size() - 1] = 6;
        this.initTable(headers, relativeWidths);
    }

    private List<String> createHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(PdfProcessInformationsReport.getString("Utilisateur"));
        headers.add(PdfProcessInformationsReport.getString("PID"));
        if (!this.windows) {
            headers.add(PdfProcessInformationsReport.getString("cpu"));
            headers.add(PdfProcessInformationsReport.getString("mem"));
        }
        headers.add(PdfProcessInformationsReport.getString("vsz"));
        if (!this.windows) {
            headers.add(PdfProcessInformationsReport.getString("rss"));
            headers.add(PdfProcessInformationsReport.getString("tty"));
            headers.add(PdfProcessInformationsReport.getString("stat"));
            headers.add(PdfProcessInformationsReport.getString("start"));
        }
        headers.add(PdfProcessInformationsReport.getString("cpuTime"));
        headers.add(PdfProcessInformationsReport.getString("command"));
        return headers;
    }

    private void writeProcessInformations(ProcessInformations processInformations) {
        PdfPCell defaultCell = this.getDefaultCell();
        defaultCell.setHorizontalAlignment(0);
        this.addCell(processInformations.getUser());
        defaultCell.setHorizontalAlignment(2);
        this.addCell(this.integerFormat.format(processInformations.getPid()));
        if (!this.windows) {
            this.addCell(this.percentFormat.format(processInformations.getCpuPercentage()));
            this.addCell(this.percentFormat.format(processInformations.getMemPercentage()));
        }
        this.addCell(this.integerFormat.format(processInformations.getVsz()));
        if (!this.windows) {
            this.addCell(this.integerFormat.format(processInformations.getRss()));
            defaultCell.setHorizontalAlignment(0);
            this.addCell(processInformations.getTty());
            this.addCell(processInformations.getStat());
            defaultCell.setHorizontalAlignment(2);
            this.addCell(processInformations.getStart());
        }
        this.addCell(processInformations.getCpuTime());
        defaultCell.setHorizontalAlignment(0);
        this.addCell(processInformations.getCommand());
    }
}

