/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bull.javamelody.I18N;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.PdfAbstractTableReport;
import net.bull.javamelody.PdfDocumentFactory;
import net.bull.javamelody.PdfFonts;
import net.bull.javamelody.SessionInformations;

class PdfSessionInformationsReport
extends PdfAbstractTableReport {
    private final List<SessionInformations> sessionsInformations;
    private final boolean displayUser;
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();
    private final DateFormat durationFormat = I18N.createDurationFormat();
    private final DateFormat expiryFormat = I18N.createDateAndTimeFormat();
    private final Font cellFont = PdfFonts.TABLE_CELL.getFont();
    private final Font severeCellFont = PdfFonts.SEVERE_CELL.getFont();
    private final Map<String, Image> imagesByCountry = new HashMap<String, Image>();

    PdfSessionInformationsReport(List<SessionInformations> sessionsInformations, Document document) {
        super(document);
        assert (sessionsInformations != null);
        this.sessionsInformations = sessionsInformations;
        this.displayUser = this.isDisplayUser();
    }

    private boolean isDisplayUser() {
        for (SessionInformations sessionInformations : this.sessionsInformations) {
            if (sessionInformations.getRemoteUser() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    void toPdf() throws IOException, DocumentException {
        if (this.sessionsInformations.isEmpty()) {
            this.addToDocument((Element)new Phrase(PdfSessionInformationsReport.getString("Aucune_session"), this.cellFont));
            return;
        }
        this.writeHeader();
        this.writeSessions();
        long totalSerializedSize = 0L;
        int nbSerializableSessions = 0;
        for (SessionInformations sessionInformations : this.sessionsInformations) {
            int size = sessionInformations.getSerializedSize();
            if (size < 0) continue;
            totalSerializedSize += (long)size;
            ++nbSerializableSessions;
        }
        long meanSerializedSize = nbSerializableSessions > 0 ? totalSerializedSize / (long)nbSerializableSessions : -1L;
        Paragraph paragraph = new Paragraph("", this.cellFont);
        paragraph.add((Object)(PdfSessionInformationsReport.getFormattedString("nb_sessions", this.sessionsInformations.size()) + "\n\n" + PdfSessionInformationsReport.getFormattedString("taille_moyenne_sessions", meanSerializedSize)));
        paragraph.setAlignment(2);
        this.addToDocument((Element)paragraph);
    }

    private void writeHeader() throws DocumentException {
        List<String> headers = this.createHeaders();
        int[] relativeWidths = new int[headers.size()];
        Arrays.fill(relativeWidths, 0, headers.size(), 1);
        relativeWidths[0] = 3;
        this.initTable(headers, relativeWidths);
    }

    private List<String> createHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(PdfSessionInformationsReport.getString("Session_id"));
        headers.add(PdfSessionInformationsReport.getString("Dernier_acces"));
        headers.add(PdfSessionInformationsReport.getString("Age"));
        headers.add(PdfSessionInformationsReport.getString("Expiration"));
        headers.add(PdfSessionInformationsReport.getString("Nb_attributs"));
        headers.add(PdfSessionInformationsReport.getString("Serialisable"));
        headers.add(PdfSessionInformationsReport.getString("Taille_serialisee"));
        headers.add(PdfSessionInformationsReport.getString("Adresse_IP"));
        headers.add(PdfSessionInformationsReport.getString("Pays"));
        if (this.displayUser) {
            headers.add(PdfSessionInformationsReport.getString("Utilisateur"));
        }
        return headers;
    }

    private void writeSessions() throws IOException, DocumentException {
        for (SessionInformations session : this.sessionsInformations) {
            this.nextRow();
            this.writeSession(session);
        }
        this.addTableToDocument();
    }

    private void writeSession(SessionInformations session) throws IOException, BadElementException {
        PdfPCell defaultCell = this.getDefaultCell();
        defaultCell.setHorizontalAlignment(0);
        this.addCell(session.getId());
        defaultCell.setHorizontalAlignment(2);
        this.addCell(this.durationFormat.format(session.getLastAccess()));
        this.addCell(this.durationFormat.format(session.getAge()));
        this.addCell(this.expiryFormat.format(session.getExpirationDate()));
        this.addCell(this.integerFormat.format(session.getAttributeCount()));
        defaultCell.setHorizontalAlignment(1);
        if (session.isSerializable()) {
            this.addCell(PdfSessionInformationsReport.getString("oui"));
        } else {
            Phrase non = new Phrase(PdfSessionInformationsReport.getString("non"), this.severeCellFont);
            this.addCell(non);
        }
        defaultCell.setHorizontalAlignment(2);
        this.addCell(this.integerFormat.format(session.getSerializedSize()));
        defaultCell.setHorizontalAlignment(0);
        String remoteAddr = session.getRemoteAddr();
        if (remoteAddr == null) {
            this.addCell("");
        } else {
            this.addCell(remoteAddr);
        }
        defaultCell.setHorizontalAlignment(1);
        this.writeCountry(session);
        if (this.displayUser) {
            defaultCell.setHorizontalAlignment(0);
            String remoteUser = session.getRemoteUser();
            if (remoteUser == null) {
                this.addCell("");
            } else {
                this.addCell(remoteUser);
            }
        }
    }

    private void writeCountry(SessionInformations session) throws IOException, BadElementException {
        String country = session.getCountry();
        if (country == null) {
            this.addCell("");
        } else {
            Image image = this.getCountryImage(country);
            if (image == null) {
                this.addCell(country);
            } else {
                this.addCell(new Phrase(new Chunk(image, 0.0f, 0.0f)));
            }
        }
    }

    private Image getCountryImage(String country) throws BadElementException, IOException {
        assert (country != null);
        Image image = this.imagesByCountry.get(country);
        if (image == null) {
            String fileName = "flags/" + country + ".gif";
            if (this.getClass().getResource(Parameters.getResourcePath(fileName)) == null) {
                return null;
            }
            image = PdfDocumentFactory.getImage(fileName);
            image.scalePercent(40.0f);
            this.imagesByCountry.put(country, image);
        }
        return image;
    }
}

