/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback;

import ch.qos.logback.classic.pattern.ThrowableHandlingConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.spi.ContextAware;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.List;
import net.logstash.logback.composite.ContextJsonProvider;
import net.logstash.logback.composite.FieldNamesAware;
import net.logstash.logback.composite.GlobalCustomFieldsJsonProvider;
import net.logstash.logback.composite.JsonProvider;
import net.logstash.logback.composite.JsonProviders;
import net.logstash.logback.composite.LogstashVersionJsonProvider;
import net.logstash.logback.composite.loggingevent.CallerDataJsonProvider;
import net.logstash.logback.composite.loggingevent.ContextMapJsonProvider;
import net.logstash.logback.composite.loggingevent.JsonMessageJsonProvider;
import net.logstash.logback.composite.loggingevent.LogLevelJsonProvider;
import net.logstash.logback.composite.loggingevent.LogLevelValueJsonProvider;
import net.logstash.logback.composite.loggingevent.LoggerNameJsonProvider;
import net.logstash.logback.composite.loggingevent.LoggingEventCompositeJsonFormatter;
import net.logstash.logback.composite.loggingevent.LoggingEventFormattedTimestampJsonProvider;
import net.logstash.logback.composite.loggingevent.LoggingEventJsonProviders;
import net.logstash.logback.composite.loggingevent.LogstashMarkersJsonProvider;
import net.logstash.logback.composite.loggingevent.MdcJsonProvider;
import net.logstash.logback.composite.loggingevent.MessageJsonProvider;
import net.logstash.logback.composite.loggingevent.StackTraceJsonProvider;
import net.logstash.logback.composite.loggingevent.TagsJsonProvider;
import net.logstash.logback.composite.loggingevent.ThreadNameJsonProvider;
import net.logstash.logback.fieldnames.LogstashFieldNames;

public class LogstashFormatter
extends LoggingEventCompositeJsonFormatter {
    protected LogstashFieldNames fieldNames;
    private final LoggingEventFormattedTimestampJsonProvider timestampProvider = new LoggingEventFormattedTimestampJsonProvider();
    private final LogstashVersionJsonProvider<ILoggingEvent> versionProvider = new LogstashVersionJsonProvider();
    private final MessageJsonProvider messageProvider = new MessageJsonProvider();
    private final LoggerNameJsonProvider loggerNameProvider = new LoggerNameJsonProvider();
    private final ThreadNameJsonProvider threadNameProvider = new ThreadNameJsonProvider();
    private final LogLevelJsonProvider logLevelProvider = new LogLevelJsonProvider();
    private final LogLevelValueJsonProvider logLevelValueProvider = new LogLevelValueJsonProvider();
    private CallerDataJsonProvider callerDataProvider;
    private final StackTraceJsonProvider stackTraceProvider = new StackTraceJsonProvider();
    private ContextJsonProvider<ILoggingEvent> contextProvider = new ContextJsonProvider();
    @Deprecated
    private final JsonMessageJsonProvider jsonMessageProvider = new JsonMessageJsonProvider();
    private MdcJsonProvider mdcProvider = new MdcJsonProvider();
    @Deprecated
    private ContextMapJsonProvider contextMapProvider;
    private GlobalCustomFieldsJsonProvider<ILoggingEvent> globalCustomFieldsProvider;
    private final TagsJsonProvider tagsProvider = new TagsJsonProvider();
    private final LogstashMarkersJsonProvider logstashMarkersProvider = new LogstashMarkersJsonProvider();

    public LogstashFormatter(ContextAware declaredOrigin) {
        this(declaredOrigin, false);
    }

    public LogstashFormatter(ContextAware declaredOrigin, boolean includeCallerInfo) {
        this(declaredOrigin, includeCallerInfo, null);
    }

    public LogstashFormatter(ContextAware declaredOrigin, boolean includeCallerInfo, JsonNode customFields) {
        super(declaredOrigin);
        this.fieldNames = new LogstashFieldNames();
        this.setIncludeCallerInfo(includeCallerInfo);
        this.setCustomFields(customFields);
        this.getProviders().addTimestamp(this.timestampProvider);
        this.getProviders().addVersion(this.versionProvider);
        this.getProviders().addMessage(this.messageProvider);
        this.getProviders().addLoggerName(this.loggerNameProvider);
        this.getProviders().addThreadName(this.threadNameProvider);
        this.getProviders().addLogLevel(this.logLevelProvider);
        this.getProviders().addLogLevelValue(this.logLevelValueProvider);
        this.getProviders().addCallerData(this.callerDataProvider);
        this.getProviders().addStackTrace(this.stackTraceProvider);
        this.getProviders().addContext(this.contextProvider);
        this.getProviders().addJsonMessage(this.jsonMessageProvider);
        this.getProviders().addMdc(this.mdcProvider);
        this.getProviders().addContextMap(this.contextMapProvider);
        this.getProviders().addGlobalCustomFields(this.globalCustomFieldsProvider);
        this.getProviders().addTags(this.tagsProvider);
        this.getProviders().addLogstashMarkers(this.logstashMarkersProvider);
    }

    @Override
    public void start() {
        this.configureProviderFieldNames();
        super.start();
    }

    protected void configureProviderFieldNames() {
        for (JsonProvider provider : this.getProviders().getProviders()) {
            if (!(provider instanceof FieldNamesAware)) continue;
            ((FieldNamesAware)((Object)provider)).setFieldNames(this.fieldNames);
        }
    }

    public boolean isIncludeCallerData() {
        return this.callerDataProvider != null;
    }

    public void setIncludeCallerData(boolean includeCallerData) {
        if (this.isIncludeCallerData() != includeCallerData) {
            this.getProviders().removeProvider(this.callerDataProvider);
            if (includeCallerData) {
                this.callerDataProvider = new CallerDataJsonProvider();
                this.getProviders().addCallerData(this.callerDataProvider);
            } else {
                this.callerDataProvider = null;
            }
        }
    }

    @Deprecated
    public boolean isIncludeCallerInfo() {
        return this.isIncludeCallerData();
    }

    @Deprecated
    public void setIncludeCallerInfo(boolean includeCallerInfo) {
        this.setIncludeCallerData(includeCallerInfo);
    }

    public String getCustomFieldsAsString() {
        return this.globalCustomFieldsProvider == null ? null : this.globalCustomFieldsProvider.getCustomFields();
    }

    public void setCustomFieldsFromString(String customFields) {
        if (customFields == null || customFields.length() == 0) {
            this.getProviders().removeProvider(this.globalCustomFieldsProvider);
            this.globalCustomFieldsProvider = null;
        } else {
            if (this.globalCustomFieldsProvider == null) {
                this.globalCustomFieldsProvider = new GlobalCustomFieldsJsonProvider<ILoggingEvent>();
                this.getProviders().addGlobalCustomFields(this.globalCustomFieldsProvider);
            }
            this.globalCustomFieldsProvider.setCustomFields(customFields);
        }
    }

    public void setCustomFields(JsonNode customFields) {
        if (customFields == null) {
            this.getProviders().removeProvider(this.globalCustomFieldsProvider);
            this.globalCustomFieldsProvider = null;
        } else {
            if (this.globalCustomFieldsProvider == null) {
                this.globalCustomFieldsProvider = new GlobalCustomFieldsJsonProvider<ILoggingEvent>();
                this.getProviders().addGlobalCustomFields(this.globalCustomFieldsProvider);
            }
            this.globalCustomFieldsProvider.setCustomFieldsNode(customFields);
        }
    }

    public JsonNode getCustomFields() {
        return this.globalCustomFieldsProvider == null ? null : this.globalCustomFieldsProvider.getCustomFieldsNode();
    }

    public int getShortenedLoggerNameLength() {
        return this.loggerNameProvider.getShortenedLoggerNameLength();
    }

    public void setShortenedLoggerNameLength(int length) {
        this.loggerNameProvider.setShortenedLoggerNameLength(length);
    }

    public boolean isIncludeMdc() {
        return this.mdcProvider != null;
    }

    public void setIncludeMdc(boolean includeMdc) {
        if (this.isIncludeMdc() != includeMdc) {
            this.getProviders().removeProvider(this.mdcProvider);
            if (includeMdc) {
                this.mdcProvider = new MdcJsonProvider();
                this.getProviders().addMdc(this.mdcProvider);
            } else {
                this.mdcProvider = null;
            }
        }
    }

    public List<String> getIncludeMdcKeyNames() {
        return this.isIncludeMdc() ? this.mdcProvider.getIncludeMdcKeyNames() : Collections.emptyList();
    }

    public void addIncludeMdcKeyName(String includedMdcKeyName) {
        if (this.isIncludeMdc()) {
            this.mdcProvider.addIncludeMdcKeyName(includedMdcKeyName);
        }
    }

    public void setIncludeMdcKeyNames(List<String> includeMdcKeyNames) {
        if (this.isIncludeMdc()) {
            this.mdcProvider.setIncludeMdcKeyNames(includeMdcKeyNames);
        }
    }

    public List<String> getExcludeMdcKeyNames() {
        return this.isIncludeMdc() ? this.mdcProvider.getExcludeMdcKeyNames() : Collections.emptyList();
    }

    public void addExcludeMdcKeyName(String excludedMdcKeyName) {
        if (this.isIncludeMdc()) {
            this.mdcProvider.addExcludeMdcKeyName(excludedMdcKeyName);
        }
    }

    public void setExcludeMdcKeyNames(List<String> excludeMdcKeyNames) {
        if (this.isIncludeMdc()) {
            this.mdcProvider.setExcludeMdcKeyNames(excludeMdcKeyNames);
        }
    }

    public boolean isIncludeContext() {
        return this.contextProvider != null;
    }

    public void setIncludeContext(boolean includeContext) {
        if (this.isIncludeContext() != includeContext) {
            this.getProviders().removeProvider(this.contextProvider);
            if (includeContext) {
                this.contextProvider = new ContextJsonProvider();
                this.getProviders().addContext(this.contextProvider);
            } else {
                this.contextProvider = null;
            }
        }
    }

    public ThrowableHandlingConverter getThrowableConverter() {
        return this.stackTraceProvider.getThrowableConverter();
    }

    public void setThrowableConverter(ThrowableHandlingConverter throwableConverter) {
        this.stackTraceProvider.setThrowableConverter(throwableConverter);
    }

    public int getVersion() {
        return this.versionProvider.getVersion();
    }

    public void setVersion(int version) {
        this.versionProvider.setVersion(version);
    }

    public boolean isWriteVersionAsString() {
        return this.versionProvider.isWriteAsString();
    }

    public void setWriteVersionAsString(boolean writeVersionAsString) {
        this.versionProvider.setWriteAsString(writeVersionAsString);
    }

    @Deprecated
    public boolean isEnableContextMap() {
        return this.contextMapProvider != null;
    }

    @Deprecated
    public void setEnableContextMap(boolean enableContextMap) {
        if (this.isEnableContextMap() != enableContextMap) {
            this.getProviders().removeProvider(this.contextMapProvider);
            if (enableContextMap) {
                this.contextMapProvider = new ContextMapJsonProvider();
                this.getProviders().addContextMap(this.contextMapProvider);
            } else {
                this.contextMapProvider = null;
            }
        }
    }

    public void addProvider(JsonProvider<ILoggingEvent> provider) {
        this.getProviders().addProvider(provider);
    }

    public LoggingEventJsonProviders getProviders() {
        return (LoggingEventJsonProviders)super.getProviders();
    }

    public LogstashFieldNames getFieldNames() {
        return this.fieldNames;
    }

    public void setFieldNames(LogstashFieldNames fieldNames) {
        this.fieldNames = fieldNames;
    }

    public String getTimeZone() {
        return this.timestampProvider.getTimeZone();
    }

    public void setTimeZone(String timeZoneId) {
        this.timestampProvider.setTimeZone(timeZoneId);
    }

    @Override
    public void setProviders(JsonProviders<ILoggingEvent> jsonProviders) {
        if (super.getProviders() != null && !super.getProviders().getProviders().isEmpty()) {
            this.addError("Unable to set providers when using predefined composites.");
        } else {
            super.setProviders(jsonProviders);
        }
    }
}

