/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.nonstop.concurrency;

import java.util.LinkedList;
import net.sf.ehcache.constructs.nonstop.concurrency.ExplicitLockingContext;
import net.sf.ehcache.util.lang.VicariousThreadLocal;

public final class ExplicitLockingContextThreadLocal {
    private final VicariousThreadLocal<ExplicitLockingContext> contextThreadLocal = new VicariousThreadLocal<ExplicitLockingContext>(){

        @Override
        protected ExplicitLockingContextImpl initialValue() {
            return new ExplicitLockingContextImpl();
        }
    };

    public boolean areAnyExplicitLocksAcquired() {
        return this.contextThreadLocal.get().areAnyExplicitLocksAcquired();
    }

    public ExplicitLockingContext getCurrentThreadLockContext() {
        return this.contextThreadLocal.get();
    }

    private static class ExplicitLockingContextImpl
    implements ExplicitLockingContext {
        private volatile boolean locksAcquired;
        private final LinkedList<Long> lockAcquisitionStack = new LinkedList();

        private ExplicitLockingContextImpl() {
        }

        public boolean areAnyExplicitLocksAcquired() {
            return this.locksAcquired;
        }

        public void lockAcquired(long currentNonstopThreadUniqueId) {
            this.locksAcquired = true;
            this.lockAcquisitionStack.addFirst(currentNonstopThreadUniqueId);
        }

        public void lockReleased() {
            if (this.lockAcquisitionStack.peek() != null) {
                this.lockAcquisitionStack.removeFirst();
            }
            if (this.lockAcquisitionStack.peek() == null) {
                this.locksAcquired = false;
            }
        }

        public boolean areLocksAcquiredByOtherThreads(long currentNonstopThreadUniqueId) {
            for (Long nonstopThreadUniqueId : this.lockAcquisitionStack) {
                if (nonstopThreadUniqueId == currentNonstopThreadUniqueId) continue;
                return true;
            }
            return false;
        }
    }
}

