/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.filters;

import edu.uci.ics.jung.graph.Hypergraph;
import java.util.ArrayList;
import java.util.Collection;

public class FilterUtils {
    public static <V, E, G extends Hypergraph<V, E>> G createInducedSubgraph(Collection<V> vertices, G graph) {
        Hypergraph subgraph = null;
        try {
            subgraph = (Hypergraph)graph.getClass().newInstance();
            for (V v : vertices) {
                if (!graph.containsVertex(v)) {
                    throw new IllegalArgumentException("Vertex " + v + " is not an element of " + graph);
                }
                subgraph.addVertex(v);
            }
            for (Object e : graph.getEdges()) {
                Collection incident = graph.getIncidentVertices(e);
                if (!vertices.containsAll(incident)) continue;
                subgraph.addEdge(e, incident, graph.getEdgeType(e));
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to create copy of existing graph: ", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to create copy of existing graph: ", e);
        }
        return (G)subgraph;
    }

    public static <V, E, G extends Hypergraph<V, E>> Collection<G> createAllInducedSubgraphs(Collection<? extends Collection<V>> vertex_collections, G graph) {
        ArrayList<G> subgraphs = new ArrayList<G>();
        for (Collection<V> vertex_set : vertex_collections) {
            subgraphs.add(FilterUtils.createInducedSubgraph(vertex_set, graph));
        }
        return subgraphs;
    }
}

