/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.wimpi.modbus.ModbusCoupler;
import net.wimpi.modbus.io.NonWordDataHandler;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.msg.WriteMultipleRegistersResponse;
import net.wimpi.modbus.procimg.IllegalAddressException;
import net.wimpi.modbus.procimg.ProcessImage;
import net.wimpi.modbus.procimg.ProcessImageFactory;
import net.wimpi.modbus.procimg.Register;

public final class WriteMultipleRegistersRequest
extends ModbusRequest {
    private int m_Reference;
    private Register[] m_Registers;
    private NonWordDataHandler m_NonWordDataHandler = null;

    public WriteMultipleRegistersRequest() {
        this.setFunctionCode(16);
    }

    public WriteMultipleRegistersRequest(int ref, Register[] registers) {
        this.setFunctionCode(16);
        this.setReference(ref);
        this.setRegisters(registers);
    }

    public ModbusResponse createResponse() {
        WriteMultipleRegistersResponse response = null;
        if (this.m_NonWordDataHandler == null) {
            Register[] regs = null;
            ProcessImage procimg = ModbusCoupler.getReference().getProcessImage();
            try {
                regs = procimg.getRegisterRange(this.getReference(), this.getWordCount());
                for (int i = 0; i < regs.length; ++i) {
                    regs[i].setValue(this.getRegister(i).toBytes());
                }
            }
            catch (IllegalAddressException iaex) {
                return this.createExceptionResponse(2);
            }
            response = new WriteMultipleRegistersResponse(this.getReference(), regs.length);
        } else {
            int result = this.m_NonWordDataHandler.commitUpdate();
            if (result > 0) {
                return this.createExceptionResponse(result);
            }
            response = new WriteMultipleRegistersResponse(this.getReference(), this.m_NonWordDataHandler.getWordCount());
        }
        if (!this.isHeadless()) {
            response.setTransactionID(this.getTransactionID());
            response.setProtocolID(this.getProtocolID());
        } else {
            response.setHeadless();
        }
        response.setUnitID(this.getUnitID());
        response.setFunctionCode(this.getFunctionCode());
        return response;
    }

    public void setReference(int ref) {
        this.m_Reference = ref;
    }

    public int getReference() {
        return this.m_Reference;
    }

    public void setRegisters(Register[] registers) {
        this.m_Registers = registers;
        this.setDataLength(5 + this.getByteCount());
    }

    public Register[] getRegisters() {
        return this.m_Registers;
    }

    public Register getRegister(int index) throws IndexOutOfBoundsException {
        if (index >= this.getWordCount()) {
            throw new IndexOutOfBoundsException();
        }
        return this.m_Registers[index];
    }

    public int getRegisterValue(int index) throws IndexOutOfBoundsException {
        return this.m_Registers[index].toUnsignedShort();
    }

    public int getByteCount() {
        return this.getWordCount() * 2;
    }

    public int getWordCount() {
        return this.m_Registers.length;
    }

    public void setNonWordDataHandler(NonWordDataHandler dhandler) {
        this.m_NonWordDataHandler = dhandler;
        this.setDataLength(5 + this.m_NonWordDataHandler.getWordCount() * 2);
    }

    public NonWordDataHandler getNonWordDataHandler() {
        return this.m_NonWordDataHandler;
    }

    public void writeData(DataOutput dout) throws IOException {
        dout.writeShort(this.m_Reference);
        dout.writeShort(this.getWordCount());
        dout.writeByte(this.getByteCount());
        if (this.m_NonWordDataHandler == null) {
            for (int n = 0; n < this.m_Registers.length; ++n) {
                dout.write(this.m_Registers[n].toBytes());
            }
        } else {
            this.m_NonWordDataHandler.prepareData(this.getReference(), this.getWordCount());
            dout.write(this.m_NonWordDataHandler.getData());
        }
    }

    public void readData(DataInput din) throws IOException {
        this.m_Reference = din.readShort();
        int wc = din.readUnsignedShort();
        int bc = din.readUnsignedByte();
        if (this.m_NonWordDataHandler == null) {
            this.m_Registers = new Register[wc];
            ProcessImageFactory pimf = ModbusCoupler.getReference().getProcessImageFactory();
            for (int i = 0; i < wc; ++i) {
                this.m_Registers[i] = pimf.createRegister(din.readByte(), din.readByte());
            }
        } else {
            this.m_NonWordDataHandler.readData(din, this.m_Reference, wc);
        }
    }
}

