/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.out;

import java.io.OutputStream;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterNT;
import org.apache.jena.riot.out.NodeToLabel;
import org.apache.jena.riot.system.Prologue;
import org.apache.jena.sparql.core.Quad;

public class SinkQuadOutput
implements Sink<Quad> {
    private Prologue prologue = null;
    private AWriter out;
    private NodeToLabel labelPolicy = null;
    private NodeFormatter nodeFmt = new NodeFormatterNT();

    public SinkQuadOutput(OutputStream outs, Prologue prologue, NodeToLabel labels) {
        this.out = IO.wrapUTF8((OutputStream)outs);
        this.setPrologue(prologue);
        this.setLabelPolicy(labels);
    }

    public void setPrologue(Prologue prologue) {
        this.prologue = prologue;
    }

    public void setLabelPolicy(NodeToLabel labels) {
        this.labelPolicy = labels;
    }

    public void send(Quad quad) {
        Node s = quad.getSubject();
        Node p = quad.getPredicate();
        Node o = quad.getObject();
        Node g = quad.getGraph();
        this.nodeFmt.format(this.out, s);
        this.out.print(" ");
        this.nodeFmt.format(this.out, p);
        this.out.print(" ");
        this.nodeFmt.format(this.out, o);
        if (SinkQuadOutput.outputGraphSlot(g)) {
            this.out.print(" ");
            this.nodeFmt.format(this.out, g);
        }
        this.out.print(" .\n");
    }

    private static boolean outputGraphSlot(Node g) {
        return g != null && g != Quad.tripleInQuad && !Quad.isDefaultGraph(g);
    }

    public void flush() {
        IO.flush((AWriter)this.out);
    }

    public void close() {
        IO.flush((AWriter)this.out);
    }
}

