/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Iterator;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.shared.Lock;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.NodeUtils;

public class DatasetImpl
implements Dataset {
    protected DatasetGraph dsg = null;
    private Transactional transactional = null;

    public static Dataset wrap(DatasetGraph datasetGraph) {
        return new DatasetImpl(datasetGraph);
    }

    protected DatasetImpl(DatasetGraph dsg) {
        this(dsg, dsg.supportsTransactions() ? dsg : null);
    }

    protected DatasetImpl(DatasetGraph dsg, Transactional transactional) {
        this.dsg = dsg;
        this.transactional = transactional;
    }

    public DatasetImpl(Model model) {
        this.dsg = DatasetGraphFactory.create(model.getGraph());
        this.transactional = this.dsg;
    }

    @Deprecated
    public DatasetImpl(Dataset ds) {
        this(DatasetGraphFactory.cloneStructure(ds.asDatasetGraph()));
    }

    @Override
    public Model getDefaultModel() {
        return ModelFactory.createModelForGraph((Graph)this.dsg.getDefaultGraph());
    }

    @Override
    public Model getUnionModel() {
        return ModelFactory.createModelForGraph((Graph)this.dsg.getUnionGraph());
    }

    @Override
    public Lock getLock() {
        return this.dsg.getLock();
    }

    @Override
    public Context getContext() {
        return this.dsg.getContext();
    }

    @Override
    public boolean supportsTransactions() {
        return this.dsg.supportsTransactions();
    }

    @Override
    public boolean supportsTransactionAbort() {
        return this.dsg.supportsTransactionAbort();
    }

    @Override
    public void begin(ReadWrite mode) {
        this.checkTransactional();
        this.transactional.begin(mode);
    }

    @Override
    public boolean isInTransaction() {
        this.checkTransactional();
        return this.transactional != null && this.transactional.isInTransaction();
    }

    @Override
    public void commit() {
        this.checkTransactional();
        this.transactional.commit();
    }

    @Override
    public void abort() {
        this.checkTransactional();
        this.transactional.abort();
    }

    @Override
    public void end() {
        this.checkTransactional();
        this.transactional.end();
    }

    private void checkTransactional() {
        if (!this.supportsTransactions()) {
            throw new UnsupportedOperationException("Transactions not supported");
        }
    }

    @Override
    public DatasetGraph asDatasetGraph() {
        return this.dsg;
    }

    @Override
    public Model getNamedModel(String uri) {
        DatasetImpl.checkGraphName(uri);
        Node n = NodeFactory.createURI((String)uri);
        return this.graph2model(this.dsg.getGraph(n));
    }

    @Override
    public void addNamedModel(String uri, Model model) {
        DatasetImpl.checkGraphName(uri);
        Node n = NodeFactory.createURI((String)uri);
        this.dsg.addGraph(n, model.getGraph());
    }

    @Override
    public void removeNamedModel(String uri) {
        DatasetImpl.checkGraphName(uri);
        Node n = NodeFactory.createURI((String)uri);
        this.dsg.removeGraph(n);
    }

    @Override
    public void replaceNamedModel(String uri, Model model) {
        DatasetImpl.checkGraphName(uri);
        Node n = NodeFactory.createURI((String)uri);
        this.dsg.removeGraph(n);
        this.dsg.addGraph(n, model.getGraph());
    }

    @Override
    public void setDefaultModel(Model model) {
        if (model == null) {
            model = ModelFactory.createDefaultModel();
        }
        this.dsg.setDefaultGraph(model.getGraph());
    }

    @Override
    public boolean containsNamedModel(String uri) {
        DatasetImpl.checkGraphName(uri);
        Node n = NodeFactory.createURI((String)uri);
        return this.dsg.containsGraph(n);
    }

    @Override
    public Iterator<String> listNames() {
        return NodeUtils.nodesToURIs(this.dsg.listGraphNodes());
    }

    @Override
    public void close() {
        this.dsg.close();
    }

    protected Model graph2model(Graph graph) {
        if (graph == null) {
            return null;
        }
        return ModelFactory.createModelForGraph((Graph)graph);
    }

    protected static void checkGraphName(String uri) {
        if (uri == null) {
            throw new ARQException("null for graph name");
        }
    }
}

