/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementService;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementVisitorBase;
import org.apache.jena.sparql.syntax.ElementWalker;
import org.apache.jena.sparql.syntax.PatternVars;

public class SyntaxVarScope {
    public static void check(Query query) {
        if (query.getQueryPattern() == null) {
            return;
        }
        SyntaxVarScope.check(query.getQueryPattern());
        SyntaxVarScope.checkQueryScope(query);
        Collection<Var> vars = SyntaxVarScope.varsOfQuery(query);
        SyntaxVarScope.check(query, vars);
    }

    public static void check(Element queryPattern) {
        SyntaxVarScope.checkSubQuery(queryPattern);
        SyntaxVarScope.checkBind(queryPattern);
    }

    private static void checkBind(Element queryPattern) {
        BindScopeChecker v = new BindScopeChecker();
        ElementWalker.walk(queryPattern, v);
    }

    private static void checkSubQuery(Element el) {
        SubQueryScopeChecker v = new SubQueryScopeChecker();
        ElementWalker.walk(el, v);
    }

    private static void checkQueryScope(Query query) {
        Collection<Var> vars = SyntaxVarScope.varsOfQuery(query);
        SyntaxVarScope.checkExprListAssignment(vars, query.getProject());
    }

    private static Collection<Var> varsOfQuery(Query query) {
        Collection<Var> vars = PatternVars.vars(query.getQueryPattern());
        if (query.hasValues()) {
            vars.addAll(query.getValuesVariables());
        }
        return vars;
    }

    private static void check(Query query, Collection<Var> vars) {
        SyntaxVarScope.checkExprListAssignment(vars, query.getProject());
        if (!Syntax.syntaxARQ.equals(query.getSyntax()) && query.isQueryResultStar() && query.hasGroupBy()) {
            throw new QueryParseException("SELECT * not legal with GROUP BY", -1, -1);
        }
        SyntaxVarScope.checkExprVarUse(query);
    }

    private static void checkExprListAssignment(Collection<Var> vars, VarExprList exprList) {
        LinkedHashSet<Var> vars2 = new LinkedHashSet<Var>(vars);
        exprList.forEachExpr((v, e2) -> {
            Set<Var> varInExpr = e2.getVarsMentioned();
            vars2.addAll(varInExpr);
            SyntaxVarScope.checkAssignment(vars2, e2, v);
            vars2.add((Var)((Object)v));
        });
    }

    private static void checkExprVarUse(Query query) {
        if (query.hasGroupBy()) {
            VarExprList groupKey = query.getGroupBy();
            ArrayList<Var> inScopeVars = new ArrayList<Var>(groupKey.getVars());
            VarExprList exprList = query.getProject();
            for (Var v : exprList.getVars()) {
                Expr e2 = exprList.getExpr(v);
                if (e2 == null) {
                    if (!inScopeVars.contains((Object)v)) {
                        throw new QueryParseException("Non-group key variable in SELECT: " + (Object)((Object)v), -1, -1);
                    }
                } else {
                    Set<Var> eVars = e2.getVarsMentioned();
                    for (Var v2 : eVars) {
                        if (inScopeVars.contains((Object)v2)) continue;
                        throw new QueryParseException("Non-group key variable in SELECT: " + (Object)((Object)v2) + " in expression " + e2, -1, -1);
                    }
                }
                inScopeVars.add(v);
            }
        }
    }

    private static void checkAssignment(Collection<Var> scope, Expr expr, Var var) {
        if (expr == null) {
            return;
        }
        if (scope.contains((Object)var)) {
            throw new QueryParseException("Variable used when already in-scope: " + (Object)((Object)var) + " in " + SyntaxVarScope.fmtAssignment(expr, var), -1, -1);
        }
    }

    private static String fmtExprList(VarExprList exprList) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Var v : exprList.getVars()) {
            Expr e2 = exprList.getExpr(v);
            if (!first) {
                sb.append(" ");
            }
            first = false;
            sb.append("(").append(e2).append(" AS ").append((Object)v).append(")");
        }
        return sb.toString();
    }

    private static String fmtAssignment(Expr expr, Var var) {
        return "(" + expr + " AS " + (Object)((Object)var) + ")";
    }

    public static class BindScopeChecker
    extends ElementVisitorBase {
        @Override
        public void visit(ElementGroup el) {
            for (int i = 0; i < el.size(); ++i) {
                Collection<Var> accScope;
                Element e2 = el.get(i);
                if (e2 instanceof ElementBind) {
                    accScope = BindScopeChecker.calcScopeAll(el.getElements(), i);
                    BindScopeChecker.check(accScope, (ElementBind)e2);
                }
                if (!(e2 instanceof ElementService)) continue;
                accScope = BindScopeChecker.calcScopeAll(el.getElements(), i);
                BindScopeChecker.check(accScope, (ElementService)e2);
            }
        }

        private static Collection<Var> calcScopeAll(List<Element> elements, int idx) {
            return BindScopeChecker.calcScope(elements, 0, idx);
        }

        private static Collection<Var> calcScope(List<Element> elements, int start, int finish) {
            HashSet<Var> accScope = new HashSet<Var>();
            for (int i = start; i < finish; ++i) {
                Element e2 = elements.get(i);
                PatternVars.vars(accScope, e2);
            }
            return accScope;
        }

        private static void check(Collection<Var> scope, ElementBind el) {
            Var var = el.getVar();
            if (scope.contains((Object)var)) {
                throw new QueryParseException("BIND: Variable used when already in-scope: " + (Object)((Object)var) + " in " + el, -1, -1);
            }
            SyntaxVarScope.checkAssignment(scope, el.getExpr(), var);
        }

        private static void check(Collection<Var> scope, ElementService el) {
            Var var;
            if (ARQ.isStrictMode() && el.getServiceNode().isVariable() && !scope.contains((Object)(var = Var.alloc(el.getServiceNode())))) {
                throw new QueryParseException("SERVICE: Variable not already in-scope: " + (Object)((Object)var) + " in " + el, -1, -1);
            }
        }
    }

    private static class SubQueryScopeChecker
    extends ElementVisitorBase {
        private SubQueryScopeChecker() {
        }

        @Override
        public void visit(ElementSubQuery el) {
            Query query = el.getQuery();
            SyntaxVarScope.checkQueryScope(query);
            SyntaxVarScope.check(el.getQuery());
        }
    }
}

