/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.system;

import java.util.function.Supplier;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.core.Transactional;

public class Txn {
    public static <T extends Transactional> void executeRead(T txn, Runnable r) {
        boolean b = txn.isInTransaction();
        if (!b) {
            txn.begin(ReadWrite.READ);
        }
        try {
            r.run();
        }
        catch (Throwable th) {
            Txn.onThrowable(th, txn);
            throw th;
        }
        if (!b) {
            txn.end();
        }
    }

    public static <T extends Transactional, X> X calculateRead(T txn, Supplier<X> r) {
        boolean b = txn.isInTransaction();
        if (!b) {
            txn.begin(ReadWrite.READ);
        }
        try {
            X x = r.get();
            if (!b) {
                txn.end();
            }
            return x;
        }
        catch (Throwable th) {
            Txn.onThrowable(th, txn);
            throw th;
        }
    }

    public static <T extends Transactional> void executeWrite(T txn, Runnable r) {
        boolean b = txn.isInTransaction();
        if (!b) {
            txn.begin(ReadWrite.WRITE);
        }
        try {
            r.run();
        }
        catch (Throwable th) {
            Txn.onThrowable(th, txn);
            throw th;
        }
        if (!b) {
            if (txn.isInTransaction()) {
                txn.commit();
            }
            txn.end();
        }
    }

    public static <T extends Transactional, X> X calculateWrite(T txn, Supplier<X> r) {
        boolean b = txn.isInTransaction();
        if (!b) {
            txn.begin(ReadWrite.WRITE);
        }
        X x = null;
        try {
            x = r.get();
        }
        catch (Throwable th) {
            Txn.onThrowable(th, txn);
            throw th;
        }
        if (!b) {
            if (txn.isInTransaction()) {
                txn.commit();
            }
            txn.end();
        }
        return x;
    }

    private static <T extends Transactional> void onThrowable(Throwable th, T txn) {
        try {
            txn.abort();
            txn.end();
        }
        catch (Throwable th2) {
            th.addSuppressed(th2);
        }
    }
}

