/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.xhtml;

import java.util.Stack;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.module.xhtml.XhtmlMarkup;
import org.apache.maven.doxia.parser.AbstractXmlParser;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class XhtmlParser
extends AbstractXmlParser
implements XhtmlMarkup {
    private Stack linktypes = new Stack();
    private Stack sections = new Stack();
    private static final String LINK = "link";
    private static final String ANCHOR = "anchor";

    protected void handleStartTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        if (parser.getName().equals(HTML.Tag.TITLE.toString())) {
            sink.title();
        } else if (parser.getName().equals(HTML.Tag.ADDRESS.toString())) {
            sink.author();
        } else if (parser.getName().equals(HTML.Tag.BODY.toString())) {
            sink.body();
        } else if (parser.getName().equals(HTML.Tag.H1.toString()) || parser.getName().equals(HTML.Tag.H2.toString()) || parser.getName().equals(HTML.Tag.H3.toString()) || parser.getName().equals(HTML.Tag.H4.toString()) || parser.getName().equals(HTML.Tag.H5.toString())) {
            this.closeSubordinatedSections(parser.getName(), sink);
            this.startSection(this.sections.size(), sink);
            this.startSectionTitle(this.sections.size(), sink);
            this.sections.push(parser.getName());
        } else if (parser.getName().equals(HTML.Tag.P.toString())) {
            sink.paragraph();
        } else if (parser.getName().equals(HTML.Tag.PRE.toString())) {
            sink.verbatim(true);
        } else if (parser.getName().equals(HTML.Tag.CODE.toString()) || parser.getName().equals(HTML.Tag.SAMP.toString()) || parser.getName().equals(HTML.Tag.TT.toString())) {
            sink.monospaced();
        } else if (parser.getName().equals(HTML.Tag.UL.toString())) {
            sink.list();
        } else if (parser.getName().equals(HTML.Tag.OL.toString())) {
            sink.numberedList(0);
        } else if (parser.getName().equals(HTML.Tag.LI.toString())) {
            sink.listItem();
        } else if (parser.getName().equals(HTML.Tag.HEAD.toString())) {
            sink.head();
        } else if (parser.getName().equals(HTML.Tag.B.toString()) || parser.getName().equals(HTML.Tag.STRONG.toString())) {
            sink.bold();
        } else if (parser.getName().equals(HTML.Tag.I.toString()) || parser.getName().equals(HTML.Tag.EM.toString())) {
            sink.italic();
        } else if (parser.getName().equals(HTML.Tag.A.toString())) {
            String href = parser.getAttributeValue(null, HTML.Attribute.HREF.toString());
            String name = parser.getAttributeValue(null, HTML.Attribute.NAME.toString());
            String id = parser.getAttributeValue(null, HTML.Attribute.ID.toString());
            if (href != null) {
                sink.link(href);
                this.linktypes.push(LINK);
            } else if (name != null) {
                sink.anchor(name);
                this.linktypes.push(ANCHOR);
            } else if (id != null) {
                sink.anchor(id);
                this.linktypes.push(ANCHOR);
            }
        } else if (parser.getName().equals(HTML.Tag.BR.toString())) {
            sink.lineBreak();
        } else if (parser.getName().equals(HTML.Tag.HR.toString())) {
            sink.horizontalRule();
        } else if (parser.getName().equals(HTML.Tag.IMG.toString())) {
            sink.figure();
            String src = parser.getAttributeValue(null, HTML.Attribute.SRC.toString());
            String title = parser.getAttributeValue(null, HTML.Attribute.TITLE.toString());
            String alt = parser.getAttributeValue(null, HTML.Attribute.ALT.toString());
            if (src != null) {
                sink.figureGraphics(src);
            }
            if (title != null) {
                sink.figureCaption();
                XhtmlParser.text(sink, title);
                sink.figureCaption_();
            } else if (alt != null) {
                sink.figureCaption();
                XhtmlParser.text(sink, alt);
                sink.figureCaption_();
            }
            sink.figure_();
        } else if (parser.getName().equals(HTML.Tag.TABLE.toString())) {
            sink.table();
        } else if (parser.getName().equals(HTML.Tag.TR.toString())) {
            sink.tableRow();
        } else if (parser.getName().equals(HTML.Tag.TH.toString())) {
            sink.tableCell();
        } else if (parser.getName().equals(HTML.Tag.TD.toString())) {
            sink.tableCell();
        }
    }

    protected void handleEndTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        if (parser.getName().equals(HTML.Tag.TITLE.toString())) {
            sink.title_();
        } else if (parser.getName().equals(HTML.Tag.ADDRESS.toString())) {
            sink.author_();
        } else if (parser.getName().equals(HTML.Tag.BODY.toString())) {
            this.closeSubordinatedSections("h0", sink);
            sink.body_();
        } else if (parser.getName().equals(HTML.Tag.H1.toString()) || parser.getName().equals(HTML.Tag.H2.toString()) || parser.getName().equals(HTML.Tag.H3.toString()) || parser.getName().equals(HTML.Tag.H4.toString()) || parser.getName().equals(HTML.Tag.H5.toString())) {
            this.closeSectionTitle(this.sections.size() - 1, sink);
        } else if (parser.getName().equals(HTML.Tag.P.toString())) {
            sink.paragraph_();
        } else if (parser.getName().equals(HTML.Tag.PRE.toString())) {
            sink.verbatim_();
        } else if (parser.getName().equals(HTML.Tag.CODE.toString()) || parser.getName().equals(HTML.Tag.SAMP.toString()) || parser.getName().equals(HTML.Tag.TT.toString())) {
            sink.monospaced_();
        } else if (parser.getName().equals(HTML.Tag.UL.toString())) {
            sink.list_();
        } else if (parser.getName().equals(HTML.Tag.OL.toString())) {
            sink.numberedList_();
        } else if (parser.getName().equals(HTML.Tag.LI.toString())) {
            sink.listItem_();
        } else if (parser.getName().equals(HTML.Tag.HEAD.toString())) {
            sink.head_();
        } else if (parser.getName().equals(HTML.Tag.B.toString()) || parser.getName().equals(HTML.Tag.STRONG.toString())) {
            sink.bold_();
        } else if (parser.getName().equals(HTML.Tag.I.toString()) || parser.getName().equals(HTML.Tag.EM.toString())) {
            sink.italic_();
        } else if (parser.getName().equals(HTML.Tag.A.toString())) {
            String linktype = (String)this.linktypes.pop();
            if (linktype == LINK) {
                sink.link_();
            } else {
                sink.anchor_();
            }
        } else if (parser.getName().equals(HTML.Tag.TABLE.toString())) {
            sink.table_();
        } else if (parser.getName().equals(HTML.Tag.TR.toString())) {
            sink.tableRow_();
        } else if (parser.getName().equals(HTML.Tag.TH.toString())) {
            sink.tableCell_();
        } else if (parser.getName().equals(HTML.Tag.TD.toString())) {
            sink.tableCell_();
        }
    }

    protected void handleText(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        XhtmlParser.text(sink, parser.getText());
    }

    private static void text(Sink sink, String text) {
        if (text.startsWith("&nbsp;")) {
            sink.nonBreakingSpace();
        }
        String[] s = text.split("&nbsp;");
        for (int i = 0; i < s.length; ++i) {
            sink.text(s[i]);
            if (i + 1 >= s.length) continue;
            sink.nonBreakingSpace();
        }
        if (text.endsWith("&nbsp;")) {
            sink.nonBreakingSpace();
        }
    }

    private void closeSubordinatedSections(String level, Sink sink) {
        int mylevel;
        String heading;
        int otherlevel;
        if (this.sections.size() > 0 && (otherlevel = Integer.parseInt((heading = (String)this.sections.peek()).substring(1))) >= (mylevel = Integer.parseInt(level.substring(1)))) {
            this.closeSection(this.sections.size(), sink);
            this.closeSubordinatedSections(level, sink);
        }
    }

    private void closeSection(int level, Sink sink) {
        this.sections.pop();
        switch (level) {
            case 1: {
                sink.section1_();
                break;
            }
            case 2: {
                sink.section2_();
                break;
            }
            case 3: {
                sink.section3_();
                break;
            }
            case 4: {
                sink.section4_();
                break;
            }
            case 5: {
                sink.section5_();
            }
        }
    }

    private void startSection(int level, Sink sink) {
        switch (level) {
            case 0: {
                sink.section1();
                break;
            }
            case 1: {
                sink.section2();
                break;
            }
            case 2: {
                sink.section3();
                break;
            }
            case 3: {
                sink.section4();
                break;
            }
            case 4: {
                sink.section5();
            }
        }
    }

    private void closeSectionTitle(int level, Sink sink) {
        switch (level) {
            case 0: {
                sink.sectionTitle1_();
                break;
            }
            case 1: {
                sink.sectionTitle2_();
                break;
            }
            case 2: {
                sink.sectionTitle3_();
                break;
            }
            case 3: {
                sink.sectionTitle4_();
                break;
            }
            case 4: {
                sink.sectionTitle5_();
            }
        }
    }

    private void startSectionTitle(int level, Sink sink) {
        switch (level) {
            case 0: {
                sink.sectionTitle1();
                break;
            }
            case 1: {
                sink.sectionTitle2();
                break;
            }
            case 2: {
                sink.sectionTitle3();
                break;
            }
            case 3: {
                sink.sectionTitle4();
                break;
            }
            case 4: {
                sink.sectionTitle5();
            }
        }
    }
}

