/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.help;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.help.AbstractHelpMojo;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="active-profiles", aggregator=true)
public class ActiveProfilesMojo
extends AbstractHelpMojo {
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> projects;

    public void execute() throws MojoExecutionException {
        StringBuilder message = new StringBuilder();
        for (MavenProject project : this.projects) {
            this.getActiveProfileStatement(project, message);
            message.append("\n\n");
        }
        if (this.output != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Created by: " + ((Object)((Object)this)).getClass().getName()).append("\n");
            sb.append("Created on: " + new Date()).append("\n").append("\n");
            sb.append(message.toString());
            try {
                ActiveProfilesMojo.writeFile(this.output, sb);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot write active profiles to output: " + this.output, (Exception)e);
            }
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Active profile report written to: " + this.output));
            }
        } else if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)message);
        }
    }

    private void getActiveProfileStatement(MavenProject project, StringBuilder message) {
        LinkedHashMap<String, List<String>> activeProfileIds = new LinkedHashMap<String, List<String>>();
        try {
            activeProfileIds.putAll(this.getInjectedProfileIds(project));
        }
        catch (UnsupportedOperationException uoe) {
            ArrayList profiles = new ArrayList(project.getActiveProfiles());
            for (Profile profile : profiles) {
                ArrayList<String> profileIds = (ArrayList<String>)activeProfileIds.get(profile.getSource());
                if (profileIds == null) {
                    profileIds = new ArrayList<String>();
                    activeProfileIds.put(profile.getSource(), profileIds);
                }
                profileIds.add(profile.getId());
            }
        }
        message.append("\n");
        message.append("Active Profiles for Project '" + project.getId() + "': \n\n");
        if (activeProfileIds.isEmpty()) {
            message.append("There are no active profiles.");
        } else {
            message.append("The following profiles are active:\n");
            for (Map.Entry entry : activeProfileIds.entrySet()) {
                for (String profileId : (List)entry.getValue()) {
                    message.append("\n - ").append(profileId);
                    message.append(" (source: ").append((String)entry.getKey()).append(")");
                }
            }
        }
        message.append("\n");
    }

    private Map<String, List<String>> getInjectedProfileIds(MavenProject project) throws UnsupportedOperationException {
        try {
            Method getInjectedProfileIdsMethod = MavenProject.class.getMethod("getInjectedProfileIds", new Class[0]);
            return (Map)getInjectedProfileIdsMethod.invoke((Object)project, new Object[0]);
        }
        catch (SecurityException e) {
            throw new UnsupportedOperationException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException(e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException(e.getMessage(), e);
        }
    }
}

