/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.idlj;

import [Ljava.lang.String;;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.idlj.AbstractTranslator;
import org.codehaus.mojo.idlj.CompilerTranslator;
import org.codehaus.mojo.idlj.Define;
import org.codehaus.mojo.idlj.PackagePrefix;
import org.codehaus.mojo.idlj.Source;
import org.codehaus.plexus.util.StringOutputStream;
import org.codehaus.plexus.util.StringUtils;

public class IdljTranslator
extends AbstractTranslator
implements CompilerTranslator {
    public void invokeCompiler(String sourceDirectory, File[] includeDirs, String targetDirectory, String idlFile, Source source) throws MojoExecutionException {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add("-i");
        args.add(sourceDirectory);
        if (includeDirs != null && includeDirs.length > 0) {
            for (int i = 0; i < includeDirs.length; ++i) {
                args.add("-i");
                args.add(includeDirs[i]);
            }
        }
        args.add("-td");
        args.add(IdljTranslator.toRelativeAndFixSeparator(new File(System.getProperty("user.dir")), new File(targetDirectory), false));
        if (source.getPackagePrefix() != null) {
            throw new MojoExecutionException("idlj compiler does not support packagePrefix");
        }
        if (source.getPackagePrefixes() != null) {
            Iterator prefixes = source.getPackagePrefixes().iterator();
            while (prefixes.hasNext()) {
                PackagePrefix prefix = (PackagePrefix)prefixes.next();
                args.add("-pkgPrefix");
                args.add(prefix.getType());
                args.add(prefix.getPrefix());
            }
        }
        if (source.getDefines() != null) {
            Iterator defs = source.getDefines().iterator();
            while (defs.hasNext()) {
                Define define = (Define)defs.next();
                if (define.getValue() != null) {
                    throw new MojoExecutionException("idlj compiler unable to define symbol values");
                }
                args.add("-d");
                args.add(define.getSymbol());
            }
        }
        if (source.emitStubs() != null && source.emitStubs().booleanValue()) {
            if (source.emitSkeletons().booleanValue()) {
                args.add("-fall");
            } else {
                args.add("-fclient");
            }
        } else if (source.emitSkeletons() != null && source.emitSkeletons().booleanValue()) {
            args.add("-fserver");
        } else {
            args.add("-fserverTIE");
        }
        if (source.compatible() != null && source.compatible().booleanValue()) {
            String version = System.getProperty("java.specification.version");
            this.getLog().debug((CharSequence)("JDK Version:" + version));
            if (version.matches("^[0-1]\\.[0-3]")) {
                this.getLog().debug((CharSequence)"OPTION IGNORED: compatible");
            } else {
                args.add("-oldImplBase");
            }
        }
        if (source.getAdditionalArguments() != null) {
            Iterator it = source.getAdditionalArguments().iterator();
            while (it.hasNext()) {
                args.add(it.next());
            }
        }
        args.add(idlFile);
        Class compilerClass = this.getCompilerClass();
        this.invokeCompiler(compilerClass, args);
    }

    private Class getCompilerClass() throws MojoExecutionException {
        Class<?> idljCompiler;
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            idljCompiler = Class.forName(this.getIDLCompilerClass());
        }
        catch (ClassNotFoundException e) {
            try {
                File javaHome = new File(System.getProperty("java.home"));
                File toolsJar = new File(javaHome, "../lib/tools.jar");
                URL toolsJarUrl = toolsJar.toURL();
                URLClassLoader urlLoader = new URLClassLoader(new URL[]{toolsJarUrl}, cl);
                System.setProperty("java.class.path", System.getProperty("java.class.path") + System.getProperty("path.separator") + toolsJar.getAbsolutePath());
                if (System.getProperty("java.vm.name").indexOf("HotSpot") != -1) {
                    urlLoader.loadClass("com.sun.tools.corba.se.idl.som.cff.FileLocator");
                }
                idljCompiler = urlLoader.loadClass(this.getIDLCompilerClass());
            }
            catch (Exception notUsed) {
                throw new MojoExecutionException(" IDL compiler not available", (Exception)e);
            }
        }
        return idljCompiler;
    }

    private String getIDLCompilerClass() {
        String vendor = System.getProperty("java.vm.vendor");
        if (vendor.indexOf("IBM") != -1) {
            return "com.ibm.idl.toJavaPortable.Compile";
        }
        return "com.sun.tools.corba.se.idl.toJavaPortable.Compile";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void invokeCompiler(Class compilerClass, List args) throws MojoExecutionException {
        StringOutputStream out;
        StringOutputStream err;
        PrintStream stdOut;
        PrintStream stdErr;
        int exitCode;
        block17: {
            Method compilerMainMethod;
            String[] arguments;
            this.getLog().debug((CharSequence)("Current dir : " + System.getProperty("user.dir")));
            if (this.isDebug()) {
                args.add(0, "-verbose");
                arguments = args.toArray(new String[args.size()]);
                String command = compilerClass.getName();
                for (int i = 0; i < arguments.length; ++i) {
                    command = command + " " + arguments[i];
                }
                this.getLog().info((CharSequence)command);
            } else {
                arguments = args.toArray(new String[args.size()]);
            }
            try {
                compilerMainMethod = compilerClass.getMethod("main", String;.class);
            }
            catch (NoSuchMethodException e1) {
                throw new MojoExecutionException("Error: Compiler had no main method");
            }
            exitCode = 0;
            stdErr = System.err;
            stdOut = System.out;
            err = new StringOutputStream();
            out = new StringOutputStream();
            System.setErr(new PrintStream((OutputStream)err));
            System.setOut(new PrintStream((OutputStream)out));
            try {
                try {
                    Object retVal = compilerMainMethod.invoke((Object)compilerClass, new Object[]{arguments});
                    if (retVal != null && retVal instanceof Integer) {
                        exitCode = (Integer)retVal;
                    }
                }
                catch (InvocationTargetException e) {
                    throw new MojoExecutionException("IDL compilation failed", e.getTargetException());
                }
                catch (Throwable e) {
                    throw new MojoExecutionException("IDL compilation failed", e);
                }
                Object var12_16 = null;
                if ("".equals(out.toString())) break block17;
            }
            catch (Throwable throwable) {
                Object var12_17 = null;
                if (!"".equals(out.toString())) {
                    this.getLog().info((CharSequence)out.toString());
                }
                if (!"".equals(err.toString())) {
                    this.getLog().error((CharSequence)err.toString());
                }
                System.setErr(stdErr);
                System.setOut(stdOut);
                throw throwable;
            }
            this.getLog().info((CharSequence)out.toString());
        }
        if (!"".equals(err.toString())) {
            this.getLog().error((CharSequence)err.toString());
        }
        System.setErr(stdErr);
        System.setOut(stdOut);
        if (!"".equals(out.toString())) {
            this.getLog().info((CharSequence)out.toString());
        }
        if (!"".equals(err.toString())) {
            this.getLog().error((CharSequence)err.toString());
        }
        System.setErr(stdErr);
        System.setOut(stdOut);
        if (this.isFailOnError() && (exitCode != 0 || err.toString().indexOf("Invalid argument") != -1)) {
            throw new MojoExecutionException("IDL compilation failed");
        }
    }

    public static String fixSeparator(String filename) {
        return StringUtils.replace((String)filename, (char)'\\', (char)'/');
    }

    public static String getCanonicalPath(File file) throws MojoExecutionException {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't canonicalize system path: " + file.getAbsolutePath(), (Exception)e);
        }
    }

    public static String toRelativeAndFixSeparator(File fromdir, File todir, boolean replaceSlashesWithDashes) throws MojoExecutionException {
        if (!todir.isAbsolute()) {
            todir = new File(fromdir, todir.getPath());
        }
        String basedirPath = IdljTranslator.getCanonicalPath(fromdir);
        String absolutePath = IdljTranslator.getCanonicalPath(todir);
        String relative = null;
        if (absolutePath.equals(basedirPath)) {
            relative = ".";
        } else if (absolutePath.startsWith(basedirPath)) {
            int length = basedirPath.length() + 1;
            if (basedirPath.endsWith("\\")) {
                --length;
            }
            relative = absolutePath.substring(length);
        } else {
            relative = absolutePath;
        }
        relative = IdljTranslator.fixSeparator(relative);
        if (replaceSlashesWithDashes) {
            relative = StringUtils.replace((String)relative, (char)'/', (char)'-');
            relative = StringUtils.replace((String)relative, (char)':', (char)'-');
        }
        return relative;
    }
}

