/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.ant;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.filters.StringInputStream;
import org.jbehave.core.ConfigurableEmbedder;
import org.jbehave.core.InjectableEmbedder;
import org.jbehave.core.embedder.Embedder;
import org.jbehave.core.embedder.EmbedderClassLoader;
import org.jbehave.core.embedder.EmbedderControls;
import org.jbehave.core.embedder.EmbedderMonitor;
import org.jbehave.core.embedder.MetaFilter;
import org.jbehave.core.embedder.UnmodifiableEmbedderControls;
import org.jbehave.core.failures.BatchFailures;
import org.jbehave.core.io.StoryFinder;
import org.jbehave.core.junit.AnnotatedEmbedderRunner;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Story;
import org.jbehave.core.model.StoryMaps;
import org.jbehave.core.reporters.ReportsCount;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEmbedderTask
extends Task {
    private static final String TEST_SCOPE = "test";
    private String sourceDirectory = "src/main/java";
    private String testSourceDirectory = "src/test/java";
    private String scope = "compile";
    private List<String> includes = new ArrayList<String>();
    private List<String> excludes = new ArrayList<String>();
    private boolean skip = false;
    private boolean ignoreFailureInStories = false;
    private boolean ignoreFailureInView = false;
    private boolean generateViewAfterStories = true;
    private boolean batch = false;
    long storyTimeoutInSecs = 300L;
    private int threads = 1;
    private String embedderClass = Embedder.class.getName();
    private String injectableEmbedderClass;
    String annotatedEmbedderRunnerClass = AnnotatedEmbedderRunner.class.getName();
    private String storyFinderClass = StoryFinder.class.getName();
    private List<String> metaFilters = Arrays.asList(new Object[0]);
    private Properties systemProperties = new Properties();
    private EmbedderClassLoader classLoader;

    private boolean isSourceTestScope() {
        return TEST_SCOPE.equals(this.scope);
    }

    String searchDirectory() {
        if (this.isSourceTestScope()) {
            return this.testSourceDirectory;
        }
        return this.sourceDirectory;
    }

    protected EmbedderClassLoader classLoader() {
        if (this.classLoader == null) {
            this.classLoader = new EmbedderClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        }
        return this.classLoader;
    }

    protected EmbedderMonitor embedderMonitor() {
        return new AntEmbedderMonitor();
    }

    protected EmbedderControls embedderControls() {
        return new UnmodifiableEmbedderControls(new EmbedderControls().doBatch(this.batch).doSkip(this.skip).doGenerateViewAfterStories(this.generateViewAfterStories).doIgnoreFailureInStories(this.ignoreFailureInStories).doIgnoreFailureInView(this.ignoreFailureInView).useStoryTimeoutInSecs(this.storyTimeoutInSecs).useThreads(this.threads));
    }

    protected List<String> storyPaths() {
        this.log("Searching for story paths including " + this.includes + " and excluding " + this.excludes, 4);
        List storyPaths = this.newStoryFinder().findPaths(this.searchDirectory(), this.includes, this.excludes);
        this.log("Found story paths: " + storyPaths, 2);
        return storyPaths;
    }

    protected List<String> classNames() {
        this.log("Searching for class names including " + this.includes + " and excluding " + this.excludes, 4);
        List classNames = this.newStoryFinder().findClassNames(this.searchDirectory(), this.includes, this.excludes);
        this.log("Found class names : " + classNames, 2);
        return classNames;
    }

    protected StoryFinder newStoryFinder() {
        return (StoryFinder)this.classLoader().newInstance(StoryFinder.class, this.storyFinderClass);
    }

    protected Embedder newEmbedder() {
        Embedder embedder = null;
        EmbedderClassLoader classLoader = this.classLoader();
        embedder = this.injectableEmbedderClass != null ? ((InjectableEmbedder)classLoader.newInstance(InjectableEmbedder.class, this.injectableEmbedderClass)).injectedEmbedder() : (Embedder)classLoader.newInstance(Embedder.class, this.embedderClass);
        embedder.useClassLoader(classLoader);
        embedder.useEmbedderControls(this.embedderControls());
        embedder.useEmbedderMonitor(this.embedderMonitor());
        if (!this.metaFilters.isEmpty()) {
            embedder.useMetaFilters(this.metaFilters);
        }
        if (!this.systemProperties.isEmpty()) {
            embedder.useSystemProperties(this.systemProperties);
        }
        return embedder;
    }

    public void setSourceDirectory(String sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public void setTestSourceDirectory(String testSourceDirectory) {
        this.testSourceDirectory = testSourceDirectory;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setIncludes(String includesCSV) {
        this.includes = Arrays.asList(includesCSV.split(","));
    }

    public void setExcludes(String excludesCSV) {
        this.excludes = Arrays.asList(excludesCSV.split(","));
    }

    public void setBatch(boolean batch) {
        this.batch = batch;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setIgnoreFailureInStories(boolean ignoreFailureInStories) {
        this.ignoreFailureInStories = ignoreFailureInStories;
    }

    public void setIgnoreFailureInView(boolean ignoreFailureInView) {
        this.ignoreFailureInView = ignoreFailureInView;
    }

    public void setGenerateViewAfterStories(boolean generateViewAfterStories) {
        this.generateViewAfterStories = generateViewAfterStories;
    }

    public void setStoryTimeoutInSecs(long storyTimeoutInSecs) {
        this.storyTimeoutInSecs = storyTimeoutInSecs;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public void setEmbedderClass(String embedderClass) {
        this.embedderClass = embedderClass;
    }

    public void setInjectableEmbedderClass(String injectableEmbedderClass) {
        this.injectableEmbedderClass = injectableEmbedderClass;
    }

    public void setAnnotatedEmbedderRunnerClass(String annotatedEmbedderRunnerClass) {
        this.annotatedEmbedderRunnerClass = annotatedEmbedderRunnerClass;
    }

    public void setStoryFinderClass(String storyFinderClass) {
        this.storyFinderClass = storyFinderClass;
    }

    public void setMetaFilters(String metaFiltersCSV) {
        this.metaFilters = Arrays.asList(metaFiltersCSV.split(","));
    }

    public void setSystemProperties(String systemPropertiesCSV) {
        this.systemProperties = this.loadProperties(systemPropertiesCSV);
    }

    private Properties loadProperties(String systemPropertiesCSV) {
        Properties properties = new Properties();
        try {
            properties.load((InputStream)new StringInputStream(systemPropertiesCSV.replace(",", "\n")));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AntEmbedderMonitor
    implements EmbedderMonitor {
        protected AntEmbedderMonitor() {
        }

        public void batchFailed(BatchFailures failures) {
            AbstractEmbedderTask.this.log("Failed to run batch " + failures, 1);
        }

        public void beforeOrAfterStoriesFailed() {
            AbstractEmbedderTask.this.log("Failed to run before or after stories steps", 1);
        }

        public void embeddableFailed(String name, Throwable cause) {
            AbstractEmbedderTask.this.log("Failed to run embeddable " + name, cause, 1);
        }

        public void embeddableNotConfigurable(String name) {
            AbstractEmbedderTask.this.log("Embeddable " + name + " must be an instance of " + ConfigurableEmbedder.class, 1);
        }

        public void embeddablesSkipped(List<String> classNames) {
            AbstractEmbedderTask.this.log("Skipped embeddables " + classNames, 2);
        }

        public void metaNotAllowed(Meta meta, MetaFilter filter) {
            AbstractEmbedderTask.this.log(meta + " excluded by filter '" + filter.asString() + "'", 2);
        }

        public void runningEmbeddable(String name) {
            AbstractEmbedderTask.this.log("Running embeddable " + name, 2);
        }

        public void storiesSkipped(List<String> storyPaths) {
            AbstractEmbedderTask.this.log("Skipped stories " + storyPaths, 2);
        }

        public void storyFailed(String path, Throwable cause) {
            AbstractEmbedderTask.this.log("Failed to run story " + path, cause, 1);
        }

        public void runningStory(String path) {
            AbstractEmbedderTask.this.log("Running story " + path, 2);
        }

        public void runningWithAnnotatedEmbedderRunner(String className) {
            AbstractEmbedderTask.this.log("Running with AnnotatedEmbedderRunner '" + className + "'", 2);
        }

        public void annotatedInstanceNotOfType(Object annotatedInstance, Class<?> type) {
            AbstractEmbedderTask.this.log("Annotated instance " + annotatedInstance + " not of type " + type, 1);
        }

        public void generatingReportsView(File outputDirectory, List<String> formats, Properties viewProperties) {
            AbstractEmbedderTask.this.log("Generating reports view to '" + outputDirectory + "' using formats '" + formats + "'" + " and view properties '" + viewProperties + "'", 2);
        }

        public void reportsViewGenerationFailed(File outputDirectory, List<String> formats, Properties viewProperties, Throwable cause) {
            AbstractEmbedderTask.this.log("Failed to generate reports view to '" + outputDirectory + "' using formats '" + formats + "'" + " and view properties '" + viewProperties + "'", cause, 1);
        }

        public void reportsViewGenerated(ReportsCount count) {
            AbstractEmbedderTask.this.log("Reports view generated with " + count.getStories() + " stories (of which " + count.getStoriesPending() + " pending) containing " + "" + count.getScenarios() + " scenarios (of which  " + count.getScenariosFailed() + " failed and " + count.getScenariosPending() + " pending)", 2);
            if (count.getStoriesNotAllowed() > 0 || count.getScenariosNotAllowed() > 0) {
                AbstractEmbedderTask.this.log("Meta filters did not allow " + count.getStoriesNotAllowed() + " stories and  " + count.getScenariosNotAllowed() + " scenarios", 2);
            }
        }

        public void reportsViewNotGenerated() {
            AbstractEmbedderTask.this.log("Reports view not generated", 2);
        }

        public void mappingStory(String storyPath, List<String> metaFilters) {
            AbstractEmbedderTask.this.log("Mapping story " + storyPath + " with meta filters " + metaFilters, 2);
        }

        public void generatingMapsView(File outputDirectory, StoryMaps storyMaps, Properties viewProperties) {
            AbstractEmbedderTask.this.log("Generating maps view to '" + outputDirectory + "' using story maps '" + storyMaps + "'" + " and view properties '" + viewProperties + "'", 2);
        }

        public void mapsViewGenerationFailed(File outputDirectory, StoryMaps storyMaps, Properties viewProperties, Throwable cause) {
            AbstractEmbedderTask.this.log("Failed to generate maps view to '" + outputDirectory + "' using story maps '" + storyMaps + "'" + " and view properties '" + viewProperties + "'", cause, 1);
        }

        public void generatingNavigatorView(File outputDirectory, Properties viewProperties) {
            AbstractEmbedderTask.this.log("Generating navigator view to '" + outputDirectory + "' using  properties '" + viewProperties + "'", 2);
        }

        public void navigatorViewGenerationFailed(File outputDirectory, Properties viewProperties, Throwable cause) {
            AbstractEmbedderTask.this.log("Failed to generating navigator view to '" + outputDirectory + "' using  properties '" + viewProperties + "'", cause, 1);
        }

        public void navigatorViewNotGenerated() {
            AbstractEmbedderTask.this.log("Navigator view not generated, as the CrossReference has not been declared in the StoryReporterBuilder", 1);
        }

        public void processingSystemProperties(Properties properties) {
            AbstractEmbedderTask.this.log("Processing system properties " + properties, 2);
        }

        public void systemPropertySet(String name, String value) {
            AbstractEmbedderTask.this.log("System property '" + name + "' set to '" + value + "'", 2);
        }

        public void storyTimeout(long durationInSecs, Story story) {
            AbstractEmbedderTask.this.log("Story " + story.getPath() + " has timed out after " + durationInSecs + " seconds", 2);
        }

        public void usingThreads(int threads) {
            AbstractEmbedderTask.this.log("Using " + threads + " threads", 2);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }
}

