/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.plugins.providers.multipart.AbstractMultipartWriter;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;
import org.jboss.resteasy.plugins.providers.multipart.MultipartOutput;
import org.jboss.resteasy.plugins.providers.multipart.OutputPart;
import org.jboss.resteasy.plugins.providers.multipart.i18n.Messages;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.spi.AsyncOutputStream;

public class AbstractMultipartFormDataWriter
extends AbstractMultipartWriter {
    @Override
    protected void writeParts(MultipartOutput multipartOutput, OutputStream entityStream, byte[] boundaryBytes, Annotation[] annotations) throws IOException {
        if (!(multipartOutput instanceof MultipartFormDataOutput)) {
            throw new IllegalArgumentException(Messages.MESSAGES.hadToWriteMultipartOutput(multipartOutput, this, MultipartFormDataOutput.class));
        }
        MultipartFormDataOutput form = (MultipartFormDataOutput)multipartOutput;
        for (Map.Entry<String, List<OutputPart>> entry : form.getFormDataMap().entrySet()) {
            for (OutputPart outputPart : entry.getValue()) {
                if (outputPart.getEntity() == null) continue;
                MultivaluedMapImpl headers = new MultivaluedMapImpl();
                headers.putSingle((Object)"Content-Disposition", (Object)("form-data; name=\"" + entry.getKey() + "\"" + this.getFilename(outputPart)));
                this.writePart(entityStream, boundaryBytes, outputPart, (MultivaluedMap<String, Object>)headers, annotations);
            }
        }
    }

    @Override
    protected CompletionStage<Void> asyncWriteParts(MultipartOutput multipartOutput, AsyncOutputStream entityStream, byte[] boundaryBytes, Annotation[] annotations) {
        if (!(multipartOutput instanceof MultipartFormDataOutput)) {
            throw new IllegalArgumentException(Messages.MESSAGES.hadToWriteMultipartOutput(multipartOutput, this, MultipartFormDataOutput.class));
        }
        MultipartFormDataOutput form = (MultipartFormDataOutput)multipartOutput;
        CompletionStage<Object> ret = CompletableFuture.completedFuture(null);
        for (Map.Entry<String, List<OutputPart>> entry : form.getFormDataMap().entrySet()) {
            for (OutputPart outputPart : entry.getValue()) {
                if (outputPart.getEntity() == null) continue;
                MultivaluedMapImpl headers = new MultivaluedMapImpl();
                headers.putSingle((Object)"Content-Disposition", (Object)("form-data; name=\"" + entry.getKey() + "\"" + this.getFilename(outputPart)));
                ret = ret.thenCompose(arg_0 -> this.lambda$asyncWriteParts$0(entityStream, boundaryBytes, outputPart, (MultivaluedMap)headers, annotations, arg_0));
            }
        }
        return ret;
    }

    private String getFilename(OutputPart part) {
        String filename = part.getFilename();
        if (filename == null) {
            return "";
        }
        if (part.isUtf8Encode()) {
            String encodedFilename = filename;
            try {
                encodedFilename = URLEncoder.encode(filename, "UTF-8");
                if (!encodedFilename.equals(filename)) {
                    return "; filename*=utf-8''" + encodedFilename.replaceAll("\\+", "%20");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return "; filename=\"" + filename + "\"";
    }

    private /* synthetic */ CompletionStage lambda$asyncWriteParts$0(AsyncOutputStream entityStream, byte[] boundaryBytes, OutputPart outputPart, MultivaluedMap headers, Annotation[] annotations, Void v) {
        return this.asyncWritePart(entityStream, boundaryBytes, outputPart, (MultivaluedMap<String, Object>)headers, annotations);
    }
}

