/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.generate;

import java.util.HashSet;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.generate.GraphGenerator;

public class CompleteBipartiteGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    private final int sizeA;
    private final int sizeB;

    public CompleteBipartiteGraphGenerator(int partitionOne, int partitionTwo) {
        if (partitionOne < 0 || partitionTwo < 0) {
            throw new IllegalArgumentException("partition sizes must be non-negative");
        }
        this.sizeA = partitionOne;
        this.sizeB = partitionTwo;
    }

    @Override
    public void generateGraph(Graph<V, E> target, Map<String, V> resultMap) {
        int i;
        if (this.sizeA < 1 && this.sizeB < 1) {
            return;
        }
        HashSet<V> a = new HashSet<V>();
        HashSet<V> b = new HashSet<V>();
        for (i = 0; i < this.sizeA; ++i) {
            a.add(target.addVertex());
        }
        for (i = 0; i < this.sizeB; ++i) {
            b.add(target.addVertex());
        }
        for (Object u : a) {
            for (Object v : b) {
                target.addEdge(u, v);
            }
        }
    }
}

