/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.mockserver.collections.NottableStringMultiMap;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.matchers.NotMatcher;
import org.mockserver.model.KeyToMultiValue;
import org.mockserver.model.KeysToMultiValues;

public class MultiValueMapMatcher
extends NotMatcher<KeysToMultiValues<? extends KeyToMultiValue, ? extends KeysToMultiValues>> {
    private static final String[] EXCLUDED_FIELDS = new String[]{"mockServerLogger"};
    private final MockServerLogger mockServerLogger;
    private final NottableStringMultiMap matcher;
    private final KeysToMultiValues keysToMultiValues;
    private final boolean controlPlaneMatcher;
    private Boolean allKeysNotted;
    private Boolean allKeysOptional;

    MultiValueMapMatcher(MockServerLogger mockServerLogger, KeysToMultiValues<? extends KeyToMultiValue, ? extends KeysToMultiValues> keysToMultiValues, boolean controlPlaneMatcher) {
        this.mockServerLogger = mockServerLogger;
        this.keysToMultiValues = keysToMultiValues;
        this.controlPlaneMatcher = controlPlaneMatcher;
        this.matcher = keysToMultiValues != null ? new NottableStringMultiMap(this.mockServerLogger, this.controlPlaneMatcher, keysToMultiValues.getKeyMatchStyle(), keysToMultiValues.getEntries()) : null;
    }

    @Override
    public boolean matches(MatchDifference context, KeysToMultiValues<? extends KeyToMultiValue, ? extends KeysToMultiValues> matched) {
        boolean result;
        if (this.matcher == null || this.matcher.isEmpty()) {
            result = true;
        } else if (matched == null || matched.isEmpty()) {
            if (this.allKeysNotted == null) {
                this.allKeysNotted = this.matcher.allKeysNotted();
            }
            if (this.allKeysOptional == null) {
                this.allKeysOptional = this.matcher.allKeysOptional();
            }
            result = this.allKeysNotted != false || this.allKeysOptional != false;
        } else {
            result = new NottableStringMultiMap(this.mockServerLogger, this.controlPlaneMatcher, matched.getKeyMatchStyle(), matched.getEntries()).containsAll(this.matcher);
        }
        if (!result && context != null) {
            context.addDifference(this.mockServerLogger, "multimap subset match failed expected:{}found:{}failed because:{}", this.keysToMultiValues, matched != null ? matched : "none", matched != null ? "multimap is not a subset" : "none is not a subset");
        }
        return this.not != result;
    }

    @Override
    public boolean isBlank() {
        return this.matcher == null || this.matcher.isEmpty();
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

