/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.memory;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.mockserver.character.Character;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.log.MockServerEventLog;
import org.mockserver.memory.Summary;
import org.mockserver.mock.RequestMatchers;
import org.mockserver.mock.listeners.MockServerLogListener;
import org.mockserver.mock.listeners.MockServerMatcherListener;
import org.mockserver.mock.listeners.MockServerMatcherNotifier;

public class MemoryMonitoring
implements MockServerLogListener,
MockServerMatcherListener {
    private static final AtomicInteger memoryUpdateFrequency = new AtomicInteger(0);
    private static final AtomicInteger currentLogEntriesCount = new AtomicInteger(0);
    private static final AtomicInteger currentExpectationsCount = new AtomicInteger(0);
    private static final List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
    private static final String CSV_FILE = "memoryUsage_" + new SimpleDateFormat("yyyy-MM-dd").format(new Date()) + ".csv";
    private static final int MAX_LOG_ENTRIES_UPPER_LIMIT = 60000;
    private static final int MAX_EXPECTATIONS_UPPER_LIMIT = 5000;

    private static void writeLineToCsv(String line) {
        try {
            FileOutputStream rawFileOutputStream = new FileOutputStream(CSV_FILE, true);
            rawFileOutputStream.write((line + Character.NEW_LINE).getBytes(StandardCharsets.UTF_8));
            rawFileOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public MemoryMonitoring() {
        this(null, null);
    }

    public MemoryMonitoring(MockServerEventLog mockServerLog, RequestMatchers requestMatchers) {
        if (mockServerLog != null) {
            mockServerLog.registerListener(this);
        }
        if (requestMatchers != null) {
            requestMatchers.registerListener(this);
        }
    }

    private static Summary getJVMMemory(MemoryType heap) {
        return new Summary(memoryPoolMXBeans.stream().filter(bean -> bean.getType() == heap).collect(Collectors.toList()));
    }

    public long remainingHeapKB() {
        Summary heap = MemoryMonitoring.getJVMMemory(MemoryType.HEAP);
        return (heap.getNet().getMax() - heap.getNet().getUsed()) / 1024L;
    }

    public void logMemoryMetrics() {
        if (ConfigurationProperties.outputMemoryUsageCsv()) {
            String line = MemoryMonitoring.buildStatistics().stream().map(Pair::getValue).map(String::valueOf).collect(Collectors.joining(","));
            MemoryMonitoring.writeLineToCsv(line);
        }
    }

    private static List<ImmutablePair<String, Object>> buildStatistics() {
        Summary heap = MemoryMonitoring.getJVMMemory(MemoryType.HEAP);
        Summary nonHeap = MemoryMonitoring.getJVMMemory(MemoryType.NON_HEAP);
        ArrayList<ImmutablePair<String, Object>> memoryStatistics = new ArrayList<ImmutablePair<String, Object>>();
        memoryStatistics.add(ImmutablePair.of((Object)"eventLogSize", (Object)currentLogEntriesCount.get()));
        memoryStatistics.add(ImmutablePair.of((Object)"maxLogEntries", (Object)ConfigurationProperties.maxLogEntries()));
        memoryStatistics.add(ImmutablePair.of((Object)"expectationsSize", (Object)currentExpectationsCount.get()));
        memoryStatistics.add(ImmutablePair.of((Object)"maxExpectations", (Object)ConfigurationProperties.maxExpectations()));
        memoryStatistics.add(ImmutablePair.of((Object)"heapInitialAllocation", (Object)heap.getNet().getInit()));
        memoryStatistics.add(ImmutablePair.of((Object)"heapUsed", (Object)heap.getNet().getUsed()));
        memoryStatistics.add(ImmutablePair.of((Object)"heapCommitted", (Object)heap.getNet().getCommitted()));
        memoryStatistics.add(ImmutablePair.of((Object)"heapMaxAllowed", (Object)heap.getNet().getMax()));
        memoryStatistics.add(ImmutablePair.of((Object)"nonHeapInitialAllocation", (Object)nonHeap.getNet().getInit()));
        memoryStatistics.add(ImmutablePair.of((Object)"nonHeapUsed", (Object)nonHeap.getNet().getUsed()));
        memoryStatistics.add(ImmutablePair.of((Object)"nonHeapCommitted", (Object)nonHeap.getNet().getCommitted()));
        memoryStatistics.add(ImmutablePair.of((Object)"nonHeapMaxAllowed", (Object)nonHeap.getNet().getMax()));
        return memoryStatistics;
    }

    public int startingMaxLogEntries() {
        return Math.min((int)(this.remainingHeapKB() / 30L), 60000);
    }

    public int adjustedMaxLogEntries() {
        return Math.min(this.startingMaxLogEntries() + currentLogEntriesCount.get() / 2, 60000);
    }

    public int startingMaxExpectations() {
        return Math.min((int)(this.remainingHeapKB() / 400L), 5000);
    }

    public int adjustedMaxExpectations() {
        return Math.min(this.startingMaxExpectations() + currentExpectationsCount.get() / 2, 5000);
    }

    @Override
    public void updated(MockServerEventLog mockServerLog) {
        currentLogEntriesCount.set(mockServerLog.size());
        if (this.shouldUpdate()) {
            this.updateMemoryUsageMaximums();
            mockServerLog.setMaxSize(ConfigurationProperties.maxLogEntries());
        }
    }

    @Override
    public void updated(RequestMatchers requestMatchers, MockServerMatcherNotifier.Cause cause) {
        currentExpectationsCount.set(requestMatchers.size());
        if (this.shouldUpdate()) {
            this.updateMemoryUsageMaximums();
            requestMatchers.setMaxSize(ConfigurationProperties.maxExpectations());
        }
    }

    private boolean shouldUpdate() {
        return memoryUpdateFrequency.incrementAndGet() % 500 == 0;
    }

    public void updateMemoryUsageMaximums() {
        ConfigurationProperties.defaultMaxExpectations(this.adjustedMaxExpectations());
        ConfigurationProperties.defaultMaxLogEntries(this.adjustedMaxLogEntries());
        this.logMemoryMetrics();
    }

    static {
        if (ConfigurationProperties.outputMemoryUsageCsv() && !new File(CSV_FILE).exists()) {
            String line = MemoryMonitoring.buildStatistics().stream().map(Pair::getKey).collect(Collectors.joining(","));
            MemoryMonitoring.writeLineToCsv(line);
        }
    }
}

