/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.persistence;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.file.FileReader;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.RequestMatchers;
import org.mockserver.mock.listeners.MockServerMatcherNotifier;
import org.mockserver.persistence.FileWatcher;
import org.mockserver.serialization.ExpectationSerializer;
import org.slf4j.event.Level;

public class ExpectationFileWatcher {
    private final ExpectationSerializer expectationSerializer;
    private final MockServerLogger mockServerLogger;
    private final RequestMatchers requestMatchers;
    private FileWatcher fileWatcher;

    public ExpectationFileWatcher(MockServerLogger mockServerLogger, RequestMatchers requestMatchers) {
        if (ConfigurationProperties.watchInitializationJson()) {
            this.expectationSerializer = new ExpectationSerializer(mockServerLogger);
            this.mockServerLogger = mockServerLogger;
            this.requestMatchers = requestMatchers;
            try {
                this.fileWatcher = new FileWatcher(ConfigurationProperties.initializationJsonPath(), () -> {
                    if (MockServerLogger.isEnabled(Level.DEBUG)) {
                        mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("expectation file watcher updating expectations as modification detected on file{}").setArguments(ConfigurationProperties.initializationJsonPath()));
                    }
                    this.addExpectationsFromInitializer();
                }, throwable -> {
                    if (MockServerLogger.isEnabled(Level.WARN)) {
                        mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.WARN).setMessageFormat("exception while processing expectation file update " + throwable.getMessage()).setThrowable((Throwable)throwable));
                    }
                });
            }
            catch (Throwable throwable2) {
                mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception creating file watcher for{}").setArguments(ConfigurationProperties.initializationJsonPath()).setThrowable(throwable2));
            }
            if (MockServerLogger.isEnabled(Level.INFO)) {
                mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.INFO).setMessageFormat("created expectation file watcher for{}").setArguments(ConfigurationProperties.initializationJsonPath()));
            }
        } else {
            this.expectationSerializer = null;
            this.mockServerLogger = null;
            this.requestMatchers = null;
        }
    }

    private void addExpectationsFromInitializer() {
        Expectation[] expectations = this.retrieveExpectationsFromJson();
        if (MockServerLogger.isEnabled(Level.TRACE)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("updating expectations{}from{}").setArguments(ConfigurationProperties.initializationJsonPath(), Arrays.asList(expectations)));
        }
        this.requestMatchers.update(expectations, MockServerMatcherNotifier.Cause.FILE_WATCHER);
    }

    private Expectation[] retrieveExpectationsFromJson() {
        block4: {
            String initializationJsonPath = ConfigurationProperties.initializationJsonPath();
            if (StringUtils.isNotBlank((CharSequence)initializationJsonPath)) {
                try {
                    String jsonExpectations = FileReader.readFileFromClassPathOrPath(initializationJsonPath);
                    if (StringUtils.isNotBlank((CharSequence)jsonExpectations)) {
                        return this.expectationSerializer.deserializeArray(jsonExpectations, true);
                    }
                    return new Expectation[0];
                }
                catch (Throwable throwable) {
                    if (!MockServerLogger.isEnabled(Level.WARN)) break block4;
                    this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.SERVER_CONFIGURATION).setLogLevel(Level.WARN).setMessageFormat("exception while loading JSON initialization file with file watcher, ignoring file").setThrowable(throwable));
                }
            }
        }
        return new Expectation[0];
    }

    public void stop() {
        if (this.fileWatcher != null) {
            this.fileWatcher.setRunning(false);
        }
    }
}

