/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.serializers.request;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.model.OpenAPIDefinition;
import org.mockserver.serialization.ObjectMapperFactory;

public class OpenAPIDefinitionSerializer
extends StdSerializer<OpenAPIDefinition> {
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.createObjectMapper();

    public OpenAPIDefinitionSerializer() {
        super(OpenAPIDefinition.class);
    }

    public void serialize(OpenAPIDefinition openAPIDefinition, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        if (openAPIDefinition.getNot() != null && openAPIDefinition.getNot().booleanValue()) {
            jgen.writeBooleanField("not", openAPIDefinition.getNot().booleanValue());
        }
        if (StringUtils.isNotBlank((CharSequence)openAPIDefinition.getOperationId())) {
            jgen.writeObjectField("operationId", (Object)openAPIDefinition.getOperationId());
        }
        if (StringUtils.isNotBlank((CharSequence)openAPIDefinition.getSpecUrlOrPayload())) {
            if (openAPIDefinition.getSpecUrlOrPayload().trim().startsWith("{")) {
                jgen.writeObjectField("specUrlOrPayload", (Object)OBJECT_MAPPER.readTree(openAPIDefinition.getSpecUrlOrPayload()));
            } else {
                jgen.writeObjectField("specUrlOrPayload", (Object)openAPIDefinition.getSpecUrlOrPayload());
            }
        }
        jgen.writeEndObject();
    }
}

