/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.junit;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Field;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mockserver.client.proxy.ProxyClient;
import org.mockserver.integration.ClientAndProxy;
import org.mockserver.socket.PortFactory;

public class ProxyRule
implements TestRule {
    private static ClientAndProxy perTestSuiteClientAndProxy;
    private final Object target;
    private final Integer httpPort;
    private final boolean perTestSuite;
    private ClientAndProxyFactory clientAndProxyFactory;

    public ProxyRule(Object target) {
        this(PortFactory.findFreePort(), target);
    }

    public ProxyRule(Object target, boolean perTestSuite) {
        this(PortFactory.findFreePort(), target, perTestSuite);
    }

    public ProxyRule(Integer httpPort, Object target) {
        this(httpPort, target, false);
    }

    public ProxyRule(Integer httpPort, Object target, boolean perTestSuite) {
        this.httpPort = httpPort;
        this.target = target;
        this.perTestSuite = perTestSuite;
        this.clientAndProxyFactory = new ClientAndProxyFactory(httpPort);
    }

    public Integer getHttpPort() {
        return this.httpPort;
    }

    public Statement apply(Statement base, Description description) {
        return this.statement(base);
    }

    private Statement statement(final Statement base) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                ClientAndProxy clientAndProxy;
                if (ProxyRule.this.perTestSuite) {
                    if (perTestSuiteClientAndProxy == null) {
                        perTestSuiteClientAndProxy = ProxyRule.this.clientAndProxyFactory.newClientAndProxy();
                        Runtime.getRuntime().addShutdownHook(new Thread(){

                            @Override
                            public void run() {
                                perTestSuiteClientAndProxy.stop();
                            }
                        });
                    }
                    clientAndProxy = perTestSuiteClientAndProxy;
                } else {
                    clientAndProxy = ProxyRule.this.clientAndProxyFactory.newClientAndProxy();
                }
                ProxyRule.this.setProxyClient(ProxyRule.this.target, clientAndProxy);
                try {
                    base.evaluate();
                }
                finally {
                    if (!ProxyRule.this.perTestSuite) {
                        clientAndProxy.stop();
                    }
                }
            }
        };
    }

    private void setProxyClient(Object target, ClientAndProxy clientAndProxy) {
        for (Field field : target.getClass().getDeclaredFields()) {
            if (!field.getType().equals(ProxyClient.class)) continue;
            field.setAccessible(true);
            try {
                field.set(target, (Object)clientAndProxy);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error setting ProxyClient field on " + target.getClass().getName(), e);
            }
        }
    }

    @VisibleForTesting
    class ClientAndProxyFactory {
        private final Integer httpPort;

        public ClientAndProxyFactory(Integer httpPort) {
            this.httpPort = httpPort;
        }

        public ClientAndProxy newClientAndProxy() {
            return ClientAndProxy.startClientAndProxy(this.httpPort);
        }
    }
}

