/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.direct;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.mockserver.proxy.Proxy;
import org.mockserver.proxy.direct.DirectProxyUnificationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectProxy
implements Proxy {
    private static final Logger logger = LoggerFactory.getLogger(DirectProxy.class);
    private final SettableFuture<String> hasStarted = SettableFuture.create();
    private final EventLoopGroup bossGroup = new NioEventLoopGroup();
    private final EventLoopGroup workerGroup = new NioEventLoopGroup();
    private final Integer localPort;
    private final String remoteHost;
    private final Integer remotePort;

    public DirectProxy(final Integer localPort, final String remoteHost, final Integer remotePort) {
        if (localPort == null) {
            throw new IllegalArgumentException("Port must not be null");
        }
        if (remoteHost == null) {
            throw new IllegalArgumentException("Port must not be null");
        }
        if (remotePort == null) {
            throw new IllegalArgumentException("Port must not be null");
        }
        this.localPort = localPort;
        this.remoteHost = remoteHost;
        this.remotePort = remotePort;
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(DirectProxy.this.bossGroup, DirectProxy.this.workerGroup).option(ChannelOption.SO_BACKLOG, (Object)1024)).channel(NioServerSocketChannel.class)).childOption(ChannelOption.AUTO_READ, (Object)true).childHandler((ChannelHandler)new DirectProxyUnificationHandler()).childAttr(Proxy.HTTP_PROXY, (Object)DirectProxy.this).childAttr(Proxy.REMOTE_SOCKET, (Object)new InetSocketAddress(remoteHost, (int)remotePort)).bind(localPort.intValue()).addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (future.isSuccess()) {
                                DirectProxy.this.hasStarted.set((Object)"STARTED");
                            } else {
                                DirectProxy.this.hasStarted.setException(future.cause());
                            }
                        }
                    }).channel().closeFuture().sync();
                }
                catch (Exception ie) {
                    logger.error("Exception while running proxy channels", (Throwable)ie);
                }
                finally {
                    DirectProxy.this.bossGroup.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
                    DirectProxy.this.workerGroup.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
                }
            }
        }).start();
        try {
            this.hasStarted.get();
        }
        catch (Exception e) {
            logger.debug("Exception while waiting for proxy to complete starting up", (Throwable)e);
        }
    }

    @Override
    public void stop() {
        try {
            this.bossGroup.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
            this.workerGroup.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        catch (Exception ie) {
            logger.trace("Exception while waiting for the proxy to stop", (Throwable)ie);
        }
    }

    @Override
    public boolean isRunning() {
        if (this.hasStarted.isDone()) {
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            catch (InterruptedException e) {
                logger.trace("Exception while waiting for the proxy to confirm running status", (Throwable)e);
            }
            return !this.bossGroup.isShuttingDown() && !this.workerGroup.isShuttingDown();
        }
        return false;
    }

    public Integer getLocalPort() {
        return this.localPort;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public Integer getRemotePort() {
        return this.remotePort;
    }
}

