/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.relay;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.mockserver.logging.LoggingHandler;
import org.mockserver.proxy.http.HttpProxy;
import org.mockserver.proxy.relay.DownstreamProxyRelayHandler;
import org.mockserver.proxy.relay.UpstreamProxyRelayHandler;
import org.mockserver.proxy.unification.PortUnificationHandler;
import org.mockserver.socket.SSLFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public abstract class RelayConnectHandler<T>
extends SimpleChannelInboundHandler<T> {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void channelRead0(final ChannelHandlerContext serverCtx, final T request) throws Exception {
        Channel inboundChannel = serverCtx.channel();
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)inboundChannel.eventLoop())).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelActive(final ChannelHandlerContext clientCtx) throws Exception {
                serverCtx.channel().writeAndFlush(RelayConnectHandler.this.successResponse(request)).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture channelFuture) throws Exception {
                        RelayConnectHandler.this.removeCodecSupport(serverCtx);
                        ChannelPipeline downstreamPipeline = clientCtx.channel().pipeline();
                        if (PortUnificationHandler.isSslEnabled(serverCtx)) {
                            downstreamPipeline.addLast(new ChannelHandler[]{new SslHandler(SSLFactory.createClientSSLEngine())});
                        }
                        if (RelayConnectHandler.this.logger.isDebugEnabled()) {
                            downstreamPipeline.addLast(new ChannelHandler[]{new LoggingHandler("                -->")});
                        }
                        downstreamPipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
                        downstreamPipeline.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
                        downstreamPipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
                        downstreamPipeline.addLast(new ChannelHandler[]{new DownstreamProxyRelayHandler(serverCtx.channel(), RelayConnectHandler.this.logger)});
                        ChannelPipeline upstreamPipeline = serverCtx.channel().pipeline();
                        if (PortUnificationHandler.isSslEnabled(serverCtx)) {
                            upstreamPipeline.addLast(new ChannelHandler[]{new SslHandler(SSLFactory.createServerSSLEngine())});
                        }
                        if (RelayConnectHandler.this.logger.isDebugEnabled()) {
                            upstreamPipeline.addLast(new ChannelHandler[]{new LoggingHandler("<-- ")});
                        }
                        upstreamPipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
                        upstreamPipeline.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
                        upstreamPipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
                        upstreamPipeline.addLast(new ChannelHandler[]{new UpstreamProxyRelayHandler(clientCtx.channel(), RelayConnectHandler.this.logger)});
                    }
                });
            }
        });
        final InetSocketAddress remoteSocket = (InetSocketAddress)serverCtx.channel().attr(HttpProxy.REMOTE_SOCKET).get();
        bootstrap.connect((SocketAddress)remoteSocket).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    RelayConnectHandler.this.failure("Connection failed to 127.0.0.1:" + remoteSocket, future.cause(), serverCtx, RelayConnectHandler.this.failureResponse(request));
                }
            }
        });
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.failure("Exception caught by http proxy CONNECT handler closing pipeline", cause, ctx, this.failureResponse(null));
    }

    private void failure(String message, Throwable cause, ChannelHandlerContext ctx, Object response) {
        this.logger.warn(message, cause);
        Channel channel = ctx.channel();
        channel.writeAndFlush(response);
        if (channel.isActive()) {
            channel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    protected abstract void removeCodecSupport(ChannelHandlerContext var1);

    protected abstract Object successResponse(Object var1);

    protected abstract Object failureResponse(Object var1);
}

