/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.core.buffer;

import java.io.IOException;
import org.msgpack.core.Preconditions;
import org.msgpack.core.buffer.MessageBuffer;
import org.msgpack.core.buffer.MessageBufferInput;

public class ArrayBufferInput
implements MessageBufferInput {
    private MessageBuffer buffer;
    private boolean isRead = false;

    public ArrayBufferInput(MessageBuffer messageBuffer) {
        this.buffer = Preconditions.checkNotNull(messageBuffer, "input buffer is null");
    }

    public ArrayBufferInput(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public ArrayBufferInput(byte[] byArray, int n, int n2) {
        Preconditions.checkArgument(n + n2 <= byArray.length);
        this.buffer = MessageBuffer.wrap(Preconditions.checkNotNull(byArray, "input array is null")).slice(n, n2);
    }

    public MessageBuffer reset(MessageBuffer messageBuffer) {
        MessageBuffer messageBuffer2 = this.buffer;
        this.buffer = messageBuffer;
        this.isRead = false;
        return messageBuffer2;
    }

    public void reset(byte[] byArray) {
        this.reset(MessageBuffer.wrap(Preconditions.checkNotNull(byArray, "input array is null")));
    }

    public void reset(byte[] byArray, int n, int n2) {
        this.reset(MessageBuffer.wrap(Preconditions.checkNotNull(byArray, "input array is null")).slice(n, n2));
    }

    @Override
    public MessageBuffer next() throws IOException {
        if (this.isRead) {
            return null;
        }
        this.isRead = true;
        return this.buffer;
    }

    @Override
    public void close() throws IOException {
        this.buffer = null;
        this.isRead = false;
    }
}

