/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.ajaxerrorhandler;

import java.util.LinkedList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import org.apache.commons.lang3.StringUtils;
import org.primefaces.extensions.component.ajaxerrorhandler.AjaxErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxErrorHandlerVisitCallback
implements VisitCallback {
    private List<AjaxErrorHandler> defaultAjaxErrorHandler = new LinkedList<AjaxErrorHandler>();
    private List<AjaxErrorHandler> typeAjaxErrorHandler = new LinkedList<AjaxErrorHandler>();
    private String type;
    private String timestampFormat;
    private UIComponent facetTitle = null;
    private UIComponent facetBody = null;
    private List<UIComponent> customContent = null;
    private boolean resolved = false;

    public AjaxErrorHandlerVisitCallback(String type) {
        this.type = type;
    }

    public void resolveFacetsAndCustomContent() {
        if (this.resolved) {
            return;
        }
        this.resolved = true;
        this.facetTitle = null;
        this.facetBody = null;
        this.customContent = null;
        this.timestampFormat = null;
        LinkedList<AjaxErrorHandler> ajaxErrorHandlers = new LinkedList<AjaxErrorHandler>(this.defaultAjaxErrorHandler);
        ajaxErrorHandlers.addAll(this.typeAjaxErrorHandler);
        for (AjaxErrorHandler ajaxErrorHandler : ajaxErrorHandlers) {
            boolean isCustomContentRedefined;
            if (ajaxErrorHandler.getChildCount() > 0) {
                this.facetBody = null;
                this.facetTitle = null;
                this.customContent = ajaxErrorHandler.getChildren();
                continue;
            }
            boolean bl = isCustomContentRedefined = ajaxErrorHandler.getTitle() != null || ajaxErrorHandler.getFacet(AjaxErrorHandler.PropertyKeys.title.toString()) != null || ajaxErrorHandler.getBody() != null || ajaxErrorHandler.getFacet(AjaxErrorHandler.PropertyKeys.body.toString()) != null || ajaxErrorHandler.getButton() != null || ajaxErrorHandler.getButtonOnclick() != null;
            if (isCustomContentRedefined) {
                this.customContent = null;
            }
            if (ajaxErrorHandler.getTimestampFormat() != null) {
                this.timestampFormat = ajaxErrorHandler.getTimestampFormat();
            }
            if (ajaxErrorHandler.getTitle() != null) {
                this.facetTitle = null;
            }
            if (ajaxErrorHandler.getFacet(AjaxErrorHandler.PropertyKeys.title.toString()) != null) {
                this.facetTitle = ajaxErrorHandler.getFacet(AjaxErrorHandler.PropertyKeys.title.toString());
            }
            if (ajaxErrorHandler.getBody() != null) {
                this.facetBody = null;
            }
            if (ajaxErrorHandler.getFacet(AjaxErrorHandler.PropertyKeys.body.toString()) == null) continue;
            this.facetBody = ajaxErrorHandler.getFacet(AjaxErrorHandler.PropertyKeys.body.toString());
        }
    }

    public String getTimestampFormat() {
        this.resolveFacetsAndCustomContent();
        return this.timestampFormat;
    }

    public UIComponent findCurrentTitleFacet() {
        this.resolveFacetsAndCustomContent();
        return this.facetTitle;
    }

    public AjaxErrorHandlerVisitCallback() {
    }

    public UIComponent findCurrentBodyFacet() {
        this.resolveFacetsAndCustomContent();
        return this.facetBody;
    }

    public List<UIComponent> findCurrentChildren() {
        this.resolveFacetsAndCustomContent();
        return this.customContent;
    }

    public VisitResult visit(VisitContext context, UIComponent target) {
        if (!target.isRendered()) {
            return VisitResult.REJECT;
        }
        if (!(target instanceof AjaxErrorHandler)) {
            return VisitResult.ACCEPT;
        }
        AjaxErrorHandler handler = (AjaxErrorHandler)target;
        if (handler.getType() == null) {
            this.resolved = false;
            this.defaultAjaxErrorHandler.add(handler);
        } else if (StringUtils.equals((CharSequence)handler.getType(), (CharSequence)this.type)) {
            this.resolved = false;
            this.typeAjaxErrorHandler.add(handler);
        }
        return VisitResult.REJECT;
    }
}

