/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.ajaxerrorhandler;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ViewExpiredException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.view.ViewDeclarationLanguage;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.primefaces.extensions.component.ajaxerrorhandler.AjaxErrorHandlerVisitCallback;

public class AjaxExceptionHandler
extends ExceptionHandlerWrapper {
    private static final Logger LOGGER = Logger.getLogger(AjaxExceptionHandler.class.getCanonicalName());
    private ExceptionHandler wrapped = null;

    public AjaxExceptionHandler(ExceptionHandler wrapped) {
        this.wrapped = wrapped;
    }

    public ExceptionHandler getWrapped() {
        return this.wrapped;
    }

    public void handle() throws FacesException {
        Iterable exceptionQueuedEvents;
        FacesContext context = FacesContext.getCurrentInstance();
        if (context.getPartialViewContext() != null && context.getPartialViewContext().isAjaxRequest() && (exceptionQueuedEvents = this.getUnhandledExceptionQueuedEvents()) != null && exceptionQueuedEvents.iterator() != null) {
            Iterator unhandledExceptionQueuedEvents = this.getUnhandledExceptionQueuedEvents().iterator();
            if (unhandledExceptionQueuedEvents.hasNext()) {
                Throwable exception = ((ExceptionQueuedEvent)unhandledExceptionQueuedEvents.next()).getContext().getException();
                unhandledExceptionQueuedEvents.remove();
                this.handlePartialResponseError(context, exception);
            }
            while (unhandledExceptionQueuedEvents.hasNext()) {
                unhandledExceptionQueuedEvents.next();
                unhandledExceptionQueuedEvents.remove();
            }
        }
        this.wrapped.handle();
    }

    public static String calculateViewUri(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        String viewId = (String)requestMap.get("javax.servlet.include.path_info");
        if (viewId == null) {
            viewId = context.getExternalContext().getRequestPathInfo();
        }
        if (viewId == null) {
            viewId = (String)requestMap.get("javax.servlet.include.servlet_path");
        }
        if (viewId == null) {
            viewId = context.getExternalContext().getRequestServletPath();
        }
        return viewId;
    }

    private void handlePartialResponseError(FacesContext context, Throwable t) {
        block23: {
            if (context.getResponseComplete()) {
                return;
            }
            if (!context.getExternalContext().isResponseCommitted()) {
                context.getExternalContext().responseReset();
            }
            try {
                List<UIComponent> customContent;
                UIComponent bodyFacet;
                String message;
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)t);
                if (context.getViewRoot() == null) {
                    try {
                        String uri = AjaxExceptionHandler.calculateViewUri(context);
                        UIViewRoot viewRoot = context.getApplication().getViewHandler().createView(context, uri);
                        context.setViewRoot(viewRoot);
                        if (rootCause == null && t instanceof IllegalArgumentException) {
                            rootCause = new ViewExpiredException(uri);
                        }
                        String viewId = viewRoot.getViewId();
                        ViewDeclarationLanguage vdl = context.getApplication().getViewHandler().getViewDeclarationLanguage(context, viewId);
                        vdl.buildView(context, viewRoot);
                    }
                    catch (Exception tt) {
                        LOGGER.log(Level.SEVERE, tt.getMessage(), tt);
                    }
                }
                String errorName = rootCause == null ? t.getClass().getCanonicalName() : rootCause.getClass().getCanonicalName();
                LOGGER.log(Level.SEVERE, "" + t.getMessage(), t);
                ExternalContext extContext = context.getExternalContext();
                extContext.addResponseHeader("Content-Type", "text/xml; charset=" + extContext.getRequestCharacterEncoding());
                extContext.addResponseHeader("Cache-Control", "no-cache");
                extContext.setResponseCharacterEncoding(extContext.getRequestCharacterEncoding());
                extContext.setResponseContentType("text/xml");
                PartialResponseWriter writer = context.getPartialViewContext().getPartialResponseWriter();
                writer.startDocument();
                writer.startElement("error", null);
                writer.startElement("error-name", null);
                writer.write(errorName);
                writer.endElement("error-name");
                writer.startElement("error-message", null);
                writer.startCDATA();
                String string = message = rootCause != null && rootCause.getMessage() != null ? rootCause.getMessage() : t.getMessage();
                if (message == null) {
                    message = "";
                }
                writer.write(message);
                writer.endCDATA();
                writer.endElement("error-message");
                writer.startElement("error-stacktrace", null);
                writer.startCDATA();
                String stackTrace = ExceptionUtils.getStackTrace((Throwable)(rootCause == null ? t : rootCause));
                if (stackTrace == null) {
                    stackTrace = "";
                }
                writer.write(stackTrace);
                writer.endCDATA();
                writer.endElement("error-stacktrace");
                writer.startElement("error-hostname", null);
                writer.write(this.getHostname());
                writer.endElement("error-hostname");
                UIViewRoot root = context.getViewRoot();
                AjaxErrorHandlerVisitCallback visitCallback = new AjaxErrorHandlerVisitCallback(errorName);
                if (root != null) {
                    try {
                        root.visitTree(VisitContext.createVisitContext((FacesContext)context), (VisitCallback)visitCallback);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "Problem with visitTree in AjaxExceptionHandler: ", e);
                    }
                }
                writer.startElement("error-timestamp", null);
                writer.write(this.getTimestamp(visitCallback.getTimestampFormat()));
                writer.endElement("error-timestamp");
                UIComponent titleFacet = visitCallback.findCurrentTitleFacet();
                if (titleFacet != null) {
                    writer.startElement("updateTitle", null);
                    writer.startCDATA();
                    try {
                        context.setResponseWriter((ResponseWriter)writer);
                        titleFacet.encodeAll(context);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Rendering titleUpdate in AjaxExceptionHandler throws exception!", e);
                        writer.write("<exception />");
                    }
                    writer.endCDATA();
                    writer.endElement("updateTitle");
                }
                if ((bodyFacet = visitCallback.findCurrentBodyFacet()) != null) {
                    writer.startElement("updateBody", null);
                    writer.startCDATA();
                    try {
                        context.setResponseWriter((ResponseWriter)writer);
                        bodyFacet.encodeAll(context);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Rendering bodyUpdate in AjaxExceptionHandler throws exception!", e);
                        writer.write("<exception />");
                    }
                    writer.endCDATA();
                    writer.endElement("updateBody");
                }
                if ((customContent = visitCallback.findCurrentChildren()) != null && customContent.size() > 0) {
                    writer.startElement("updateCustomContent", null);
                    writer.startCDATA();
                    try {
                        context.setResponseWriter((ResponseWriter)writer);
                        for (UIComponent component : customContent) {
                            component.encodeAll(context);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Rendering updateCustomContent in AjaxExceptionHandler throws exception!", e);
                        writer.write("<exception />");
                    }
                    writer.endCDATA();
                    writer.endElement("updateCustomContent");
                }
                writer.endElement("error");
                writer.endDocument();
                context.responseComplete();
            }
            catch (IOException e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block23;
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected String getHostname() throws UnknownHostException {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "???unknown???";
        }
    }

    protected String getTimestamp(String format) {
        if (format == null) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat dateFormatter = new SimpleDateFormat(format);
        return dateFormatter.format(new Date());
    }
}

