/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.documentviewer;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Locale;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang3.StringUtils;
import org.primefaces.extensions.component.documentviewer.DocumentViewer;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.DynamicResourceBuilder;

public class DocumentViewerRenderer
extends CoreRenderer {
    public static final String RENDERER_TYPE = "org.primefaces.extensions.component.DocumentViewerRenderer";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        DocumentViewer documentViewer = (DocumentViewer)component;
        this.encodeMarkup(context, documentViewer);
    }

    private void encodeMarkup(FacesContext context, DocumentViewer documentViewer) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("iframe", (UIComponent)documentViewer);
        writer.writeAttribute("id", (Object)documentViewer.getClientId(), null);
        writer.writeAttribute("style", (Object)documentViewer.getStyle(), null);
        writer.writeAttribute("width", documentViewer.getWidth() != null ? documentViewer.getWidth() : "100%", null);
        writer.writeAttribute("height", (Object)documentViewer.getHeight(), null);
        writer.writeAttribute("allowfullscreen", (Object)"", null);
        writer.writeAttribute("webkitallowfullscreen", (Object)"", null);
        writer.writeAttribute("src", (Object)this.generateSrc(context, documentViewer), null);
        writer.endElement("iframe");
    }

    private String generateSrc(FacesContext context, DocumentViewer documentViewer) throws IOException {
        String imageSrc;
        try {
            imageSrc = URLEncoder.encode(this.getDocumentSource(context, documentViewer), "UTF-8");
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        StringBuilder srcBuilder = new StringBuilder();
        srcBuilder.append(context.getExternalContext().getRequestContextPath());
        srcBuilder.append("/javax.faces.resource/");
        srcBuilder.append(this.getResourceURL(documentViewer, context));
        srcBuilder.append("file=");
        srcBuilder.append(imageSrc);
        srcBuilder.append(this.generateHashString(documentViewer, context));
        return srcBuilder.toString();
    }

    private String generateHashString(DocumentViewer documentViewer, FacesContext context) {
        ArrayList<String> params = new ArrayList<String>(1);
        params.add("locale=" + this.getCalculatedLocale(documentViewer, context));
        if (documentViewer.getPage() != null) {
            params.add("page=" + documentViewer.getPage());
        }
        if (!params.isEmpty()) {
            return "#" + StringUtils.join(params, (String)"&");
        }
        return "";
    }

    private String getResourceURL(DocumentViewer documentViewer, FacesContext context) {
        return "documentviewer/viewer.html.jsf?ln=primefaces-extensions-uncompressed&v=" + ((Object)((Object)this)).getClass().getPackage().getSpecificationVersion() + "&";
    }

    private Locale getCalculatedLocale(DocumentViewer documentViewer, FacesContext context) {
        Object locale = documentViewer.getLocale();
        if (locale == null) {
            return context.getViewRoot().getLocale();
        }
        if (locale instanceof Locale) {
            return (Locale)locale;
        }
        if (locale instanceof String) {
            return ComponentUtils.toLocale((String)((String)locale));
        }
        throw new IllegalArgumentException("Type:" + locale.getClass() + " is not a valid locale type for calendar:" + documentViewer.getClientId(context));
    }

    protected String getDocumentSource(FacesContext context, DocumentViewer documentViewer) throws UnsupportedEncodingException {
        String name = documentViewer.getName();
        if (name != null) {
            String libName = documentViewer.getLibrary();
            ResourceHandler handler = context.getApplication().getResourceHandler();
            Resource res = handler.createResource(name, libName);
            if (res == null) {
                return "RES_NOT_FOUND";
            }
            String requestPath = res.getRequestPath();
            return context.getExternalContext().encodeResourceURL(requestPath);
        }
        return DynamicResourceBuilder.build((FacesContext)context, (Object)documentViewer.getValue(), (UIComponent)documentViewer, (boolean)documentViewer.isCache(), (String)"sc");
    }
}

