/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.fluidgrid;

import java.io.IOException;
import java.util.Collection;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.extensions.component.fluidgrid.FluidGrid;
import org.primefaces.extensions.component.fluidgrid.UIFluidGridItem;
import org.primefaces.extensions.model.fluidgrid.FluidGridItem;
import org.primefaces.renderkit.CoreRenderer;

public class FluidGridRenderer
extends CoreRenderer {
    private static final String GRID_CLASS = "pe-fluidgrid";
    private static final String GRID_ITEM_CLASS = "pe-fluidgrid-item";
    private static final String LIST_ROLE = "list";
    private static final String LIST_ITEM_ROLE = "listitem";

    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext fc, UIComponent component) throws IOException {
        FluidGrid fluidGrid = (FluidGrid)component;
        this.encodeMarkup(fc, fluidGrid);
        this.encodeScript(fc, fluidGrid);
    }

    protected void encodeMarkup(FacesContext fc, FluidGrid fluidGrid) throws IOException {
        ResponseWriter writer = fc.getResponseWriter();
        String clientId = fluidGrid.getClientId(fc);
        String styleClass = fluidGrid.getStyleClass();
        styleClass = styleClass == null ? GRID_CLASS : "pe-fluidgrid " + styleClass;
        writer.startElement("div", (UIComponent)fluidGrid);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (fluidGrid.getStyle() != null) {
            writer.writeAttribute("style", (Object)fluidGrid.getStyle(), "style");
        }
        writer.writeAttribute("role", (Object)LIST_ROLE, null);
        if (fluidGrid.getVar() != null) {
            Object value = fluidGrid.getValue();
            if (value != null) {
                if (!(value instanceof Collection)) {
                    throw new FacesException("Value in FluidGrid must be of type Collection / List");
                }
                for (UIComponent kid : fluidGrid.getChildren()) {
                    if (!kid.isRendered() || kid instanceof UIFluidGridItem) continue;
                    this.renderChild(fc, kid);
                }
                Collection col = (Collection)value;
                for (FluidGridItem fluidGridItem : col) {
                    UIFluidGridItem uiItem = fluidGrid.getItem(fluidGridItem.getType());
                    if (!uiItem.isRendered()) continue;
                    fluidGrid.setData(fluidGridItem);
                    this.renderItem(fc, writer, fluidGrid, uiItem);
                }
            }
        } else {
            for (UIComponent kid : fluidGrid.getChildren()) {
                if (!kid.isRendered()) continue;
                if (kid instanceof UIFluidGridItem) {
                    this.renderItem(fc, writer, fluidGrid, (UIFluidGridItem)kid);
                    continue;
                }
                this.renderChild(fc, kid);
            }
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext fc, FluidGrid fluidGrid) throws IOException {
        String stamp;
        ResponseWriter writer = fc.getResponseWriter();
        String clientId = fluidGrid.getClientId(fc);
        String widgetVar = fluidGrid.resolveWidgetVar();
        this.startScript(writer, clientId);
        writer.write("$(function() {");
        writer.write("PrimeFacesExt.cw('FluidGrid','" + widgetVar + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",opts:{");
        writer.write("isFitWidth:" + fluidGrid.isFitWidth());
        writer.write(",isOriginLeft:" + fluidGrid.isOriginLeft());
        writer.write(",isOriginTop:" + fluidGrid.isOriginTop());
        writer.write(",isResizeBound:" + fluidGrid.isResizeBound());
        writer.write(",hasImages:" + fluidGrid.isHasImages());
        if (fluidGrid.gethGutter() != 0) {
            writer.write(",gutter:" + fluidGrid.gethGutter());
        }
        if ((stamp = SearchExpressionFacade.resolveComponentsForClient((FacesContext)fc, (UIComponent)fluidGrid, (String)fluidGrid.getStamp())) != null) {
            writer.write(",stamp:'" + stamp + "'");
        }
        if (fluidGrid.getTransitionDuration() != null) {
            writer.write(",transitionDuration:'" + fluidGrid.getTransitionDuration() + "'");
        } else {
            writer.write(",transitionDuration:0");
        }
        writer.write("}");
        this.encodeClientBehaviors(fc, fluidGrid);
        writer.write("},true);});");
        this.endScript(writer);
    }

    protected void renderItem(FacesContext fc, ResponseWriter writer, FluidGrid fluidGrid, UIFluidGridItem uiItem) throws IOException {
        writer.startElement("div", null);
        if (uiItem.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)("pe-fluidgrid-item " + uiItem.getStyleClass()), null);
        } else {
            writer.writeAttribute("class", (Object)GRID_ITEM_CLASS, null);
        }
        if (fluidGrid.getvGutter() != 0) {
            writer.writeAttribute("style", (Object)("margin-bottom: " + fluidGrid.getvGutter() + "px"), null);
        }
        writer.writeAttribute("role", (Object)LIST_ITEM_ROLE, null);
        uiItem.encodeAll(fc);
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

