/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.gchart.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.primefaces.extensions.component.gchart.model.GChartModel;
import org.primefaces.extensions.component.gchart.model.GChartModelRow;
import org.primefaces.extensions.component.gchart.model.GChartType;
import org.primefaces.extensions.util.json.GsonConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultGChartModel
implements GChartModel {
    private static final long serialVersionUID = -4757917806522708660L;
    private List<GChartModelRow> rows;
    private GChartType gChartType;
    private Map<String, Object> options;
    private List<String> columns;

    public DefaultGChartModel(List<GChartModelRow> rows, GChartType gChartType, Map<String, Object> options, List<String> columns) {
        this.rows = rows;
        this.gChartType = gChartType;
        this.options = options;
        this.columns = columns;
    }

    public GChartType getgChartType() {
        return this.gChartType;
    }

    @Override
    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Override
    public Collection<String> getColumns() {
        return this.columns;
    }

    @Override
    public GChartType getChartType() {
        return this.gChartType;
    }

    @Override
    public Collection<GChartModelRow> getRows() {
        return this.rows;
    }

    @Override
    public String toJson() {
        JsonObject root = new JsonObject();
        root.addProperty("type", this.getChartType().getChartName());
        root.add("options", GsonConverter.getGson().toJsonTree(this.getOptions()));
        root.add("data", this.extractData());
        return GsonConverter.getGson().toJson((JsonElement)root);
    }

    protected JsonElement extractData() {
        ArrayList<Collection<String>> dataTable = new ArrayList<Collection<String>>(0);
        dataTable.add(this.getColumns());
        for (GChartModelRow row : this.getRows()) {
            ArrayList<Object> dataRow = new ArrayList<Object>(0);
            dataRow.add(row.getLabel());
            dataRow.addAll(row.getValues());
            dataTable.add(dataRow);
        }
        return GsonConverter.getGson().toJsonTree(dataTable);
    }
}

